/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.apdu;

import de.bos_bremen.common.constants.Constants;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;

public abstract class GISOCommandConstants {
    public static final int BIT_INDEX_CHAIN_COMMAND = 4;
    public static final int COUNT_HEADER = 4;
    public static final int EXTENDED_MAX_LC = 65535;
    public static final int EXTENDED_MAX_LE = 65536;
    public static final int MIN_LC = 1;
    public static final int MIN_LE = 0;
    public static final int SHORT_MAX_LC = 255;
    public static final int SHORT_MAX_LE = 256;
    public static final int CASE_1 = 1;
    public static final int CASE_2 = 2;
    public static final int CASE_3 = 3;
    public static final int CASE_4 = 4;
    public static final Integer NO_LC = null;
    public static final Integer NO_LE = null;
    protected static final byte[] NO_DATA = null;
    public static final int INDEX_CLA = 0;
    public static final int INDEX_INS = 1;
    public static final int INDEX_P1 = 2;
    public static final int INDEX_P2 = 3;
    public static final int INDEX_LC_LE = 4;
    public static final int COUNT_SHORT = 1;
    public static final int COUNT_EXTENDED = 3;
    public static final int COUNT_EXTENDED_LE_CASE4 = 2;
    public static final byte EXTENDED_FILL_BYTE = 0;

    private GISOCommandConstants() {
    }

    public static enum CommandCaseEnum {
        CASE1("Case 1, Short Length/Extended Length", 1, NO_LC, NO_LE, null, false),
        CASE2_SHORT("Case 2, Short Length", 2, NO_LC, 1, null, false),
        CASE3_SHORT("Case 3, Short Length", 3, 1, NO_LE, null, false),
        CASE4_SHORT("Case 4, Short Length", 4, 1, 1, null, false),
        CASE2_EXTENDED("Case 2, Extended Length", 2, NO_LC, 3, (byte)0, true),
        CASE3_EXTENDED("Case 3, Extended Length", 3, 3, NO_LE, (byte)0, true),
        CASE4_EXTENDED("Case 4, Extended Length", 4, 3, 2, (byte)0, true);

        private String name = null;
        private int isoCase = -1;
        private Integer byteCountLC = null;
        private Integer byteCountLE = null;
        private Byte fillByte = null;
        private boolean extendedLength = false;
        private Integer lcMaximum = NO_LC;
        private Integer leMaximum = NO_LE;
        private int minimumLength = -1;
        private Integer maximumLength = -1;

        private CommandCaseEnum(String name, int isoCase, Integer byteCountLC, Integer byteCountLE, Byte fillByte, boolean extendedLength) {
            this.name = name;
            this.isoCase = isoCase;
            this.byteCountLC = byteCountLC;
            this.byteCountLE = byteCountLE;
            this.fillByte = fillByte;
            boolean dataPresent = byteCountLC != NO_LC;
            this.extendedLength = extendedLength;
            this.leMaximum = !this.extendedLength ? 256 : 65536;
            this.lcMaximum = !this.extendedLength ? 255 : 65535;
            switch (isoCase) {
                case 1: {
                    this.lcMaximum = NO_LC;
                    this.leMaximum = NO_LE;
                    break;
                }
                case 2: {
                    this.lcMaximum = NO_LC;
                    break;
                }
                case 3: {
                    this.leMaximum = NO_LE;
                    break;
                }
            }
            this.minimumLength = 4;
            this.minimumLength += this.byteCountLC != null ? this.byteCountLC : 0;
            this.minimumLength += this.byteCountLE != null ? this.byteCountLE : 0;
            this.maximumLength = this.minimumLength;
            if (dataPresent) {
                ++this.minimumLength;
                this.maximumLength = this.extendedLength ? Integer.valueOf(this.maximumLength + 65535) : Integer.valueOf(this.maximumLength + 255);
            }
        }

        public byte[] createLCBytes(Integer lc) throws IllegalArgumentException {
            if (this.byteCountLC == NO_LC && lc == NO_LC) {
                return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
            }
            if (this.byteCountLC == NO_LC && lc != NO_LC) {
                throw new IllegalArgumentException("case without LC, value not permitted");
            }
            if (this.byteCountLC != NO_LC && lc == NO_LC) {
                throw new IllegalArgumentException("case with LC, value not permitted as null");
            }
            if (lc != NO_LC && (lc < 1 || lc > this.lcMaximum)) {
                throw new IllegalArgumentException("LC only greater equals 0 and less equals " + this.lcMaximum + " permitted");
            }
            return GISOCommandAPDUUtil.createLCBytes(this.isExtended(), lc);
        }

        public byte[] createLEBytes(Integer le) {
            if (this.byteCountLE == NO_LE && le == NO_LE) {
                return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
            }
            if (this.byteCountLE == NO_LE && le != NO_LE) {
                throw new IllegalArgumentException("case without LE, value not permitted");
            }
            if (this.byteCountLE != NO_LE && le == NO_LE) {
                throw new IllegalArgumentException("case with LE, value not permitted as null");
            }
            if (le != NO_LE && (le < 0 || le > this.leMaximum)) {
                throw new IllegalArgumentException("LE only greater equals 0 and less equals " + this.leMaximum + " permitted");
            }
            return GISOCommandAPDUUtil.createLEBytes(this.isExtended(), le, this);
        }

        public String getName() {
            return this.name;
        }

        public int getISOCase() {
            return this.isoCase;
        }

        public Integer getByteCountLC() {
            return this.byteCountLC;
        }

        public Integer getByteCountLE() {
            return this.byteCountLE;
        }

        public Byte getFillByte() {
            return this.fillByte;
        }

        public boolean isExtended() {
            return this.extendedLength;
        }

        public boolean isShort() {
            return !this.extendedLength;
        }

        public boolean isCommandDataPresent() {
            return this.byteCountLC != NO_LC;
        }

        public boolean isLEPresent() {
            return this.byteCountLE != NO_LE;
        }

        public Integer getMaximumLC() {
            return this.lcMaximum;
        }

        public Integer getMaximumLE() {
            return this.leMaximum;
        }

        public int getMinimumLength() {
            return this.minimumLength;
        }

        public int getMaximumLength() {
            return this.maximumLength;
        }
    }
}

