/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.apdu;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.constants.Constants;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDU;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import java.math.BigInteger;
import opencard.core.terminal.CommandAPDU;

public class GISOCommandAPDUUtil {
    private GISOCommandAPDUUtil() {
    }

    public static byte[] checkData(byte[] data) {
        if (data != null && data.length > 0) {
            return data;
        }
        return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
    }

    public static Byte getCLA(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            return ((GISOCommandAPDU)command).getCLA();
        }
        int result = command.getByte(0);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public static Byte getINS(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            return ((GISOCommandAPDU)command).getINS();
        }
        int result = command.getByte(1);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public static Byte getP1(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            return ((GISOCommandAPDU)command).getP1();
        }
        int result = command.getByte(2);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public static Byte getP2(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            return ((GISOCommandAPDU)command).getP2();
        }
        int result = command.getByte(3);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public static byte[] getHeader(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        byte[] cmdBytes = command.getBytes();
        if (cmdBytes == null || cmdBytes.length < 4) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        byte[] result = new byte[4];
        if (GISOCommandAPDU.class.isInstance(command)) {
            GISOCommandAPDU isoCmd = (GISOCommandAPDU)command;
            return isoCmd.getHeader();
        }
        result[0] = cmdBytes[0];
        result[1] = cmdBytes[1];
        result[2] = cmdBytes[2];
        result[3] = cmdBytes[3];
        return result;
    }

    public static Integer getLC(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum commandCase = null;
        commandCase = GISOCommandAPDU.class.isInstance(command) ? ((GISOCommandAPDU)command).getCommandCase() : GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU");
        }
        return GISOCommandAPDUUtil.getLC(command, commandCase);
    }

    public static Integer getLC(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        GISOCommandAPDUUtil.checkSimpleCommandAndCommandCase(command, commandCase);
        byte[] lcBytes = GISOCommandAPDUUtil.getLCBytes(command, commandCase);
        if (lcBytes == Constants.EMPTY_PRIMITIVE_BYTE_ARRAY) {
            return GISOCommandConstants.NO_LC;
        }
        return new BigInteger(1, lcBytes).intValue();
    }

    public static byte[] getLCBytes(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        GISOCommandAPDUUtil.checkSimpleCommandAndCommandCase(command, commandCase);
        if (!commandCase.isCommandDataPresent()) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        Integer lcByteCount = commandCase.getByteCountLC();
        byte[] lcBytes = new byte[lcByteCount.intValue()];
        for (int i = 0; i < lcBytes.length; ++i) {
            lcBytes[i] = (byte)command.getByte(4 + i);
        }
        return lcBytes;
    }

    public static Integer getLE(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        byte[] leBytes = GISOCommandAPDUUtil.getLEBytes(command, commandCase);
        if (leBytes == Constants.EMPTY_PRIMITIVE_BYTE_ARRAY) {
            return GISOCommandConstants.NO_LE;
        }
        return new BigInteger(1, leBytes).intValue();
    }

    public static byte[] getLEBytes(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) {
        GISOCommandAPDUUtil.checkSimpleCommandAndCommandCase(command, commandCase);
        if (!commandCase.isLEPresent()) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        Integer leByteCount = commandCase.getByteCountLE();
        byte[] leBytes = new byte[leByteCount.intValue()];
        int l = command.getLength();
        for (int i = 0; i < leBytes.length; ++i) {
            leBytes[i] = (byte)command.getByte(l - leByteCount + i);
        }
        return leBytes;
    }

    public static Integer getLC(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("bytes not permitted as null");
        }
        CommandAPDU command = new CommandAPDU(cmdBytes);
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matching command case found");
        }
        return GISOCommandAPDUUtil.getLC(command, commandCase);
    }

    public static Integer getLC(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        CommandAPDU command = new CommandAPDU(cmdBytes);
        return GISOCommandAPDUUtil.getLC(command, commandCase);
    }

    public static byte[] getLCBytes(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("command not permitted, no matching command case found");
        }
        return GISOCommandAPDUUtil.getLCBytes(command, commandCase);
    }

    public static byte[] getLCBytes(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("command bytes not permitted as null");
        }
        CommandAPDU command = new CommandAPDU(cmdBytes);
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrond coded APDU, no matching command case found");
        }
        return GISOCommandAPDUUtil.getLCBytes(command, commandCase);
    }

    public static byte[] getLCBytes(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        return GISOCommandAPDUUtil.getLCBytes(new CommandAPDU(cmdBytes), commandCase);
    }

    public static byte[] getData(CommandAPDU command) throws IllegalArgumentException {
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matching command case found");
        }
        return GISOCommandAPDUUtil.getData(command, commandCase);
    }

    public static byte[] getData(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandAndCommandCase(command, commandCase);
        if (!commandCase.isCommandDataPresent()) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        Integer l = GISOCommandAPDUUtil.getLC(command, commandCase);
        Integer lcByteCount = commandCase.getByteCountLC();
        byte[] dataBytes = null;
        if (GISOCommandAPDU.class.isInstance(command)) {
            dataBytes = ((GISOCommandAPDU)command).getData();
        } else {
            int beginIndex = 4 + lcByteCount;
            int endIndex = beginIndex + l;
            dataBytes = command.getBytes();
            dataBytes = ByteUtil.subbytes(dataBytes, beginIndex, endIndex);
        }
        return dataBytes;
    }

    public static byte[] getData(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("bytes not permitted as null");
        }
        return GISOCommandAPDUUtil.getData(new CommandAPDU(cmdBytes));
    }

    public static byte[] getData(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        return GISOCommandAPDUUtil.getData(new CommandAPDU(cmdBytes), commandCase);
    }

    public static byte[] getData(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase, Boolean extended) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        if (extended == null) {
            extended = commandCase.isExtended();
        } else if (commandCase.isExtended() != extended.booleanValue()) {
            throw new IllegalArgumentException("inconsistent arguments - case of command and format different");
        }
        return GISOCommandAPDUUtil.getData(new CommandAPDU(cmdBytes), commandCase);
    }

    public static Integer getLE(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        commandCase = GISOCommandAPDU.class.isInstance(command) ? ((GISOCommandAPDU)command).getCommandCase() : GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU");
        }
        if (!commandCase.isLEPresent()) {
            return GISOCommandConstants.NO_LE;
        }
        Integer leByteCount = commandCase.getByteCountLE();
        Integer lcByteCount = commandCase.getByteCountLC();
        if (lcByteCount == GISOCommandConstants.NO_LC) {
            lcByteCount = Constants.INTEGER_ZERO;
        } else {
            Integer ll = GISOCommandAPDUUtil.getLC(command, commandCase);
            lcByteCount = lcByteCount + ll;
        }
        byte[] leBytes = new byte[leByteCount.intValue()];
        for (int i = 0; i < leBytes.length; ++i) {
            leBytes[i] = (byte)command.getByte(4 + lcByteCount + i);
        }
        return new BigInteger(1, leBytes).intValue();
    }

    public static Integer getLE(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("bytes not permitted as null");
        }
        CommandAPDU command = new CommandAPDU(cmdBytes);
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matching command case found");
        }
        return GISOCommandAPDUUtil.getLE(command, commandCase);
    }

    public static Integer getLE(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        return GISOCommandAPDUUtil.getLE(new CommandAPDU(cmdBytes), commandCase);
    }

    public static byte[] getLEBytes(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matching command case found");
        }
        return GISOCommandAPDUUtil.getLEBytes(command, commandCase);
    }

    public static byte[] getLEBytes(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("bytes not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum isoCase = GISOCommandAPDUUtil.getCommandCase(cmdBytes);
        return GISOCommandAPDUUtil.getLEBytes(cmdBytes, isoCase);
    }

    public static byte[] getLEBytes(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        byte[] result = null;
        switch (commandCase.getISOCase()) {
            case 1: 
            case 3: {
                result = Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
                break;
            }
            case 2: 
            case 4: {
                boolean extendedLength = GISOCommandAPDUUtil.isExtended(cmdBytes, commandCase);
                int length = GISOCommandAPDUUtil.getLE(cmdBytes, commandCase);
                result = GISOCommandAPDUUtil.createLEBytes(extendedLength, length, commandCase);
            }
        }
        return result;
    }

    public static GISOCommandConstants.CommandCaseEnum getCommandCase(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            return ((GISOCommandAPDU)command).getCommandCase();
        }
        return GISOCommandAPDUUtil.getCommandCaseInt(command);
    }

    private static GISOCommandConstants.CommandCaseEnum getCommandCaseInt(CommandAPDU command) throws IllegalArgumentException {
        int l = command.getLength();
        if (l < 4) {
            return null;
        }
        if (l == 4) {
            return GISOCommandConstants.CommandCaseEnum.CASE1;
        }
        if (l == 5) {
            return GISOCommandConstants.CommandCaseEnum.CASE2_SHORT;
        }
        int intIndexLcLe = command.getByte(4);
        if (l == 7 && intIndexLcLe == 0) {
            return GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED;
        }
        if (intIndexLcLe == 0 && l > 5) {
            byte[] lengthBytes = new byte[3];
            for (int i = 0; i < lengthBytes.length; ++i) {
                lengthBytes[i] = (byte)command.getByte(4 + i);
            }
            int ll = new BigInteger(1, lengthBytes).intValue();
            if (l == 7 + ll) {
                return GISOCommandConstants.CommandCaseEnum.CASE3_EXTENDED;
            }
            if (l == 7 + ll + 3 - 1) {
                return GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED;
            }
        } else if (intIndexLcLe != 0 && l > 5) {
            if (l == 5 + intIndexLcLe) {
                return GISOCommandConstants.CommandCaseEnum.CASE3_SHORT;
            }
            if (l == 5 + intIndexLcLe + 1) {
                return GISOCommandConstants.CommandCaseEnum.CASE4_SHORT;
            }
        }
        throw new IllegalArgumentException("wrong coded APDU");
    }

    public static GISOCommandConstants.CommandCaseEnum getCommandCase(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("command bytes not permitted as null");
        }
        return GISOCommandAPDUUtil.getCommandCase(new CommandAPDU(cmdBytes));
    }

    public static boolean isExtended(CommandAPDU command) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum commandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (commandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matchin command case found");
        }
        return GISOCommandAPDUUtil.isExtended(command, commandCase);
    }

    public static boolean isExtended(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandAndCommandCase(command, commandCase);
        return commandCase.isExtended();
    }

    public static boolean isExtended(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("command bytes not permitted as null");
        }
        if (cmdBytes.length < 4) {
            throw new IllegalArgumentException("command bytes only as byte-array of 4 bytes permitted only");
        }
        return GISOCommandAPDUUtil.isExtended(new CommandAPDU(cmdBytes));
    }

    public static boolean isExtended(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        GISOCommandAPDUUtil.checkSimpleCommandBytesAndCommandCase(cmdBytes, commandCase);
        return GISOCommandAPDUUtil.isExtended(new CommandAPDU(cmdBytes), commandCase);
    }

    private static void checkSimpleCommandAndCommandCase(CommandAPDU command, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        if (commandCase == null) {
            throw new IllegalArgumentException("command case not permitted as null");
        }
        GISOCommandConstants.CommandCaseEnum cce = GISOCommandAPDUUtil.getCommandCase(command);
        if (cce != commandCase) {
            throw new IllegalArgumentException("command case of command not permitted to be different to command case");
        }
    }

    private static void checkSimpleCommandBytesAndCommandCase(byte[] cmdBytes, GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("command bytes not permitted as null");
        }
        if (commandCase == null) {
            throw new IllegalArgumentException("command case not permitted as null");
        }
        if (cmdBytes.length < 4) {
            throw new IllegalArgumentException("command bytes only as byte-array of 4 bytes permitted only");
        }
        if (cmdBytes.length < commandCase.getMinimumLength()) {
            throw new IllegalArgumentException("inconsistent bytes and case - count of bytes less than minimum of case: " + commandCase + " - " + commandCase.getMinimumLength());
        }
        if (cmdBytes.length > commandCase.getMaximumLength()) {
            throw new IllegalArgumentException("inconsistent bytes and case - count of bytes greater less than maximum of case: " + commandCase + " - " + commandCase.getMaximumLength());
        }
        if (commandCase.isExtended() && cmdBytes[4] != 0) {
            throw new IllegalArgumentException("first byte for LC/LE extended not permitted: 0");
        }
        int lc = 0;
        int le = 0;
        if (commandCase.isCommandDataPresent()) {
            if (commandCase.isShort()) {
                byte[] lcb = ByteUtil.subbytes(cmdBytes, 4, 5);
                lc = new BigInteger(1, lcb).intValue();
                ++lc;
            } else {
                byte[] lcb = ByteUtil.subbytes(cmdBytes, 4, 7);
                lc = new BigInteger(1, lcb).intValue();
                lc += 3;
            }
        }
        if (commandCase.isLEPresent()) {
            if (commandCase.isShort()) {
                le = 1;
            } else {
                int n = le = commandCase.isCommandDataPresent() ? 2 : 3;
            }
        }
        if (cmdBytes.length != 4 + lc + le) {
            throw new IllegalArgumentException("incorrect count of bytes for command according to command case - lc/le fault");
        }
    }

    public static CommandAPDU changeCLA(CommandAPDU command, byte cla) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            ((GISOCommandAPDU)command).setCLA(cla);
        } else {
            if (command.getBuffer().length < 1) {
                throw new IllegalArgumentException("buffer of command too small");
            }
            if (command.getLength() == 0) {
                command.append(cla);
            } else if (command.getLength() > 0) {
                command.setByte(0, cla);
            }
        }
        return command;
    }

    public static CommandAPDU changeINS(CommandAPDU command, byte ins) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            ((GISOCommandAPDU)command).setINS(ins);
        } else {
            if (command.getBuffer().length < 2) {
                throw new IllegalArgumentException("buffer of command too small");
            }
            if (command.getLength() == 1) {
                command.append(ins);
            } else if (command.getLength() > 1) {
                command.setByte(1, ins);
            } else {
                throw new IllegalArgumentException("content of command not filled correct");
            }
        }
        return command;
    }

    public static CommandAPDU changeP1(CommandAPDU command, byte p1) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            ((GISOCommandAPDU)command).setP1(p1);
        } else {
            if (command.getBuffer().length < 3) {
                throw new IllegalArgumentException("buffer of command too small");
            }
            if (command.getLength() == 2) {
                command.append(p1);
            } else if (command.getLength() > 2) {
                command.setByte(2, p1);
            } else {
                throw new IllegalArgumentException("content of command not filled correct");
            }
        }
        return command;
    }

    public static CommandAPDU changeP2(CommandAPDU command, byte p2) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            ((GISOCommandAPDU)command).setP2(p2);
        } else {
            if (command.getBuffer().length < 4) {
                throw new IllegalArgumentException("buffer of command too small");
            }
            if (command.getLength() == 3) {
                command.append(p2);
            } else if (command.getLength() > 3) {
                command.setByte(3, p2);
            }
        }
        return command;
    }

    public static CommandAPDU changeLE(CommandAPDU command, Integer le) throws IllegalArgumentException {
        if (command == null) {
            throw new IllegalArgumentException("command not permitted as null");
        }
        if (le != null && le < 0) {
            throw new IllegalArgumentException("le not permitted as negative value");
        }
        if (le != null && le > 65536) {
            throw new IllegalArgumentException("le not permitted as value greater maximum: 65536");
        }
        if (GISOCommandAPDU.class.isInstance(command)) {
            ((GISOCommandAPDU)command).setLE(le);
            return command;
        }
        GISOCommandConstants.CommandCaseEnum currentCommandCase = GISOCommandAPDUUtil.getCommandCase(command);
        if (currentCommandCase == null) {
            throw new IllegalArgumentException("wrong coded APDU, no matching command case found");
        }
        if (GISOCommandAPDUUtil.getLE(command, currentCommandCase) == le) {
            return command;
        }
        int l = 0;
        GISOCommandConstants.CommandCaseEnum newCommandCase = currentCommandCase;
        if (!currentCommandCase.isLEPresent() && le != GISOCommandConstants.NO_LE) {
            if (currentCommandCase == GISOCommandConstants.CommandCaseEnum.CASE1) {
                newCommandCase = le <= 256 ? GISOCommandConstants.CommandCaseEnum.CASE2_SHORT : GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED;
            } else if (currentCommandCase.getISOCase() == 3) {
                newCommandCase = !currentCommandCase.isExtended() && le <= 256 ? GISOCommandConstants.CommandCaseEnum.CASE4_SHORT : GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED;
            }
        } else {
            if (currentCommandCase.isLEPresent() && le == GISOCommandConstants.NO_LE) {
                command.setLength(command.getLength() - currentCommandCase.getByteCountLE());
                return command;
            }
            if (currentCommandCase.isLEPresent() && le != GISOCommandConstants.NO_LE) {
                if (currentCommandCase.isExtended() && currentCommandCase.getISOCase() == 4 || le > 256) {
                    newCommandCase = !currentCommandCase.isCommandDataPresent() ? GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED : GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED;
                } else if (le <= 256) {
                    newCommandCase = !currentCommandCase.isCommandDataPresent() ? GISOCommandConstants.CommandCaseEnum.CASE2_SHORT : GISOCommandConstants.CommandCaseEnum.CASE4_SHORT;
                }
            }
        }
        int leIndex = 4;
        if (newCommandCase.isCommandDataPresent()) {
            leIndex += newCommandCase.getByteCountLC().intValue();
            leIndex += GISOCommandAPDUUtil.getLC(command, currentCommandCase).intValue();
        }
        l = leIndex + newCommandCase.getByteCountLE();
        byte[] leBytes = GISOCommandAPDUUtil.createLEBytes(newCommandCase.isExtended(), le, newCommandCase);
        if (l > command.getBuffer().length) {
            CommandAPDU newCommandAPDU = new CommandAPDU(command.getBytes().length + 6 + command.getLength());
            byte[] buffer = newCommandAPDU.getBuffer();
            byte[] data = GISOCommandAPDUUtil.getData(command, currentCommandCase);
            byte[] lcBytes = data.length > 0 ? GISOCommandAPDUUtil.createLCBytes(newCommandCase.isExtended(), data.length) : Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
            System.arraycopy(command.getBuffer(), 0, buffer, 0, 4);
            if (data.length > 0) {
                System.arraycopy(lcBytes, 0, buffer, 4, lcBytes.length);
                System.arraycopy(data, 0, buffer, 4 + lcBytes.length, data.length);
            }
            System.arraycopy(leBytes, 0, buffer, leIndex, leBytes.length);
            newCommandAPDU.setLength(l);
            return newCommandAPDU;
        }
        if (currentCommandCase == newCommandCase) {
            for (int i = 0; i < leBytes.length; ++i) {
                command.setByte(leIndex + i, leBytes[i]);
            }
        } else if (newCommandCase.isShort()) {
            byte[] buffer = command.getBuffer();
            command.setLength(l);
            System.arraycopy(leBytes, 0, buffer, leIndex, leBytes.length);
        }
        return command;
    }

    public static byte[] createLCBytes(boolean extended, int dataLength) throws IllegalArgumentException {
        if (dataLength < 1) {
            throw new IllegalArgumentException("length of data too small, value greater equals 1 permitted only");
        }
        if (dataLength > 65535) {
            throw new IllegalArgumentException("length of data too small, value less  equals 65535 permitted only");
        }
        byte[] result = null;
        if (!extended && dataLength < 256) {
            result = new byte[]{(byte)dataLength};
        } else {
            int l = 3;
            result = new byte[l];
            byte[] tmp = BigInteger.valueOf(dataLength).toByteArray();
            System.arraycopy(tmp, 0, result, l - tmp.length, tmp.length);
        }
        return result;
    }

    public static byte[] createLEBytes(boolean extendedLength, int le, GISOCommandConstants.CommandCaseEnum isoCase) throws IllegalArgumentException {
        if (isoCase == null) {
            throw new IllegalArgumentException("iso case not permitted as null");
        }
        if (isoCase == GISOCommandConstants.CommandCaseEnum.CASE1 || isoCase == GISOCommandConstants.CommandCaseEnum.CASE3_SHORT || isoCase == GISOCommandConstants.CommandCaseEnum.CASE3_EXTENDED) {
            throw new IllegalArgumentException("creating LE bytes only possible for cases with present LE");
        }
        if (extendedLength != isoCase.isExtended()) {
            throw new IllegalArgumentException("extended and case inconsistent");
        }
        if (le < 0) {
            throw new IllegalArgumentException("LE less minimum 0 not permitted");
        }
        if (le > isoCase.getMaximumLE()) {
            throw new IllegalArgumentException("LE greater maximum " + isoCase.getMaximumLE() + " not permitted");
        }
        byte[] result = null;
        if (!extendedLength && le <= 256) {
            result = new byte[]{(byte)le};
        } else {
            int l = 3;
            switch (isoCase.getISOCase()) {
                case 4: {
                    l = 2;
                }
            }
            result = new byte[l];
            byte[] tmp = BigInteger.valueOf(le).toByteArray();
            if (l != 2 || l == 2 && tmp.length <= 2) {
                System.arraycopy(tmp, 0, result, l - tmp.length, tmp.length);
                if (isoCase.getISOCase() == 2) {
                    result[0] = 0;
                }
            } else {
                result = ByteUtil.subbytes(tmp, 1);
            }
        }
        return result;
    }

    public static int getMaximumSize(byte[] data, Integer le) throws IllegalArgumentException {
        if (data != null && data.length > 65535) {
            throw new IllegalArgumentException("data-array exceeds maximum value: 65535");
        }
        if (le != null && le > 65536) {
            throw new IllegalArgumentException("LE exceeds maximum value: 65536");
        }
        int result = 4;
        if (data != null && data.length > 0) {
            result += 3;
            result += data.length;
            if (le != null) {
                --result;
            }
        }
        if (le != GISOCommandConstants.NO_LE) {
            result += 3;
        }
        return result;
    }
}

