/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf.apdu;

import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.constants.Constants;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandAPDUUtil;
import de.bos_bremen.gov2.jca_provider.ocf.apdu.GISOCommandConstants;
import opencard.core.terminal.CommandAPDU;
import opencard.core.util.HexString;

public class GISOCommandAPDU
extends CommandAPDU {
    public static final int DEFAULT_SIZE = 4;
    private GISOCommandConstants.CommandCaseEnum commandCase = null;

    public GISOCommandAPDU() {
        super(4);
    }

    public GISOCommandAPDU(Byte classByte, Byte instruction, Byte p1, Byte p2) {
        this(false, classByte, instruction, p1, p2);
    }

    public GISOCommandAPDU(boolean extendedLength, Byte classByte, Byte instruction, Byte p1, Byte p2) {
        this(extendedLength, classByte, instruction, p1, p2, Constants.EMPTY_PRIMITIVE_BYTE_ARRAY, GISOCommandConstants.NO_LE);
    }

    public GISOCommandAPDU(Byte classByte, Byte instruction, Byte p1, Byte p2, Integer le) {
        this(false, classByte, instruction, p1, p2, le);
    }

    public GISOCommandAPDU(boolean extendedLength, Byte classByte, Byte instruction, Byte p1, Byte p2, Integer le) {
        this(extendedLength, classByte, instruction, p1, p2, Constants.EMPTY_PRIMITIVE_BYTE_ARRAY, le);
    }

    public GISOCommandAPDU(Byte classByte, Byte instruction, Byte p1, Byte p2, byte[] data) {
        this(false, classByte, instruction, p1, p2, data);
    }

    public GISOCommandAPDU(boolean extendedLength, Byte classByte, Byte instruction, Byte p1, Byte p2, byte[] data) {
        this(extendedLength, classByte, instruction, p1, p2, data, GISOCommandConstants.NO_LE);
    }

    public GISOCommandAPDU(Byte classByte, Byte instruction, Byte p1, Byte p2, byte[] data, Integer le) {
        this(false, classByte, instruction, p1, p2, data, le);
    }

    public GISOCommandAPDU(boolean extendedLength, Byte classByte, Byte instruction, Byte p1, Byte p2, byte[] data, Integer le) {
        super(GISOCommandAPDUUtil.getMaximumSize(data, le));
        this.init(null, extendedLength, classByte, instruction, p1, p2, data, le);
    }

    public GISOCommandAPDU(boolean extendedLength, byte[] header, byte[] data, Integer le) {
        super(GISOCommandAPDUUtil.getMaximumSize(data, le));
        if (header == null) {
            throw new IllegalArgumentException("header not permitted as null");
        }
        this.checkHeader(header);
        this.init(null, extendedLength, header[0], header[1], header[2], header[3], data, le);
    }

    public GISOCommandAPDU(byte[] cmdBytes) throws IllegalArgumentException {
        super(GISOCommandAPDU.checkBytes(cmdBytes));
        this.init(cmdBytes);
    }

    private static byte[] checkBytes(byte[] cmdBytes) throws IllegalArgumentException {
        if (cmdBytes == null) {
            throw new IllegalArgumentException("bytes of command not permitted as null");
        }
        if (cmdBytes.length > 65544) {
            throw new IllegalArgumentException("bytes of command exceed maximum length: 65544");
        }
        if (cmdBytes.length > 261 && cmdBytes[4] != 0) {
            throw new IllegalArgumentException("bytes of command contain wrong coded length, extended length not indicated by expected leading byte " + HexUtil.hexify((byte)0));
        }
        return cmdBytes;
    }

    public byte[] getHeader() {
        if (this.apdu_length >= 4) {
            return ByteUtil.subbytes(this.apdu_buffer, 0, 4);
        }
        return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
    }

    public void setHeader(byte[] header) throws IllegalArgumentException {
        this.checkHeader(header);
        block6: for (int i = 0; i < header.length; ++i) {
            switch (i) {
                case 0: {
                    this.setCLA(header[i]);
                    continue block6;
                }
                case 1: {
                    this.setINS(header[i]);
                    continue block6;
                }
                case 2: {
                    this.setP1(header[i]);
                    continue block6;
                }
                case 3: {
                    this.setP2(header[i]);
                }
            }
        }
    }

    private void checkHeader(byte[] header) throws IllegalArgumentException {
        if (header == null || header.length != 4) {
            throw new IllegalArgumentException("header not permitted: null or not 4 bytes");
        }
    }

    public Byte getCLA() {
        int result = super.getByte(0);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public void setCLA(byte cla) {
        if (this.apdu_length <= 0) {
            super.append(cla);
        } else {
            super.setByte(0, cla);
        }
    }

    public Byte getINS() {
        int result = super.getByte(1);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public void setINS(byte ins) {
        while (this.apdu_length <= 1) {
            super.append((byte)0);
        }
        super.setByte(1, ins);
    }

    public Byte getP1() {
        int result = super.getByte(2);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public void setP1(Byte p1) {
        while (this.apdu_length <= 2) {
            super.append((byte)0);
        }
        super.setByte(2, p1.byteValue());
    }

    public Byte getP2() {
        int result = super.getByte(3);
        if (result == -1) {
            return null;
        }
        return (byte)result;
    }

    public void setP2(Byte p2) {
        while (this.apdu_length <= 3) {
            super.append((byte)0);
        }
        super.setByte(3, p2.byteValue());
    }

    public Integer getLC() {
        if (this.commandCase == null) {
            return GISOCommandConstants.NO_LC;
        }
        return GISOCommandAPDUUtil.getLC(super.getBytes(), this.commandCase);
    }

    public byte[] getLCBytes() {
        if (this.commandCase == null) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        return GISOCommandAPDUUtil.getLCBytes(super.getBytes(), this.commandCase);
    }

    public byte[] getData() {
        if (this.commandCase == null || !this.commandCase.isCommandDataPresent()) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        int beginIndex = 4 + this.commandCase.getByteCountLC();
        int endIndex = super.getLength();
        if (this.commandCase.isLEPresent()) {
            endIndex -= this.commandCase.getByteCountLE().intValue();
        }
        return ByteUtil.subbytes(this.apdu_buffer, beginIndex, endIndex);
    }

    public void setData(byte[] data) {
        this.init(null, this.commandCase != null ? this.commandCase.isExtended() : false, this.getCLA(), this.getINS(), this.getP1(), this.getP2(), data, this.getLE());
    }

    public Integer getLE() {
        if (this.commandCase == null) {
            return GISOCommandConstants.NO_LE;
        }
        return GISOCommandAPDUUtil.getLE(super.getBytes(), this.commandCase);
    }

    public void setLE(Integer le) throws IllegalArgumentException {
        if (le != null && le < 0) {
            throw new IllegalArgumentException("LE not permitted less than 0");
        }
        if (this.apdu_buffer.length < 7) {
            this.apdu_buffer = ByteUtil.extend(this.apdu_buffer, 8);
        }
        while (this.apdu_length < 4) {
            super.append((byte)0);
        }
        this.init(null, this.commandCase != null ? this.commandCase.isExtended() : false, this.getCLA(), this.getINS(), this.getP1(), this.getP2(), this.getData(), le);
    }

    public byte[] getLEBytes() {
        if (this.commandCase == null) {
            return Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        }
        return GISOCommandAPDUUtil.getLEBytes(super.getBytes(), this.commandCase);
    }

    public Integer getISOCase() {
        return this.commandCase != null ? Integer.valueOf(this.commandCase.getISOCase()) : null;
    }

    public GISOCommandConstants.CommandCaseEnum getCommandCase() {
        return this.commandCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandCase(GISOCommandConstants.CommandCaseEnum commandCase) throws IllegalArgumentException {
        if (commandCase == null) {
            throw new IllegalArgumentException("case not permitted as null");
        }
        GISOCommandAPDU gISOCommandAPDU = this;
        synchronized (gISOCommandAPDU) {
            if (this.commandCase == null) {
                return;
            }
            if (this.commandCase == commandCase) {
                return;
            }
            if (this.commandCase != null && this.commandCase.getISOCase() != commandCase.getISOCase()) {
                throw new IllegalArgumentException("illegal case change, current case is " + this.commandCase.getISOCase() + ", not possible change to case " + commandCase.getISOCase());
            }
            Integer le = this.getLE();
            if (le != null && le == 0) {
                throw new IllegalArgumentException("illegal case change, current case " + commandCase.getISOCase() + " not changeable from short to extended or extended to short, according to ISO 7816-4 a LE of 0 means different values as 256 or 65536 response length");
            }
            this.init(null, commandCase.isExtended(), this.getCLA(), this.getINS(), this.getP1(), this.getP2(), this.getData(), this.getLE());
        }
    }

    public boolean isExtended() {
        if (this.commandCase == null) {
            return false;
        }
        return this.commandCase.isExtended();
    }

    public void setExtended(boolean extended) {
        if (this.commandCase == null || extended == this.commandCase.isExtended() || this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE1) {
            return;
        }
        GISOCommandConstants.CommandCaseEnum newCommandCase = null;
        if (extended) {
            if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE2_SHORT) {
                newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED;
            } else if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE3_SHORT) {
                newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE3_EXTENDED;
            } else if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE4_SHORT) {
                newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED;
            }
        } else if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED) {
            newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE2_SHORT;
        } else if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE3_EXTENDED) {
            newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE3_SHORT;
        } else if (this.commandCase == GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED) {
            newCommandCase = GISOCommandConstants.CommandCaseEnum.CASE4_SHORT;
        }
        if (newCommandCase != null) {
            this.init(null, newCommandCase.isExtended(), this.getCLA(), this.getINS(), this.getP1(), this.getP2(), this.getData(), this.getLE());
        }
    }

    private void init(byte[] cmdBytes) {
        this.commandCase = GISOCommandAPDUUtil.getCommandCase(cmdBytes);
    }

    private void init(GISOCommandConstants.CommandCaseEnum isoCase, boolean extended, Byte classByte, Byte instruction, Byte p1, Byte p2, byte[] data, Integer le) throws IllegalArgumentException {
        boolean dataPresent;
        if (le != null && le != GISOCommandConstants.NO_LE && le < 0) {
            throw new IllegalArgumentException("illegal LE value, only value greater equals zero permitted");
        }
        super.setLength(4);
        int maxSize = GISOCommandAPDUUtil.getMaximumSize(data, le);
        if (this.apdu_buffer.length < maxSize) {
            this.apdu_buffer = ByteUtil.extend(this.apdu_buffer, maxSize - this.apdu_buffer.length);
        }
        this.commandCase = isoCase;
        this.setCLA(classByte != null ? classByte : (byte)0);
        this.setINS(instruction != null ? instruction : (byte)0);
        this.setP1(p1 != null ? p1 : (byte)0);
        this.setP2(p2 != null ? p2 : (byte)0);
        boolean bl = dataPresent = this.commandCase == null && GISOCommandAPDUUtil.checkData(data) != Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        if (!dataPresent && le == GISOCommandConstants.NO_LE) {
            this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE1;
        } else if (!dataPresent && le != GISOCommandConstants.NO_LE) {
            if (this.commandCase == null) {
                this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE2_SHORT;
                if (extended && le != null && le == 0 || le != GISOCommandConstants.NO_LE && le > 256) {
                    this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE2_EXTENDED;
                }
            }
            super.append(this.commandCase.createLEBytes(le));
        } else if (dataPresent) {
            if (this.commandCase == null) {
                if (le == GISOCommandConstants.NO_LE) {
                    this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE3_SHORT;
                    if (data.length > 255) {
                        this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE3_EXTENDED;
                    }
                } else {
                    this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE4_SHORT;
                    if (extended && le != null && le == 0 || data.length > 255 || le != GISOCommandConstants.NO_LE && le > 256) {
                        this.commandCase = GISOCommandConstants.CommandCaseEnum.CASE4_EXTENDED;
                    }
                }
            }
            super.append(this.commandCase.createLCBytes(data.length));
            super.append(data);
            if (le != GISOCommandConstants.NO_LE) {
                super.append(this.commandCase.createLEBytes(le));
            }
        }
    }

    @Override
    public String toString() {
        if (this.commandCase != null) {
            Integer le = this.getLE();
            Integer lc = this.getLC();
            boolean extended = this.isExtended();
            switch (this.commandCase.getISOCase()) {
                case 1: {
                    return this.getClass().getName() + "\nHeader: " + HexString.hexify(this.getHeader()) + "\nCLA: " + HexString.hexify(this.getCLA().byteValue()) + " | INS: " + HexString.hexify(this.getINS().byteValue()) + " | P1: " + HexString.hexify(this.getP1().byteValue()) + " | P2: " + HexString.hexify(this.getP2().byteValue()) + "\nISO-CASE: " + this.commandCase + " | ExtendedLength: " + this.isExtended() + "\nBuffer:\n" + HexString.dump(super.getBytes());
                }
                case 2: {
                    return this.getClass().getName() + "\nHeader: " + HexString.hexify(this.getHeader()) + "\nCLA: " + HexString.hexify(this.getCLA().byteValue()) + " | INS: " + HexString.hexify(this.getINS().byteValue()) + " | P1: " + HexString.hexify(this.getP1().byteValue()) + " | P2: " + HexString.hexify(this.getP2().byteValue()) + " | LE: " + (le == 0 ? (extended ? 65536 : 256) : le) + " (" + HexString.hexify(GISOCommandAPDUUtil.createLEBytes(extended, le, this.commandCase)) + ")\nISO-CASE: " + this.commandCase + " | ExtendedLength: " + extended + "\nBuffer:\n" + HexString.dump(super.getBytes());
                }
                case 3: {
                    return this.getClass().getName() + "\nHeader: " + HexString.hexify(this.getHeader()) + "\nCLA: " + HexString.hexify(this.getCLA().byteValue()) + " | INS: " + HexString.hexify(this.getINS().byteValue()) + " | P1: " + HexString.hexify(this.getP1().byteValue()) + " | P2: " + HexString.hexify(this.getP2().byteValue()) + " | LC: " + lc + " (" + HexString.hexify(GISOCommandAPDUUtil.createLCBytes(extended, lc)) + ")\nISO-CASE: " + this.commandCase + " | ExtendedLength: " + extended + "\nBuffer:\n" + HexString.dump(super.getBytes());
                }
                case 4: {
                    return this.getClass().getName() + "\nHeader: " + HexString.hexify(this.getHeader()) + "\nCLA: " + HexString.hexify(this.getCLA().byteValue()) + " | INS: " + HexString.hexify(this.getINS().byteValue()) + " | P1: " + HexString.hexify(this.getP1().byteValue()) + " | P2: " + HexString.hexify(this.getP2().byteValue()) + " | LC: " + lc + " (" + HexString.hexify(GISOCommandAPDUUtil.createLCBytes(extended, lc)) + ") | LE: " + (le == 0 ? (extended ? 65536 : 256) : le) + " (" + HexString.hexify(GISOCommandAPDUUtil.createLEBytes(extended, le, this.commandCase)) + ")\nISO-CASE: " + this.commandCase + " | ExtendedLength: " + extended + "\nBuffer:\n" + HexString.dump(super.getBytes());
                }
            }
        }
        Byte claByte = this.getCLA();
        Byte insByte = this.getINS();
        Byte p1Byte = this.getP1();
        return this.getClass().getName() + "\nHeader: null\nCLA: " + (claByte != null ? HexString.hexify(claByte.byteValue()) : null) + " | INS: " + (insByte != null ? HexString.hexify(insByte.byteValue()) : null) + " | P1: " + (p1Byte != null ? HexString.hexify(p1Byte.byteValue()) : null) + " | P2:  | LC: null | LE: null\nISO-CASE: null | ExtendedLength: unknown\nBuffer:\n" + HexString.dump(super.getBytes());
    }
}

