/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.ByteUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class X509CertificateTransportContainer
extends X509Certificate {
    private static final boolean UNSUPPORTED_CRITICAL_EXTENSION = false;
    private static final HashSet<String> HASH_SET = new HashSet();
    private static final PublicKey PUBLIC_KEY = null;
    private static final int COUNT_BASIC_CONSTRAINTS = 0;
    private static final BigInteger SERIAL_NUMBER = BigInteger.valueOf(1L);
    private static final int VERSION = 3;
    private static final Principal PRINCIPAL = null;
    private static final Date DATE = null;
    private static final String STRING = "";
    private static final byte[] BYTES = new byte[0];
    private static final boolean[] BOOLEANS = new boolean[0];
    private byte[] certificateBytes = null;
    private AttributeCertificate attributeCertificate = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CertificateTransportContainer(byte[] certificateBytes) throws IllegalArgumentException {
        if (certificateBytes == null || certificateBytes.length == 0) {
            throw new IllegalArgumentException();
        }
        this.certificateBytes = ByteUtil.copy(certificateBytes);
        ASN1InputStream asn1is = new ASN1InputStream(certificateBytes);
        try {
            ASN1Primitive readObject = asn1is.readObject();
            if (ASN1Sequence.class.isInstance(readObject)) {
                this.attributeCertificate = AttributeCertificate.getInstance(ASN1Sequence.class.cast(readObject));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                asn1is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public AttributeCertificate getAttributeCertificate() {
        return this.attributeCertificate;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return ByteUtil.copy(this.certificateBytes);
    }

    @Override
    public PublicKey getPublicKey() {
        return PUBLIC_KEY;
    }

    @Override
    public String toString() {
        return "X509CertificateTransportContainer@" + this.hashCode() + "(certificate bytes: " + this.certificateBytes.length + ")";
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return HASH_SET;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return HASH_SET;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return BYTES;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public BigInteger getSerialNumber() {
        return SERIAL_NUMBER;
    }

    @Override
    public Principal getIssuerDN() {
        return PRINCIPAL;
    }

    @Override
    public Principal getSubjectDN() {
        return PRINCIPAL;
    }

    @Override
    public Date getNotBefore() {
        return DATE;
    }

    @Override
    public Date getNotAfter() {
        return DATE;
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return BYTES;
    }

    @Override
    public byte[] getSignature() {
        return BYTES;
    }

    @Override
    public String getSigAlgName() {
        return STRING;
    }

    @Override
    public String getSigAlgOID() {
        return STRING;
    }

    @Override
    public byte[] getSigAlgParams() {
        return BYTES;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return BOOLEANS;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return BOOLEANS;
    }

    @Override
    public boolean[] getKeyUsage() {
        return BOOLEANS;
    }

    @Override
    public int getBasicConstraints() {
        return 0;
    }
}

