/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class TransmitCommand {
    public static final List<ResponseAPDU> RESPONSE_CODE_ACCEPT_OK_ONLY_LIST = Collections.unmodifiableList(Arrays.asList(new ResponseAPDU(HexUtil.parse("9000"))));
    private CommandAPDU command = null;
    private List<ResponseAPDU> acceptedResponseList = null;

    public CommandAPDU getCommand() {
        return this.command;
    }

    public List<ResponseAPDU> getAcceptedResponseList() {
        return this.acceptedResponseList;
    }

    public TransmitCommand(CommandAPDU command, List<ResponseAPDU> acceptedResponseList) {
        this.command = command;
        this.acceptedResponseList = acceptedResponseList;
    }

    public static List<TransmitCommand> create(CommandAPDU[] commands) {
        return TransmitCommand.create(Arrays.asList(commands));
    }

    public static List<TransmitCommand> create(List<CommandAPDU> commandList) {
        return TransmitCommand.create(commandList, null);
    }

    public static List<TransmitCommand> create(CommandAPDU command, List<ResponseAPDU> acceptedResponseList) {
        ArrayList<TransmitCommand> result = new ArrayList<TransmitCommand>();
        if (command != null) {
            result.add(new TransmitCommand(command, acceptedResponseList));
        }
        return result;
    }

    public static List<TransmitCommand> create(List<CommandAPDU> commandList, List<ResponseAPDU> acceptedResponseList) {
        ArrayList<TransmitCommand> result = new ArrayList<TransmitCommand>();
        if (!CollectionUtil.isNullOrEmpty(commandList)) {
            for (CommandAPDU command : commandList) {
                if (command == null) continue;
                result.add(new TransmitCommand(command, acceptedResponseList));
            }
        }
        return result;
    }
}

