/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.gov2.jca_provider.ocf.AbstractResult;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.Parameter;
import de.bos_bremen.gov2.jca_provider.ocf.Result;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitParameter;
import de.bos_bremen.gov2.jca_provider.ocf.TransmitResult;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PaceInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.pace.impl.PacePlusResult;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAInputParameters;
import de.bos_bremen.gov2.jca_provider.ocf.cards.epa.ta.impl.TACAResult;
import java.util.List;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;

public interface SecureCard {
    public SecurityProtocolResult<? extends Object> allocateSecureContext(SecurityProtocol var1, SecurityProtocolParameter var2) throws IllegalArgumentException, CardServiceException, CardTerminalException;

    public boolean releaseSecureContext() throws CardServiceException, CardTerminalException;

    public boolean prepareSignatureTerminal(boolean var1) throws IllegalStateException, OperationCancelledException, WrongPinException;

    public boolean isSecure();

    public SecurityProtocol getSecurityProtocol();

    public List<SecurityProtocol> getSupportedSecurityProtocols();

    public TransmitResult transmit(TransmitParameter var1);

    public static enum SecurityProtocol implements SecurityProtocolConstants
    {
        NONE("NONE", -1, null, null),
        EAC2_PACEPLUS("PACE+", 4, PaceInputParameters.class, PacePlusResult.class),
        EAC2_TACA("TA/CA", 5, TACAInputParameters.class, TACAResult.class),
        EAC2_PACE("PACE", 0, PaceInputParameters.class, SimpleSecurityProtocolResult.class),
        EAC2_TERMINAL_AUTHENTICATION("TerminalAuthentication", 1, null, SimpleSecurityProtocolResult.class),
        EAC2_CHIP_AUTHENTICATION("ChipAuthentication", 2, null, SimpleSecurityProtocolResult.class);

        private String name = null;
        private int protocol = -1;
        private Class<? extends SecurityProtocolParameter> parameterClass = null;
        private Class<? extends SecurityProtocolResult> resultClass = null;

        private SecurityProtocol(String name, int protocol, Class<? extends SecurityProtocolParameter> parameterClass, Class<? extends SecurityProtocolResult> resultClass) {
            this.name = name;
            this.protocol = protocol;
            this.parameterClass = parameterClass;
            this.resultClass = resultClass;
        }

        public String getName() {
            return this.name;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public Class<? extends SecurityProtocolParameter> getParameterClass() {
            return this.parameterClass;
        }

        public Class<? extends SecurityProtocolResult> getResultClass() {
            return this.resultClass;
        }
    }

    public static class SimpleSecurityProtocolResult
    extends AbstractResult<Boolean>
    implements SecurityProtocolResult<Boolean> {
        public SimpleSecurityProtocolResult(Throwable throwable) {
            super(Boolean.FALSE, throwable);
        }

        public SimpleSecurityProtocolResult(boolean securityProtocolSuccessfulAllocated) {
            super(securityProtocolSuccessfulAllocated ? Boolean.TRUE : Boolean.FALSE, null);
        }

        @Override
        public boolean isSecurityProtocolSuccessfulAllocated() {
            return (Boolean)super.getData();
        }
    }

    public static interface SecurityProtocolResult<T>
    extends Result<T> {
        public boolean isSecurityProtocolSuccessfulAllocated();
    }

    public static interface SecurityProtocolParameter
    extends Parameter {
    }

    public static interface SecurityProtocolConstants {
        public static final int PROTOCOL_NONE = -1;
        public static final int PROTOCOL_EAC2_PACE = 0;
        public static final int PROTOCOL_EAC2_TERMINAL_AUTHENTICATION = 1;
        public static final int PROTOCOL_EAC2_CHIP_AUTHENTICATION = 2;
        public static final int PROTOCOL_EAC2_RESTRICTED_IDENTIFICATION = 3;
        public static final int PROTOCOL_EAC2_PACEPLUS = 4;
        public static final int PROTOCOL_EAC2_TACA = 5;
    }
}

