/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.ocf.OCFException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import java.math.BigInteger;
import opencard.core.terminal.CardTerminalException;

public final class PaceTerminalCodeChecker {
    private PaceTerminalCodeChecker() {
    }

    public static void checkTerminalCode(String pinName, byte[] terminalResult) throws CardTerminalException, WrongPinException, PinInputCancelledException, PinInputTimeoutException, OCFException {
        AssertUtil.notNullOrEmpty(terminalResult, "result from terminal");
        if (ArrayUtil.isNullOrEmpty(terminalResult) || terminalResult.length < 4) {
            throw new CardTerminalException("protocol failed at terminal - no response received (at least 4 bytes required containing execution result code");
        }
        byte[] code = ByteUtil.flip(ByteUtil.subbytes(terminalResult, 0, 4));
        if (!ByteUtil.equals(code, HexUtil.parse("00000000"))) {
            PaceTerminalCodeChecker.checkFXXXS152(pinName, code);
            PaceTerminalCodeChecker.checkF010000X(code);
            PaceTerminalCodeChecker.checkF020000X(pinName, code);
            PaceTerminalCodeChecker.checkD000000X(code);
            PaceTerminalCodeChecker.checkE000000X(code);
            throw new CardTerminalException("protocol failed at terminal, unknown error: " + HexUtil.hexify(code));
        }
    }

    private static void checkE000000X(byte[] code) throws CardTerminalException {
        if (code[0] == -32 && code[1] == 0 && code[2] == 0 && (code[3] >= 1 && code[3] <= 3 || code[3] >= 6 && code[3] <= 10)) {
            throw new CardTerminalException("protocol failed at terminal, error in execution: " + HexUtil.hexify(code));
        }
    }

    private static void checkD000000X(byte[] code) throws CardTerminalException {
        if (code[0] == -48 && code[1] == 0 && code[2] == 0 && code[3] >= 1 && code[3] <= 3) {
            throw new CardTerminalException("protocol failed at terminal, data input error: " + HexUtil.hexify(code));
        }
    }

    private static void checkF020000X(String pinName, byte[] code) throws PinInputCancelledException, PinInputTimeoutException {
        if (code[0] == -16 && code[1] == 32 && code[2] == 0) {
            if (code[3] == 1) {
                throw new PinInputCancelledException(pinName, 25601, "input cancelled");
            }
            if (code[3] == 2) {
                throw new PinInputTimeoutException(pinName, 25600, "timeout");
            }
        }
    }

    private static void checkF010000X(byte[] code) throws CardTerminalException {
        if (code[0] == -16 && code[1] == 16 && code[2] == 0 && code[3] >= 1 && code[3] <= 2) {
            throw new CardTerminalException("protocol failed at terminal, card communication error: " + HexUtil.hexify(code));
        }
    }

    private static void checkFXXXS152(String pinName, byte[] code) throws WrongPinException, OCFException {
        if (code[0] == -16 && code[1] >= 0 && code[1] <= 6 || code[0] == -8 && code[1] >= 0 && code[1] <= 12) {
            int sw = (code[2] + 256) % 256 * 256 + (code[3] + 256) % 256;
            if (code[2] == 99 && (code[3] & 0xFFFFFFF0) == -64) {
                throw new WrongPinException(pinName, sw, "wrong password entered");
            }
            throw new OCFException(new BigInteger(code).intValue(), "card returned error code");
        }
    }
}

