/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.crypto.GovDefaultSignatureAlgorithmIdentifierFinder;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OCFDefaultAlgorithmFinder
extends GovDefaultSignatureAlgorithmIdentifierFinder {
    public static final String ALGO_ID_KEYTRANSPORT_RSA_SHA2_224_MGF1 = "http://www.w3.org/2009/xmlenc11#mgf1sha224";
    public static final String ALGO_ID_KEYTRANSPORT_RSA_SHA2_256_MGF1 = "http://www.w3.org/2009/xmlenc11#mgf1sha256";
    public static final String ALGO_ID_KEYTRANSPORT_RSA_SHA2_384_MGF1 = "http://www.w3.org/2009/xmlenc11#mgf1sha384";
    public static final String ALGO_ID_KEYTRANSPORT_RSA_SHA2_512_MGF1 = "http://www.w3.org/2009/xmlenc11#mgf1sha512";
    private static OCFDefaultAlgorithmFinder singletonInstance;
    public static final Map<String, String> MAP_JCE_URI;
    public static final Map<String, AlgorithmIdentifier> MAP_JCE_ALGORITHM_IDENTIFIER;
    public static final Map<String, MGF1ParameterSpec> MAP_JCE_MGFPARAMETERSPEC;

    private OCFDefaultAlgorithmFinder() {
    }

    public static synchronized OCFDefaultAlgorithmFinder getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new OCFDefaultAlgorithmFinder();
        }
        return singletonInstance;
    }

    @Override
    public AlgorithmIdentifier find(String algName) {
        String lAlgName = algName;
        if (lAlgName != null && lAlgName.contains("hashedWith")) {
            lAlgName = lAlgName.replaceAll("hashedWith", "with");
        }
        if (lAlgName != null && lAlgName.contains("/PSS")) {
            lAlgName = lAlgName.replaceAll("/PSS", "andMGF1");
        }
        if (MAP_JCE_ALGORITHM_IDENTIFIER.containsKey(lAlgName)) {
            return MAP_JCE_ALGORITHM_IDENTIFIER.get(lAlgName);
        }
        return super.find(lAlgName);
    }

    public String findURI(String algName) {
        String uri;
        String lAlgName = algName;
        if (lAlgName != null && lAlgName.contains("hashedWith")) {
            lAlgName = lAlgName.replaceAll("hashedWith", "with");
        }
        if (lAlgName != null && lAlgName.contains("/PSS")) {
            lAlgName = lAlgName.replaceAll("/PSS", "andMGF1");
        }
        if ((lAlgName == null || !lAlgName.contains("CVC-ECDSA")) && lAlgName != null && lAlgName.contains("ECDSA")) {
            lAlgName = lAlgName.replaceAll("ECDSA", "CVC-ECDSA");
        }
        return (uri = MAP_JCE_URI.get(lAlgName)) == null ? "-" : uri;
    }

    public MGF1ParameterSpec findMGF1ParameterSpec(String algName) {
        return MAP_JCE_MGFPARAMETERSPEC.get(algName);
    }

    static {
        String[] hashAlgorithms;
        LinkedHashMap<Object, Object> tmp = new LinkedHashMap<Object, Object>();
        tmp.put("MGF1", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        tmp.put("RSA/ECB/OAEP", "http://www.w3.org/2009/xmlenc#rsa-oaep");
        tmp.put("RSA/NONE/OAEPWithSHA224AndMGF1Padding", ALGO_ID_KEYTRANSPORT_RSA_SHA2_224_MGF1);
        tmp.put("RSA/NONE/OAEPWithSHA256AndMGF1Padding", ALGO_ID_KEYTRANSPORT_RSA_SHA2_256_MGF1);
        tmp.put("RSA/NONE/OAEPWithSHA384AndMGF1Padding", ALGO_ID_KEYTRANSPORT_RSA_SHA2_384_MGF1);
        tmp.put("RSA/NONE/OAEPWithSHA512AndMGF1Padding", ALGO_ID_KEYTRANSPORT_RSA_SHA2_512_MGF1);
        for (String hashAlgorithm : hashAlgorithms = new String[]{"SHA1"}) {
            tmp.put(hashAlgorithm, "http://www.w3.org/2000/09/xmldsig#" + hashAlgorithm.toLowerCase());
        }
        for (String hashAlgorithm : hashAlgorithms = new String[]{"MD5", "SHA224", "SHA384"}) {
            tmp.put(hashAlgorithm, "http://www.w3.org/2001/04/xmldsig-more#" + hashAlgorithm.toLowerCase());
        }
        for (String hashAlgorithm : hashAlgorithms = new String[]{"WHIRLPOOL"}) {
            tmp.put(hashAlgorithm, "http://www.w3.org/2007/05/xmldsig-more#" + hashAlgorithm.toLowerCase());
        }
        for (String hashAlgorithm : hashAlgorithms = new String[]{"SHA256", "SHA512", "RIPEMD160"}) {
            tmp.put(hashAlgorithm, "http://www.w3.org/2001/04/xmlenc#" + hashAlgorithm.toLowerCase());
        }
        tmp.put("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig-more#rsa-sha1");
        for (String hashAlgorithm : hashAlgorithms = new String[]{"MD5", "SHA224", "SHA256", "SHA384", "SHA512", "RIPEMD160", "WHIRLPOOL"}) {
            tmp.put(hashAlgorithm + "withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-" + hashAlgorithm.toLowerCase());
        }
        for (String hashAlgorithm : hashAlgorithms = new String[]{"MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "RIPEMD160", "WHIRLPOOL"}) {
            tmp.put(hashAlgorithm + "withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#" + hashAlgorithm.toLowerCase() + "-rsa-MGF1");
            tmp.put(hashAlgorithm + "withRSA/PSS", "http://www.w3.org/2007/05/xmldsig-more#" + hashAlgorithm.toLowerCase() + "-rsa-MGF1");
        }
        for (String hashAlgorithm : hashAlgorithms = new String[]{"SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "RIPEMD160", "WHIRLPOOL"}) {
            tmp.put(hashAlgorithm + "withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-" + hashAlgorithm.toLowerCase());
        }
        tmp.put("RSA/ECB/PKCS1Padding", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        tmp.put("RSA/ECB/OAEP", "http://www.w3.org/2009/xmlenc#rsa-oaep");
        tmp.put("RSA/PSS", "http://www.w3.org/2007/05/xmldsign-more#rsa-pss");
        tmp.put("ECDH", "http://www.w3.org/2001/04/xmlenc#dh");
        tmp.put("ECIES", "http://www.w3.org/2010/xmlsec-ghc#ecies-kem");
        MAP_JCE_URI = Collections.unmodifiableMap(tmp);
        LinkedHashMap<String, AlgorithmIdentifier> tmp2 = new LinkedHashMap<String, AlgorithmIdentifier>();
        tmp2.put("SHA1withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.1"), null));
        tmp2.put("SHA224withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.2"), null));
        tmp2.put("SHA256withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.3"), null));
        tmp2.put("SHA384withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.4"), null));
        tmp2.put("SHA512withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.5"), null));
        tmp2.put("RIPEMD160withCVC-ECDSA", new AlgorithmIdentifier(new ASN1ObjectIdentifier("0.4.0.127.0.7.1.1.4.1.6"), null));
        MAP_JCE_ALGORITHM_IDENTIFIER = Collections.unmodifiableMap(tmp2);
        LinkedHashMap<String, MGF1ParameterSpec> tmp3 = new LinkedHashMap<String, MGF1ParameterSpec>();
        tmp3.put("SHA1", MGF1ParameterSpec.SHA1);
        tmp3.put("SHA-1", MGF1ParameterSpec.SHA1);
        tmp3.put("SHA256", MGF1ParameterSpec.SHA256);
        tmp3.put("SHA-256", MGF1ParameterSpec.SHA256);
        tmp3.put("SHA384", MGF1ParameterSpec.SHA384);
        tmp3.put("SHA-384", MGF1ParameterSpec.SHA384);
        tmp3.put("SHA512", MGF1ParameterSpec.SHA512);
        tmp3.put("SHA-512", MGF1ParameterSpec.SHA512);
        MAP_JCE_MGFPARAMETERSPEC = Collections.unmodifiableMap(tmp3);
    }
}

