/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFCertificateBag;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.DefaultBaseAlgorithmProviderBuilder;
import de.bos_bremen.gov2.jca_provider.ocf.FileEntry;
import de.bos_bremen.gov2.jca_provider.ocf.IOCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.FileReference;
import de.bos_bremen.gov2.jca_provider.ocf.cards.KeyID;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardFile;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardPin;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import opencard.core.util.HexString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OCFCertificateInfo
implements IOCFCertificateInfo {
    private static final String LOG_MESSAGE_PART_FOUND = ", found: ";
    private static final String LOG_MESSAGE_CHECK_KEY_ID_FALSE = "check KeyID: false";
    private static final Log LOG = LogFactory.getLog(OCFCertificateInfo.class);
    @Deprecated
    public static final int CARD_USAGE_SIGNATURE = 1;
    @Deprecated
    public static final int CARD_USAGE_ENCRYPTION = 2;
    @Deprecated
    public static final int CARD_USAGE_AUTHENTIFICATION = 4;
    private static final int KEY_USAGE_FLAG_INDEX_DIGITAL_SIGNATURE = 0;
    private static final int KEY_USAGE_FLAG_INDEX_NON_REPUDIATION = 1;
    private static final int KEY_USAGE_FLAG_INDEX_KEY_ENCIPHERMENT = 2;
    private static final int KEY_USAGE_FLAG_INDEX_DATA_ENCIPHERMENT = 3;
    private static final int KEY_USAGE_FLAG_INDEX_KEY_AGREEMENT = 4;
    private static final int KEY_USAGE_FLAG_INDEX_ENCIPHER_ONLY = 7;
    private static final int KEY_USAGE_FLAG_INDEX_DECIPHER_ONLY = 8;
    private X509Certificate certificate;
    private String alias;
    private ChainEntry chainentry;
    private FileEntry[] attribute_certificate_files;
    private Certificate[] attribute_certificates;
    private byte[][] attribute_certificates_byte_arrays;
    private Usage usage;
    private QualifiedUsage qualifiedUsage;
    private String name = null;
    private Card card = null;
    private CardPin pin = null;
    private CardKey key = null;
    private CardFile cerFile = null;
    private OCFCertificateBag certificateBag;
    private long idOfCard = -1L;
    private long idOfPin = -1L;
    private long idOfCerFile = -1L;
    private long idOfKey = -1L;
    private long[] idsOfAttributeCertificateFiles;
    private CardFile[] attributeCertificateFiles;
    private String location = null;
    private boolean isTest = false;
    private FileReference directory = null;
    private FileReference file = null;
    private KeyID key_id = null;
    private byte pin_id = 0;
    private boolean lockAlias = false;
    private String additionalMessage = null;

    public OCFCertificateInfo(long idOfCard, long idOfPin, long idOfCerFile, long idOfKey, ChainEntry _chainentry, Usage _usage, long[] idsOfAttributeCertificateFiles) {
        this.idOfCard = idOfCard;
        this.idOfPin = idOfPin;
        this.idOfCerFile = idOfCerFile;
        this.idOfKey = idOfKey;
        this.initChainAndAttrCerts(_chainentry, _usage, idsOfAttributeCertificateFiles);
    }

    public OCFCertificateInfo() {
        this(null, null, null, 0, ChainEntry.USER);
    }

    public OCFCertificateInfo(Card _card, Usage _usage, ChainEntry _chainEntry, byte _pin_id) {
        this(null, null, null, _pin_id, _chainEntry);
        this.usage = _usage;
        this.card = _card;
        this.key_id = new KeyID("ffffffff");
    }

    public OCFCertificateInfo(Card _card, Usage _usage, ChainEntry _chainEntry) {
        this(null, null, null, 0, _chainEntry);
        this.usage = _usage;
        this.card = _card;
        this.key_id = new KeyID("ffffffff");
    }

    @Deprecated
    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, int _cardUsage, ChainEntry _chainentry) {
        this(_directory, _file, _key_id, _pin_id, _chainentry);
    }

    @Deprecated
    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, int _cardUsage) {
        this(_directory, _file, _key_id, _pin_id, ChainEntry.USER);
    }

    @Deprecated
    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, ChainEntry _chainentry) {
        this(_directory, _file, _key_id, _pin_id, _chainentry, (Usage)null);
    }

    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, ChainEntry _chainentry, String name) {
        this(_directory, _file, _key_id, _pin_id, _chainentry, (Usage)null);
        this.name = name;
    }

    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, ChainEntry _chainentry, Usage _usage) {
        this(_directory, _file, _key_id, _pin_id, _chainentry, _usage, null);
    }

    public OCFCertificateInfo(FileReference _directory, FileReference _file, KeyID _key_id, byte _pin_id, ChainEntry _chainentry, Usage _usage, FileEntry[] _attribute_certificate_files) {
        this.directory = _directory;
        this.file = _file;
        this.key_id = _key_id;
        this.pin_id = _pin_id;
        this.initChainAndAttrCerts(_chainentry, _usage, _attribute_certificate_files);
    }

    private void initChainAndAttrCerts(ChainEntry _chainentry, Usage _usage, FileEntry[] _attribute_certificate_files) {
        this.chainentry = _chainentry;
        this.usage = _usage;
        this.initAttributeCertificates(_attribute_certificate_files);
    }

    private void initAttributeCertificates(FileEntry[] _attribute_certificate_files) {
        if (this.chainentry != ChainEntry.USER && _attribute_certificate_files != null && _attribute_certificate_files.length > 0) {
            throw new IllegalArgumentException("only attribute certificates expected for user certificate");
        }
        if (this.chainentry == ChainEntry.USER && _attribute_certificate_files != null && _attribute_certificate_files.length > 0) {
            this.attribute_certificate_files = new FileEntry[_attribute_certificate_files.length];
            this.attribute_certificates = new Certificate[_attribute_certificate_files.length];
            this.attribute_certificates_byte_arrays = new byte[_attribute_certificate_files.length][];
        } else {
            this.attribute_certificate_files = null;
            this.attribute_certificates = null;
            this.attribute_certificates_byte_arrays = null;
        }
    }

    private void initChainAndAttrCerts(ChainEntry _chainentry, Usage _usage, long[] idsOfAttributeCertificateFiles) {
        this.chainentry = _chainentry;
        this.usage = _usage;
        this.initAttributeCertificates(idsOfAttributeCertificateFiles);
    }

    private void initAttributeCertificates(long[] idOfAttributeCertificateFiles) {
        if (this.chainentry != ChainEntry.USER && idOfAttributeCertificateFiles != null && idOfAttributeCertificateFiles.length > 0) {
            throw new IllegalArgumentException("only attribute certificates expected for user certificate");
        }
        if (this.chainentry == ChainEntry.USER && idOfAttributeCertificateFiles != null && idOfAttributeCertificateFiles.length > 0) {
            this.idsOfAttributeCertificateFiles = idOfAttributeCertificateFiles;
            this.attributeCertificateFiles = new CardFile[idOfAttributeCertificateFiles.length];
            this.attribute_certificate_files = new FileEntry[idOfAttributeCertificateFiles.length];
            this.attribute_certificates = new Certificate[idOfAttributeCertificateFiles.length];
            this.attribute_certificates_byte_arrays = new byte[idOfAttributeCertificateFiles.length][];
        } else {
            this.idsOfAttributeCertificateFiles = null;
            this.attributeCertificateFiles = null;
            this.attribute_certificate_files = null;
            this.attribute_certificates = null;
            this.attribute_certificates_byte_arrays = null;
        }
    }

    @Override
    public void setX509Certificate(X509Certificate _certificate) {
        this.certificate = _certificate;
        this.setUsages(this.certificate == null ? null : this.certificate.getKeyUsage());
    }

    @Override
    public void setUsages(boolean[] keyUsageFlags) {
        if (this.usage == null) {
            Usage usage = this.usage = keyUsageFlags == null ? Usage.UNK : Usage.forKU(keyUsageFlags);
        }
        if (this.qualifiedUsage == null) {
            this.qualifiedUsage = keyUsageFlags == null ? QualifiedUsage.UNQUALIFIED : QualifiedUsage.forKeyUsageFlags(keyUsageFlags);
        }
    }

    @Override
    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    @Override
    public void setAttributeCertificates(Certificate[] _attribute_certificates) {
        if (this.chainentry != ChainEntry.USER) {
            return;
        }
        if (this.attribute_certificates == null && (_attribute_certificates == null || _attribute_certificates.length == 0)) {
            return;
        }
        if (this.attribute_certificates == null && _attribute_certificates != null && _attribute_certificates.length > 0) {
            throw new IllegalArgumentException("no attribute certificates expected but set");
        }
        if (this.attribute_certificates != null && _attribute_certificates == null) {
            throw new IllegalArgumentException("attribute certificates expected but not set");
        }
        if (this.attribute_certificates.length < _attribute_certificates.length) {
            throw new IllegalArgumentException("count of expected attribute certificates exceeds count of set certificates file references");
        }
        this.attribute_certificates = _attribute_certificates;
        this.attribute_certificates_byte_arrays = new byte[_attribute_certificates.length][];
        for (int i = 0; i < _attribute_certificates.length; ++i) {
            try {
                this.attribute_certificates_byte_arrays[i] = _attribute_certificates[i].getEncoded();
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setAttributeCertificatesByteArrays(byte[][] _attribute_certificates_byte_arrays) {
        if (this.chainentry != ChainEntry.USER) {
            return;
        }
        if (this.attribute_certificates == null && (_attribute_certificates_byte_arrays == null || _attribute_certificates_byte_arrays.length == 0)) {
            return;
        }
        if (this.attribute_certificates == null && _attribute_certificates_byte_arrays != null && _attribute_certificates_byte_arrays.length > 0) {
            throw new IllegalArgumentException("no attribute certificates expected but set");
        }
        if (this.attribute_certificates != null && _attribute_certificates_byte_arrays == null) {
            throw new IllegalArgumentException("attribute certificates expected but not set");
        }
        if (this.attribute_certificates.length < _attribute_certificates_byte_arrays.length) {
            throw new IllegalArgumentException("count of expected attribute certificates exceeds count of set certificates file references");
        }
        this.attribute_certificates_byte_arrays = new byte[_attribute_certificates_byte_arrays.length][];
        for (int i = 0; i < _attribute_certificates_byte_arrays.length; ++i) {
            this.attribute_certificates_byte_arrays[i] = _attribute_certificates_byte_arrays[i];
        }
    }

    @Override
    public byte[][] getAttributeCertificatesByteArrays() {
        return this.attribute_certificates_byte_arrays;
    }

    @Override
    public Certificate[] getAttributeCertificates() {
        Certificate[] result = null;
        if (this.attribute_certificates != null) {
            result = new Certificate[this.attribute_certificates.length];
            System.arraycopy(this.attribute_certificates, 0, result, 0, this.attribute_certificates.length);
        }
        return result;
    }

    @Override
    public FileEntry[] getAttributeCertificateFileEntries() {
        FileEntry[] result = null;
        if (this.attribute_certificate_files != null) {
            result = new FileEntry[this.attribute_certificate_files.length];
            System.arraycopy(this.attribute_certificate_files, 0, result, 0, this.attribute_certificate_files.length);
        }
        return result;
    }

    public void lockAlias() {
        this.lockAlias = true;
    }

    @Override
    public void setAlias(String _alias) {
        if (this.lockAlias) {
            return;
        }
        this.alias = _alias;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public FileReference getDirectory() {
        return this.cerFile != null ? this.cerFile.getEntry().getDirectory() : this.directory;
    }

    @Override
    public FileReference getFile() {
        return this.cerFile != null ? this.cerFile.getEntry().getFile() : this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyID getKeyID() {
        OCFCertificateInfo oCFCertificateInfo = this;
        synchronized (oCFCertificateInfo) {
            return this.key != null ? this.key.getKeyID() : this.key_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getPinID() {
        OCFCertificateInfo oCFCertificateInfo = this;
        synchronized (oCFCertificateInfo) {
            return this.pin != null ? this.pin.getPinID() : this.pin_id;
        }
    }

    @Override
    public ChainEntry getChainEntry() {
        return this.chainentry;
    }

    @Override
    public Usage getUsage() {
        return this.usage;
    }

    @Override
    public QualifiedUsage getQualifiedUsage() {
        return this.qualifiedUsage;
    }

    @Override
    @Deprecated
    public int getCardUsage() {
        if (this.certificate != null) {
            boolean[] ku = this.certificate.getKeyUsage();
            if (ku == null || ku.length == 0) {
                return 0;
            }
            if (ku[1]) {
                return 1;
            }
            if (ku[0] && (ku[2] || ku[3])) {
                return 6;
            }
            if (ku[0]) {
                return 4;
            }
            if (ku[2] || ku[3]) {
                return 2;
            }
        }
        return 0;
    }

    public static boolean[] convert(int _cardUsage) {
        boolean[] result = new boolean[8];
        result[0] = (_cardUsage & 4) != 0;
        result[1] = (_cardUsage & 1) != 0;
        result[2] = (_cardUsage & 2) != 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCFPrivateKey getPrivateKey() {
        OCFCertificateInfo oCFCertificateInfo = this;
        synchronized (oCFCertificateInfo) {
            if (this.certificateBag != null && this.certificateBag.isKeyEntry()) {
                return this.certificateBag.getPrivateKey();
            }
            return null;
        }
    }

    @Override
    public void setCertificateBag(OCFCertificateBag certificateBag) {
        if (this.certificateBag == null) {
            this.certificateBag = certificateBag;
            DefaultBaseAlgorithmProviderBuilder.initCardKey(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        OCFCertificateInfo oCFCertificateInfo = this;
        synchronized (oCFCertificateInfo) {
            if (this.pin == null) {
                if (this.card == null) {
                    this.card = CardObjectRegistryImpl.getInstance().getCardByID(this.idOfCard);
                }
                if (this.idOfPin != -1L) {
                    this.pin = this.card.getPinByID(this.idOfPin, 1);
                }
                this.cerFile = this.card.getFileByID(this.idOfCerFile, 1);
                if (this.idOfKey != -1L) {
                    this.key = this.card.getKeyByID(this.idOfKey, 1);
                }
                for (int i = 0; this.idsOfAttributeCertificateFiles != null && i < this.idsOfAttributeCertificateFiles.length; ++i) {
                    this.attributeCertificateFiles[i] = this.card.getFileByID(this.idsOfAttributeCertificateFiles[i], 1);
                    this.attribute_certificate_files[i] = this.attributeCertificateFiles[i].getEntry();
                }
            }
        }
    }

    @Override
    public CardPin getPin() {
        return this.pin;
    }

    @Override
    public CardKey getKey() {
        return this.key;
    }

    @Override
    public CardFile getCerFile() {
        return this.cerFile;
    }

    @Override
    public Card getCard() {
        return this.card;
    }

    @Override
    public OCFCertificateBag getCertificateBag() {
        return this.certificateBag;
    }

    @Override
    public String getName() {
        return this.key != null ? this.key.getName() : (this.cerFile != null ? this.cerFile.getName() : "?");
    }

    @Override
    public void initName(String name) {
    }

    public static boolean match(OCFCertificateInfo infoExpected, OCFCertificateInfo info) {
        boolean result = true;
        if (!OCFCertificateInfo.matchFileReference(infoExpected.getDirectory(), info.getDirectory())) {
            LOG.debug((Object)"check directory: false");
            result = false;
        }
        if (result && !OCFCertificateInfo.matchFileReference(infoExpected.getFile(), info.getFile())) {
            LOG.debug((Object)"check file: false");
            result = false;
        }
        if (result && !OCFCertificateInfo.matchKeyID(infoExpected.getKeyID(), info.getKeyID())) {
            LOG.debug((Object)LOG_MESSAGE_CHECK_KEY_ID_FALSE);
            result = false;
        }
        if (result && infoExpected.getPinID() != info.getPinID()) {
            LOG.debug((Object)("check PinID: false, expected: " + infoExpected.getPinID() + LOG_MESSAGE_PART_FOUND + info.getPinID()));
            result = false;
        }
        if (result && infoExpected.getChainEntry() != info.getChainEntry()) {
            LOG.debug((Object)"check ChainEntry: false");
            result = false;
        }
        if (result && infoExpected.getUsage() != info.getUsage()) {
            LOG.debug((Object)("check Usage: false, expected: " + infoExpected.getUsage() + LOG_MESSAGE_PART_FOUND + info.getUsage()));
            result = false;
        }
        return result;
    }

    private static boolean matchFileReference(FileReference expected, FileReference found) {
        boolean result = true;
        if (expected == null && found != null) {
            LOG.debug((Object)"check Reference: false");
            result = false;
        }
        if (result && expected != null && found == null) {
            LOG.debug((Object)"check Reference: false");
            result = false;
        }
        if (result && Objects.nonNull(expected) && !Arrays.equals(expected.reference, found.reference)) {
            LOG.debug((Object)("check Reference: false, expected: " + HexString.hexify(expected.reference) + LOG_MESSAGE_PART_FOUND + HexString.hexify(found.reference)));
            result = false;
        }
        if (result && Objects.nonNull(expected) && expected.referenceType != found.referenceType) {
            LOG.debug((Object)("check ReferenceType: false, expected type: " + expected.referenceType + ", found type: " + found.referenceType));
            result = false;
        }
        return result;
    }

    private static boolean matchKeyID(KeyID expected, KeyID found) {
        boolean result = true;
        if (expected == null && found != null) {
            LOG.debug((Object)LOG_MESSAGE_CHECK_KEY_ID_FALSE);
            result = false;
        }
        if (result && expected != null && found == null) {
            LOG.debug((Object)LOG_MESSAGE_CHECK_KEY_ID_FALSE);
            result = false;
        }
        if (result && expected != null && !Arrays.equals(expected.getID(), found.getID())) {
            LOG.debug((Object)("check KeyID: false, expected: " + expected + LOG_MESSAGE_PART_FOUND + found));
            result = false;
        }
        return result;
    }

    public void setTest(boolean isTest) {
        this.isTest = isTest;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public synchronized String getLocation() {
        if (this.location != null) {
            return this.location;
        }
        CardKey ck = this.getKey();
        CardFile cf = this.getCerFile();
        if (ck == null && cf == null) {
            return null;
        }
        if (this.location == null) {
            Object result = "(";
            FileEntry fe = cf.getEntry();
            if (ck != null && !Arrays.equals(ck.getParentApplication().getFileEntry().getDirectory().reference, fe.getDirectory().reference)) {
                result = (String)result + HexUtil.hexify(ck.getParentApplication().getFileEntry().getDirectory().reference) + ", ";
            }
            result = (String)result + HexUtil.hexify(fe.getDirectory().reference) + ", ";
            result = (String)result + HexUtil.hexify(fe.getFile().reference);
            this.location = result = (String)result + ")";
        }
        return this.location;
    }

    public String getNameString() {
        String result = null;
        CardKey ck = this.getKey();
        if (ck != null) {
            result = ck.getName() + " (key)";
        } else {
            CardFile cf = this.getCerFile();
            if (cf != null) {
                result = cf.getName() + " (file)";
            }
        }
        result = result + ", " + this.getLocation();
        return result;
    }

    public String getAdditionalMessage() {
        return this.additionalMessage;
    }

    public void setAdditionalMessage(String additionalMessage) {
        this.additionalMessage = additionalMessage;
    }

    public static final class Usage {
        private static final Map<String, Usage> map = new HashMap<String, Usage>();
        public static final Usage AUT = new Usage("authentification");
        public static final Usage ENC = new Usage("encryption");
        public static final Usage AEN = new Usage("enc_auth");
        public static final Usage SIG = new Usage("signature");
        public static final Usage ASC = new Usage("sig_enc_auth");
        public static final Usage GLO = new Usage("global");
        public static final Usage EID = new Usage("eid");
        public static final Usage EID_CAN = new Usage("eid_can");
        public static final Usage EID_CAN_NOT_FORCED = new Usage("eid_can_not_forced");
        public static final Usage EID_PUK = new Usage("eid_puk");
        public static final Usage ESIGN = new Usage("esign");
        public static final Usage RFID = new Usage("rfid");
        public static final Usage UNK = new Usage("unknown");
        public final String name;

        private Usage(String _name) {
            this.name = _name;
            map.put(this.name, this);
        }

        public static Usage valueOf(String _name) {
            return map.get(_name);
        }

        public static Usage forKU(boolean[] ku) {
            if (ku == null) {
                return UNK;
            }
            if (ku[0] && ku[1] && !ku[2] && !ku[3] && !ku[4]) {
                return SIG;
            }
            if (ku[0] && ku[1] && (ku[2] || ku[3] || ku[4])) {
                return ASC;
            }
            if (ku[0] && !ku[1] && (ku[2] || ku[3] || ku[4])) {
                return AEN;
            }
            if (!(!ku[0] || ku[1] || ku[2] || ku[3] || ku[4])) {
                return AUT;
            }
            if (!ku[0] && !ku[1] && (ku[2] || ku[3] || ku[4])) {
                return ENC;
            }
            if (!(ku[0] || !ku[1] || ku[2] || ku[3] || ku[4])) {
                return SIG;
            }
            return UNK;
        }

        public String toString() {
            return super.toString() + " - " + this.name;
        }
    }

    public static final class QualifiedUsage {
        private static final Map<String, QualifiedUsage> map = new HashMap<String, QualifiedUsage>();
        public static final QualifiedUsage QUALIFIED = new QualifiedUsage("qualified");
        public static final QualifiedUsage UNQUALIFIED;
        public static final QualifiedUsage DEFAULT_USAGE;
        public final String name;

        private QualifiedUsage(String _name) {
            this.name = _name;
            map.put(this.name, this);
        }

        public static QualifiedUsage valueOf(String _name) {
            return map.get(_name);
        }

        public static QualifiedUsage forKeyUsageFlags(boolean[] keyUsageFlags) {
            QualifiedUsage result = DEFAULT_USAGE;
            if (keyUsageFlags == null) {
                result = UNQUALIFIED;
            } else if (!(!keyUsageFlags[0] || !keyUsageFlags[1] || keyUsageFlags[2] || keyUsageFlags[3] || keyUsageFlags[4] || keyUsageFlags[7] || keyUsageFlags[8])) {
                result = QUALIFIED;
            }
            return result;
        }

        static {
            DEFAULT_USAGE = UNQUALIFIED = new QualifiedUsage("unqualified");
        }
    }

    public static class ChainEntry {
        private static final Map<String, ChainEntry> entries = new Hashtable<String, ChainEntry>();
        public static final ChainEntry USER = new ChainEntry("user");
        public static final ChainEntry CA = new ChainEntry("ca");
        public static final ChainEntry ROOT = new ChainEntry("root");
        public static final ChainEntry UNKNOWN = new ChainEntry("unknown");
        public static final ChainEntry ATTRIBUTE_USER = new ChainEntry("attribute_user");
        public final String name;

        private ChainEntry(String _name) {
            this.name = _name;
            entries.put(this.name, this);
        }

        public String toString() {
            return this.name;
        }

        public static ChainEntry keyForName(String _name) {
            return entries.get(_name);
        }
    }
}

