/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.gov2.jca_provider.OCFKeyStore;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.impl.JPCSCFactoryImpl;
import de.bos_bremen.java.pcsc.impl.MCardPcscDebugSetting;
import de.bos_bremen.jni.pcsc.PCSCException;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminal;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminalFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Pollable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JPCSCUpdatePollable
implements Pollable {
    private static final Log LOG = LogFactory.getLog(JPCSCUpdatePollable.class);
    private static JPCSCUpdatePollable SINGLETON = null;
    private static JPCSC jpcsc = null;
    private static long contextHandle = 0L;
    private boolean active = false;
    private List<String> listLastReaders = new ArrayList<String>();
    private CardTerminalManager manager = null;
    private boolean shutdown;
    private static OCFKeyStore currentKeyStore;

    public final boolean isActive() {
        return this.active;
    }

    protected synchronized void setReaderList(List<String> listReaders) {
        if (this.isActive()) {
            throw new IllegalStateException("polling activated, reader list can only be changed if deactivated");
        }
        if (CollectionUtil.notNull(listReaders)) {
            this.listLastReaders.clear();
            this.listLastReaders.addAll(listReaders);
        }
    }

    public final void setActive(boolean active) {
        this.active = active;
        if (active) {
            if (OCFProvider.Settings.getInstance().isClientEnvironmentActive()) {
                CardTerminalRegistry.getRegistry().addPollable(SINGLETON);
            }
        } else {
            CardTerminalRegistry.getRegistry().removePollable(SINGLETON);
        }
    }

    public static void setJPCSC(JPCSC instance) {
        jpcsc = instance;
        contextHandle = 0L;
    }

    private JPCSCUpdatePollable(CardTerminalManager manager) {
        AssertUtil.notNull(manager, "manager");
        JPCSCUpdatePollable.setJPCSC((JPCSC)JPCSCFactoryImpl.getFactory().getImplementation(SystemEnum.getCurrentSystem().ordinal()));
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JPCSCUpdatePollable.this.setActive(false);
                }
                catch (Exception e) {
                    LOG.error((Object)("deactivating pollable at shutdown failed: " + e.getMessage()), (Throwable)e);
                }
                try {
                    jpcsc.releaseContext(contextHandle);
                }
                catch (PCSCException e) {
                    LOG.error((Object)("releasing PC/SC context at shutdown failed: " + e.getMessage()), (Throwable)e);
                }
            }
        }, "JPCSCUpdatePollable-Shutdown"));
        this.manager = manager;
    }

    public static synchronized JPCSCUpdatePollable getInstance(CardTerminalManager manager) {
        if (SINGLETON == null) {
            SINGLETON = new JPCSCUpdatePollable(manager);
        }
        return SINGLETON;
    }

    @Override
    public void poll() throws CardTerminalException {
        if (jpcsc == null) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.listLastReaders == null) {
            this.listLastReaders = new ArrayList<String>();
        }
        List<String> currentReaderList = this.getCurrentReaders();
        List<String> removedReaderList = JPCSCUpdatePollable.detectRemovedReaders(currentReaderList, this.listLastReaders);
        List<String> addedReaderList = JPCSCUpdatePollable.detectAddedReaders(currentReaderList, this.listLastReaders);
        this.listLastReaders = currentReaderList;
        if (!(MCardPcscDebugSetting.TERMINAL_CHANGE_UPDATE.isEnabled() || removedReaderList.isEmpty() && addedReaderList.isEmpty())) {
            if (currentKeyStore != null) {
                currentKeyStore.reload();
            }
            return;
        }
        if (!this.shutdown) {
            JPCSCUpdatePollable.removeReaders(removedReaderList);
        } else {
            this.shutdown = false;
        }
        this.addReaders(addedReaderList);
    }

    private static List<String> detectRemovedReaders(List<String> currentReaderList, List<String> listLastReaders) {
        ArrayList<String> removedReaderList = new ArrayList<String>();
        removedReaderList.addAll(listLastReaders);
        removedReaderList.removeAll(currentReaderList);
        return removedReaderList;
    }

    private static List<String> detectAddedReaders(List<String> currentReaderList, List<String> listLastReaders) {
        ArrayList<String> addedReaderList = new ArrayList<String>();
        addedReaderList.addAll(currentReaderList);
        addedReaderList.removeAll(listLastReaders);
        return addedReaderList;
    }

    private void removeOCFRegisteredReaders(List<String> readerList) {
        if (!readerList.isEmpty()) {
            LOG.debug((Object)("readers to add/remove already registered terminals: " + readerList));
            for (CardTerminal terminal : Collections.list(CardTerminalRegistry.getRegistry().getCardTerminals())) {
                if (!JPCSCCardTerminal.class.isInstance(terminal)) continue;
                readerList.remove(terminal.getName());
            }
        }
    }

    private void addReaders(final List<String> readerList) {
        this.removeOCFRegisteredReaders(readerList);
        if (!readerList.isEmpty()) {
            LOG.info((Object)("readers to add: " + readerList));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        JPCSCCardTerminalFactory pf = new JPCSCCardTerminalFactory();
                        CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
                        for (String tn : readerList) {
                            try {
                                pf.createCardTerminals(ctr, new String[]{tn});
                                for (CardTerminal ct : Collections.list(ctr.getCardTerminals())) {
                                    if (!ct.getName().contains(tn)) continue;
                                    LOG.info((Object)("terminal connected: " + tn));
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                        new FilteredPresentCardsEventsGenerator(JPCSCUpdatePollable.this.manager, readerList);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }

    private static void removeReaders(List<String> readerList) {
        if (!readerList.isEmpty()) {
            LOG.info((Object)("readers to remove: " + readerList));
            try {
                CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
                ArrayList<CardTerminal> enumTerminals = Collections.list(ctr.getCardTerminals());
                for (String tn : readerList) {
                    for (CardTerminal ct : enumTerminals) {
                        if (!JPCSCCardTerminal.class.isInstance(ct) || !ct.getName().equals(tn)) continue;
                        ((JPCSCCardTerminal)JPCSCCardTerminal.class.cast(ct)).removePollable();
                        ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).removeTerminal(ct);
                        try {
                            ctr.remove(ct);
                            JPCSCCardTerminalFactory.removeInternalUsedTerminalType(((JPCSCCardTerminal)JPCSCCardTerminal.class.cast(ct)).getTerminalType());
                            boolean disconnected = true;
                            for (CardTerminal c : Collections.list(ctr.getCardTerminals())) {
                                if (!c.getName().equals(tn)) continue;
                                disconnected = false;
                                break;
                            }
                            if (!disconnected) continue;
                            LOG.info((Object)("terminal disconnected: " + tn));
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCurrentReaders() {
        String[] currentReaders = new String[]{};
        try {
            JPCSCUpdatePollable jPCSCUpdatePollable = SINGLETON;
            synchronized (jPCSCUpdatePollable) {
                if (contextHandle == 0L) {
                    contextHandle = jpcsc.establishContext(0, null, null);
                }
            }
            currentReaders = jpcsc.listReaders(contextHandle, null);
        }
        catch (PCSCException e) {
            currentReaders = new String[]{};
        }
        ArrayList<String> currentReaderList = new ArrayList<String>();
        currentReaderList.addAll(Arrays.asList(currentReaders));
        return currentReaderList;
    }

    public void indicateShutdown() {
        this.shutdown = true;
        this.setActive(false);
    }

    public static void setCurrentKeyStore(OCFKeyStore ocfKeyStore) {
        currentKeyStore = ocfKeyStore;
    }

    static class FilteredPresentCardsEventsGenerator
    implements CTListener {
        private CardTerminalManager manager = null;
        private List<String> listReaders = null;

        public FilteredPresentCardsEventsGenerator(CardTerminalManager manager, List<String> listReaders) {
            if (CollectionUtil.notNullOrEmpty(listReaders)) {
                this.manager = manager;
                this.listReaders = listReaders;
                try {
                    EventGenerator.getGenerator().createEventsForPresentCards(this);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
            CardTerminal cardTerminal = ctEvent.getCardTerminal();
            if (cardTerminal != null && this.listReaders.contains(cardTerminal.getName())) {
                this.manager.cardInserted(ctEvent);
            }
        }

        @Override
        public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        }
    }
}

