/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.gov2.jca_provider.ocf.AbstractResult;
import de.bos_bremen.gov2.jca_provider.ocf.Parameter;
import de.bos_bremen.gov2.jca_provider.ocf.Result;
import de.bos_bremen.gov2.jca_provider.ocf.model.Card;
import java.util.List;

public interface FunctionCard {
    public <T extends FunctionParameter, S extends FunctionResult> S executeFunction(Function var1, T var2);

    public List<Function> getSupportedFunctions();

    public static enum Function implements FunctionConstants
    {
        NONE("NONE", -1, null, null, null),
        EPA_RESTRICTED_IDENTIFICATION("RestrictedIdentification", 0, null, SimpleFunctionResult.class, null),
        EPA_VERIFICATION_AGE("AgeVerification", 1, null, SimpleFunctionResult.class, null),
        EPA_VERIFICATION_COMMUNITY("CommunityVerification", 2, null, SimpleFunctionResult.class, null),
        EPA_VERIFICATION_DOCUMENT_VALIDITY("DocumentValidityVerification", 3, null, SimpleFunctionResult.class, null);

        private String name = null;
        private int function = -1;
        private Class<? extends FunctionParameter> parameterClass = null;
        private Class<? extends FunctionResult> resultClass = null;

        private Function(String name, int function, Class<? extends FunctionParameter> parameterClass, Class<? extends FunctionResult> resultClass, CardChecker checker) {
            this.name = name;
            this.function = function;
            this.parameterClass = parameterClass;
            this.resultClass = resultClass;
        }

        public String getName() {
            return this.name;
        }

        public int getFunction() {
            return this.function;
        }

        public Class<? extends FunctionParameter> getParameterClass() {
            return this.parameterClass;
        }

        public Class<? extends FunctionResult> getResultClass() {
            return this.resultClass;
        }
    }

    public static interface CardChecker {
        public void checkCard(Card var1) throws IllegalStateException;
    }

    public static class SimpleFunctionResult
    extends AbstractResult<Boolean>
    implements FunctionResult {
        public SimpleFunctionResult(Throwable throwable) {
            super(Boolean.FALSE, throwable);
        }

        public SimpleFunctionResult(boolean functionSuccessfulExecuted) {
            super(functionSuccessfulExecuted ? Boolean.TRUE : Boolean.FALSE, null);
        }

        @Override
        public boolean isFunctionSuccessfulExecuted() {
            return (Boolean)super.getData();
        }
    }

    public static interface FunctionResult
    extends Result<Boolean> {
        public boolean isFunctionSuccessfulExecuted();
    }

    public static interface FunctionParameter
    extends Parameter {
    }

    public static interface FunctionConstants {
        public static final int FUNCTION_NONE = -1;
        public static final int FUNCTION_EPA_RESTRICTED_IDENTIFICATION = 0;
        public static final int FUNCTION_EPA_VERIFICATION_AGE = 1;
        public static final int FUNCTION_EPA_VERIFICATION_COMMUNITY = 2;
        public static final int FUNCTION_EPA_VERIFICATION_DOCUMENT_VALIDITY = 3;
    }
}

