/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.gov2.jca_provider.ocf.CertificateLoader;
import de.bos_bremen.gov2.jca_provider.ocf.X509CertificateTransportContainer;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultCertificateLoader
implements CertificateLoader {
    public static final Log LOGGER = LogFactory.getLog(DefaultCertificateLoader.class);
    public static final String CERTIFICATE_FACTORY_TYPE_X_509 = "X.509";
    public static final String DEFAULT_PROVIDER_NAME_JCE_CERTIFICATE_FACTORY = "SUN";
    public static final List<String> CERTIFICATE_FACTORY_PROVIDER = Collections.unmodifiableList(Arrays.asList("SUN", "BC", "OCF"));
    private final List<CertificateFactory> listCertificateFactories = new ArrayList<CertificateFactory>();

    public DefaultCertificateLoader() {
        CertificateFactory certificateFactory = null;
        for (String providerName : CERTIFICATE_FACTORY_PROVIDER) {
            try {
                certificateFactory = CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE_X_509, providerName);
                this.listCertificateFactories.add(certificateFactory);
                LOGGER.debug((Object)providerName);
            }
            catch (Exception e) {
                LOGGER.debug((Object)("failed creating CertificateFactory for provider: " + providerName));
            }
        }
        try {
            this.listCertificateFactories.add(CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE_X_509));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"failed creating CertificateFactory for default provider");
        }
    }

    @Override
    public Certificate loadCertificate(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        CertificateResult result = null;
        result = this.generateCertificate(bytes);
        if (result == null) {
            result = this.generateTeleSecCertificate(bytes);
        }
        if (result == null) {
            LOGGER.debug((Object)"certificate not generated, returning transport container instead");
            return new X509CertificateTransportContainer(bytes);
        }
        Certificate certificate = result.getCertificate();
        LOGGER.debug((Object)("certificate generated using provider '" + result.getProviderName() + "': " + certificate));
        return certificate;
    }

    private CertificateResult generateTeleSecCertificate(byte[] bytes) {
        CertificateResult result = null;
        byte[] certDataBytes = bytes;
        try {
            ASN1 fc;
            ASN1 a = new ASN1(bytes);
            if (a.getChildElementCount() >= 1 && (fc = a.getChildElementList().get(0)).getDTag().intValue() == 6 && a.getChildElementCount() >= 2) {
                certDataBytes = a.getChildElementList().get(1).getEncoded();
                result = this.generateCertificate(certDataBytes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private CertificateResult generateCertificate(byte[] bytes) {
        CertificateResult result = null;
        for (CertificateFactory certificateFactory : this.listCertificateFactories) {
            try {
                Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                result = new CertificateResult(certificate, certificateFactory.getProvider().getName());
                break;
            }
            catch (CertificateException certificateException) {
            }
        }
        return result;
    }

    private static class CertificateResult {
        private Certificate certificate = null;
        private String providerName = null;

        public CertificateResult(Certificate certificate, String providerName) {
            this.certificate = certificate;
            this.providerName = providerName;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }

        public String getProviderName() {
            return this.providerName;
        }
    }
}

