/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.BaseAlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.HexUtil;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OCFDefaultAlgorithmFinder;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardKey;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public final class DefaultBaseAlgorithmProviderBuilder {
    private static final Log LOG = LogFactory.getLog(DefaultBaseAlgorithmProviderBuilder.class);

    private DefaultBaseAlgorithmProviderBuilder() {
    }

    public static AlgorithmProvider<OCFPrivateKey> bundle(AlgorithmProvider<OCFPrivateKey> oneAlgorithmProvider, AlgorithmProvider<OCFPrivateKey> anotherAlgorithmProvider) throws NoSuchProviderException {
        ArrayList algorithms = new ArrayList();
        DefaultBaseAlgorithmProviderBuilder.addAlgorithms(oneAlgorithmProvider, algorithms);
        DefaultBaseAlgorithmProviderBuilder.addAlgorithms(anotherAlgorithmProvider, algorithms);
        return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(algorithms);
    }

    public static void addAlgorithms(AlgorithmProvider<OCFPrivateKey> algorithmProvider, List<Algorithm<OCFPrivateKey, ?>> algorithms) {
        if (algorithms == null || algorithmProvider == null || algorithmProvider.getAlgorithms() == null || algorithmProvider.getAlgorithms().isEmpty()) {
            return;
        }
        for (Algorithm<OCFPrivateKey, ?> algorithm : algorithmProvider.getAlgorithms()) {
            if (algorithm == null) continue;
            algorithms.add(algorithm);
        }
    }

    public static List<Boolean> createDigestInfoUsages(int size, Boolean value) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (int i = 0; i < size; ++i) {
            result.add(value);
        }
        return result;
    }

    public static void initCardKey(OCFCertificateInfo info) {
        CardKey key = info.getKey();
        if (key != null && !key.isAlgorithmProviderSet()) {
            try {
                AlgorithmProvider<OCFPrivateKey> algorithmProvider = DefaultBaseAlgorithmProviderBuilder.build(info);
                if (algorithmProvider != null) {
                    key.setAlgorithmProvider(algorithmProvider);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)("failed creating AlgorithmProvider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static AlgorithmProvider<OCFPrivateKey> createAlgorithmProvider(List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        return new BaseAlgorithmProvider<OCFPrivateKey>("OCF", listAlgorithms);
    }

    public static AlgorithmProvider<OCFPrivateKey> build(OCFCertificateInfo info) throws NoSuchProviderException {
        OCFCertificateInfo.Usage usage;
        String providerName = "OCF";
        OCFPrivateKey ocfPrivateKey = info.getCertificateBag().getPrivateKey();
        GovCS cardService = info.getCard().getCardService();
        List<String> hashAlgorithms = cardService.getAvailableHashAlgorithmNames(info);
        if (hashAlgorithms.indexOf(cardService.getStrongestHashAlgorithmName(info)) == hashAlgorithms.size() - 1) {
            Collections.reverse(hashAlgorithms);
        }
        if (OCFCertificateInfo.Usage.UNK == (usage = info.getUsage())) {
            return null;
        }
        List<UsageRelated.Usage> listFallbackUsages = Arrays.asList(UsageRelated.Usage.values());
        ArrayList listAlgorithms = new ArrayList();
        if ("RSA".equals(ocfPrivateKey.getAlgorithm())) {
            if (OCFCertificateInfo.Usage.SIG == usage) {
                DefaultBaseAlgorithmProviderBuilder.addRSASignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.SIGNATURE, listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.AUT == usage) {
                DefaultBaseAlgorithmProviderBuilder.addRSASignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.AUTHENTICATION, listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.ENC == usage) {
                DefaultBaseAlgorithmProviderBuilder.addRSADecrpytionAlgorithm("OCF", listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.ASC == usage) {
                DefaultBaseAlgorithmProviderBuilder.addRSASignatureAuthenticationAlgorithms("OCF", hashAlgorithms, Arrays.asList(UsageRelated.Usage.SIGNATURE, UsageRelated.Usage.AUTHENTICATION), listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.AEN == usage) {
                DefaultBaseAlgorithmProviderBuilder.addRSASignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.AUTHENTICATION, listAlgorithms);
                DefaultBaseAlgorithmProviderBuilder.addRSADecrpytionAlgorithm("OCF", listAlgorithms);
            }
        } else if ("EC".equals(ocfPrivateKey.getAlgorithm())) {
            if (OCFCertificateInfo.Usage.SIG == usage) {
                DefaultBaseAlgorithmProviderBuilder.addECSignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.SIGNATURE, listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.AUT == usage) {
                DefaultBaseAlgorithmProviderBuilder.addECSignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.AUTHENTICATION, listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.ASC == usage) {
                DefaultBaseAlgorithmProviderBuilder.addECSignatureAuthenticationAlgorithms("OCF", hashAlgorithms, Arrays.asList(UsageRelated.Usage.SIGNATURE, UsageRelated.Usage.AUTHENTICATION), listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.AEN == usage) {
                DefaultBaseAlgorithmProviderBuilder.addECSignatureAuthtenticationAlgorithms("OCF", hashAlgorithms, UsageRelated.Usage.AUTHENTICATION, listAlgorithms);
                DefaultBaseAlgorithmProviderBuilder.addECDecrpytionAlgorithm("OCF", listAlgorithms);
            }
            if (OCFCertificateInfo.Usage.ENC == usage) {
                DefaultBaseAlgorithmProviderBuilder.addECDecrpytionAlgorithm("OCF", listAlgorithms);
                listFallbackUsages = Arrays.asList(UsageRelated.Usage.CIPHER, UsageRelated.Usage.KEYAGREEMENT);
            }
        }
        if (listAlgorithms.isEmpty()) {
            return new BaseAlgorithmProvider<OCFPrivateKey>(listFallbackUsages, "OCF");
        }
        return DefaultBaseAlgorithmProviderBuilder.createAlgorithmProvider(listAlgorithms);
    }

    private static void addRSASignatureAuthtenticationAlgorithms(String providerName, List<String> hashAlgorithms, UsageRelated.Usage usageAlgorithm, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        DefaultBaseAlgorithmProviderBuilder.addRSASignatureAuthenticationAlgorithms(providerName, hashAlgorithms, Arrays.asList(usageAlgorithm), listAlgorithms);
    }

    private static void addECSignatureAuthtenticationAlgorithms(String providerName, List<String> hashAlgorithms, UsageRelated.Usage usageAlgorithm, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        DefaultBaseAlgorithmProviderBuilder.addECSignatureAuthenticationAlgorithms(providerName, hashAlgorithms, Arrays.asList(usageAlgorithm), listAlgorithms);
    }

    public static List<Algorithm<OCFPrivateKey, ?>> createSignatureAuthenticationRSAPSSAlgorithms(List<String> hashAlgorithms, List<Boolean> digestInfoUsages, List<String> algorithmIDs, List<UsageRelated.Usage> usageAlgorithms) throws NoSuchProviderException, IllegalArgumentException {
        return DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAAlgorithms(hashAlgorithms, digestInfoUsages, algorithmIDs, usageAlgorithms, "andMGF1", "/PSS");
    }

    public static List<Algorithm<OCFPrivateKey, ?>> createSignatureAuthenticationRSAPKCS1Algorithms(List<String> hashAlgorithms, List<Boolean> digestInfoUsages, List<String> algorithmIDs, List<UsageRelated.Usage> usageAlgorithms) throws NoSuchProviderException, IllegalArgumentException {
        return DefaultBaseAlgorithmProviderBuilder.createSignatureAuthenticationRSAAlgorithms(hashAlgorithms, digestInfoUsages, algorithmIDs, usageAlgorithms, "", "/PKCS1");
    }

    private static List<Algorithm<OCFPrivateKey, ?>> createSignatureAuthenticationRSAAlgorithms(List<String> hashAlgorithms, List<Boolean> digestInfoUsages, List<String> algorithmIDs, List<UsageRelated.Usage> usageAlgorithms, String algorithmSuffix, String alternativeAlgorithmSuffix) throws NoSuchProviderException, IllegalArgumentException {
        ArrayList result = new ArrayList();
        if (CollectionUtil.isNullOrEmptyOrContainsNull(hashAlgorithms)) {
            return result;
        }
        if (CollectionUtil.isNullOrEmptyOrContainsNull(hashAlgorithms)) {
            return result;
        }
        if (CollectionUtil.isNullOrEmpty(digestInfoUsages)) {
            return result;
        }
        if (CollectionUtil.isNullOrEmpty(algorithmIDs)) {
            return result;
        }
        AssertUtil.equals(hashAlgorithms.size(), digestInfoUsages.size(), "list of hash algorithms and digest info usages");
        AssertUtil.equals(hashAlgorithms.size(), algorithmIDs.size(), "list of hash algorithms and algorithm IDs");
        String[] separators = new String[]{"with", "hashedWith"};
        for (int i = 0; i < hashAlgorithms.size(); ++i) {
            String algorithm = hashAlgorithms.get(i);
            Boolean digestInfoUsage = digestInfoUsages.get(i);
            byte[] algorithmID = algorithmIDs.get(i) == null || algorithmIDs.get(i).isEmpty() ? null : HexUtil.parse(algorithmIDs.get(i));
            for (String separator : separators) {
                Algorithm<OCFPrivateKey, CardExecutionSignAuthenticateParameterSpec> a = DefaultBaseAlgorithmProviderBuilder.createAlgorithm(usageAlgorithms, algorithmSuffix, alternativeAlgorithmSuffix, algorithm, digestInfoUsage, algorithmID, separator);
                result.add(a);
            }
        }
        return result;
    }

    public static Algorithm<OCFPrivateKey, CardExecutionSignAuthenticateParameterSpec> createAlgorithm(List<UsageRelated.Usage> usageAlgorithms, String algorithmSuffix, String alternativeAlgorithmSuffix, String algorithm, Boolean digestInfoUsage, String hexAlgorithmID, String separator) throws NoSuchProviderException {
        byte[] algorithmID = hexAlgorithmID == null || hexAlgorithmID.isEmpty() ? null : HexUtil.parse(hexAlgorithmID);
        return DefaultBaseAlgorithmProviderBuilder.createAlgorithm(usageAlgorithms, algorithmSuffix, alternativeAlgorithmSuffix, algorithm, digestInfoUsage, algorithmID, separator);
    }

    public static Algorithm<OCFPrivateKey, CardExecutionSignAuthenticateParameterSpec> createAlgorithm(List<UsageRelated.Usage> usageAlgorithms, String algorithmSuffix, String alternativeAlgorithmSuffix, String algorithm, Boolean digestInfoUsage, byte[] algorithmID, String separator) throws NoSuchProviderException {
        String baseAlgorithmName = algorithm + separator + "RSA";
        String sigAutAlgorithmName = baseAlgorithmName + (algorithmSuffix == null ? "" : algorithmSuffix);
        String sigAutAlternativeAlgorithmName = baseAlgorithmName + (alternativeAlgorithmSuffix == null ? "" : alternativeAlgorithmSuffix);
        Algorithm<OCFPrivateKey, CardExecutionSignAuthenticateParameterSpec> a = new Algorithm<OCFPrivateKey, CardExecutionSignAuthenticateParameterSpec>("OCF", usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), digestInfoUsage, algorithmID));
        return a;
    }

    private static void addRSASignatureAuthenticationAlgorithms(String providerName, List<String> hashAlgorithms, List<UsageRelated.Usage> usageAlgorithms, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        String[] separators = new String[]{"with", "hashedWith"};
        for (String hashAlgorithm : hashAlgorithms) {
            for (String separator : separators) {
                String sigAutAlgorithmName = hashAlgorithm + separator + "RSA";
                String sigAutAlternativeAlgorithmName = sigAutAlgorithmName + "/PKCS1";
                listAlgorithms.add(new Algorithm(providerName, usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), null, null)));
            }
        }
    }

    private static void addECSignatureAuthenticationAlgorithms(String providerName, List<String> hashAlgorithms, List<UsageRelated.Usage> usageAlgorithms, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        String[] separators = new String[]{"with", "hashedWith"};
        String[] formats = new String[]{"ECDSA", "CVC-ECDSA"};
        for (String hashAlgorithm : hashAlgorithms) {
            for (String separator : separators) {
                for (String format : formats) {
                    String sigAutAlgorithmName;
                    String sigAutAlternativeAlgorithmName = sigAutAlgorithmName = hashAlgorithm + separator + format;
                    listAlgorithms.add(new Algorithm(providerName, usageAlgorithms, sigAutAlgorithmName, sigAutAlternativeAlgorithmName, new CardExecutionSignAuthenticateParameterSpec(sigAutAlgorithmName, OCFDefaultAlgorithmFinder.getInstance().find(sigAutAlgorithmName), OCFDefaultAlgorithmFinder.getInstance().findURI(sigAutAlgorithmName), null, null)));
                }
            }
        }
    }

    private static void addECDecrpytionAlgorithm(String providerName, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) {
        LOG.debug((Object)("no EC default decryption algorithms defined: " + providerName + ", " + listAlgorithms));
    }

    private static void addRSADecrpytionAlgorithm(String providerName, List<Algorithm<OCFPrivateKey, ?>> listAlgorithms) throws NoSuchProviderException {
        String algorithmName = "RSA/ECB/PKCS1Padding";
        String alternativeAlgorithmName = "RSA/PKCS1";
        OCFDefaultAlgorithmFinder finder = OCFDefaultAlgorithmFinder.getInstance();
        listAlgorithms.add(new Algorithm(providerName, Arrays.asList(UsageRelated.Usage.CIPHER), algorithmName, alternativeAlgorithmName, new CardExecutionDecryptRSAParameterSpec(algorithmName, new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), finder.findURI("RSA/ECB/PKCS1Padding"), null)));
    }
}

