/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.ocf;

import de.bos_bremen.common.system.SystemEnum;
import de.bos_bremen.gov2.jca_provider.OCFProvider;
import de.bos_bremen.gov2.jca_provider.ocf.CertificateLoader;
import de.bos_bremen.gov2.jca_provider.ocf.JPCSCUpdatePollable;
import de.bos_bremen.gov2.jca_provider.ocf.ProblemManager;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialogDelegate;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCHVDialogProvider;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSListener;
import de.bos_bremen.gov2.jca_provider.ocf.cards.default_gui.DefaultGovCHVDialog;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import de.bos_bremen.java.ctapi.JCTAPIConnection;
import de.bos_bremen.java.ctapi.JCTAPIConnectionManager;
import de.bos_bremen.java.ctapi.JCTAPILibraryManager;
import de.bos_bremen.java.pcsc.JPCSC;
import de.bos_bremen.java.pcsc.impl.JPCSCFactoryImpl;
import de.bos_bremen.jni.JavaSystemBridge;
import de.bos_bremen.opencard.terminal.MetaCardTerminalFactory;
import de.bos_bremen.opencard.terminal.bcs.AbstractOCFBCSTerminal;
import de.bos_bremen.opencard.terminal.bcs.OCFBCSTerminalFactory;
import de.bos_bremen.opencard.terminal.pcsc.JPCSCCardTerminalFactory;
import de.bos_bremen.opencard.terminal.pcsc.PCSCCardTerminal;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.OpenCardConfigurationProvider;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardTerminalManager
implements CTListener {
    private static final String DEFAULT_DIALOG = DefaultGovCHVDialog.class.getName();
    private static final Log log = LogFactory.getLog(CardTerminalManager.class);
    public static final String CHV_CLASS = "chvdialog_classname";
    public static final String TERMINALS = "terminals";
    public static final String USE_KEYBOARD = "use_keyboard";
    private static final String CARD_TERMINAL_FACTORY_JPCSC = JPCSCCardTerminalFactory.class.getName();
    private static final String CARD_TERMINAL_FACTORY_CTAPI = OCFBCSTerminalFactory.class.getName();
    private static final String CARD_TERMINAL_FACTORY_META = MetaCardTerminalFactory.class.getName();
    private static transient CardTerminalManager SINGLETON;
    private boolean nativeLibrariesLoadedAndDriversInitialized = false;
    private Class<?> chvDialogClass = null;
    private Object parentWindow = null;
    private Vector<GovCS> services = new Vector();
    private Vector<GovCSListener> govCSListeners = new Vector();
    private List<CTListener> listenerList = null;
    private Properties ocfProperties = null;
    private ProgressSessionListener progressSessionListener = null;
    private boolean useCTAPI = true;
    private boolean useJPCSC = true;
    private CertificateLoader certLoader;
    private Map<String, Thread> recognitionInsertThreads = Collections.synchronizedMap(new HashMap());
    private Map<String, Thread> recognitionRemoveThreads = Collections.synchronizedMap(new HashMap());

    private CardTerminalManager(Properties _ocfProperties, ProgressSessionListener _progressSessionListener, CertificateLoader _certLoader) {
        this.listenerList = new ArrayList<CTListener>();
        this.ensureNativeLibrariesAvailableAndInitializeDriver();
        log.debug((Object)("JPCSC available : " + this.useJPCSC));
        log.debug((Object)("CTAPI available : " + this.useCTAPI));
        if (!this.useJPCSC && !this.useCTAPI) {
            log.debug((Object)"neither PCSC supported - won't start");
            return;
        }
        this.ocfProperties = _ocfProperties;
        if (this.ocfProperties == null) {
            this.ocfProperties = new Properties();
        }
        this.progressSessionListener = _progressSessionListener;
        if (this.certLoader == null) {
            this.certLoader = _certLoader;
        }
        this.chvDialogClass = this.getCHVDialogClass();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                this.shutdownOCF();
            }

            protected void shutdownOCF() {
                try {
                    if (SmartCard.isStarted()) {
                        EventGenerator.getGenerator().removeAllCTListeners();
                        CardObjectRegistryImpl.getInstance().removeAllCardListener();
                        SmartCard.shutdown();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            protected void shutdownPCSC() {
            }

            protected void shutdownCTAPI() {
                try {
                    JCTAPIConnectionManager manny = JCTAPIConnectionManager.getConnectionManager();
                    for (JCTAPIConnection conny : manny.getConnectionList()) {
                        manny.removeConnection(conny);
                    }
                    JCTAPILibraryManager libby = JCTAPILibraryManager.getLibraryManager();
                    for (Long hanny : OCFBCSTerminalFactory.getListUsedHandles()) {
                        try {
                            libby.unloadLibrary(hanny);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            protected void shutdownMCard() {
                if (SmartCard.isStarted()) {
                    try {
                        CardTerminalManager.this.stopSmartCardServices();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, "CardTerminalManager-Shutdown"));
    }

    public static synchronized CardTerminalManager getInstance(Properties _ocfProperties, ProgressSessionListener _progressSessionListener, CertificateLoader _certificateLoader) {
        if (SINGLETON == null) {
            SINGLETON = new CardTerminalManager(_ocfProperties, _progressSessionListener, _certificateLoader);
        }
        SINGLETON.startSmartCardServices(false);
        return SINGLETON;
    }

    public boolean isAvailable() {
        return this.useJPCSC || this.useCTAPI;
    }

    public synchronized void startSmartCardServices() {
        this.startSmartCardServices(false);
    }

    private synchronized void startSmartCardServices(boolean _recursed) {
        log.debug((Object)"start up Smart Card Services ...");
        if (SmartCard.isStarted()) {
            log.debug((Object)"... already started up Smart Card Services - done!");
            return;
        }
        if (this.useJPCSC) {
            JPCSC instance = (JPCSC)JPCSCFactoryImpl.getFactory().getImplementation(SystemEnum.getCurrentSystem().ordinal());
            JPCSCCardTerminalFactory.setJPCSC(instance);
            JPCSCUpdatePollable.setJPCSC(instance);
        }
        JPCSCUpdatePollable pollable = this.managePCSCPollable(null, false, null);
        System.setSecurityManager(null);
        if (!this.useJPCSC && !this.useCTAPI) {
            log.debug((Object)"not starting, no driver available");
            return;
        }
        if (this.ocfProperties == null) {
            log.debug((Object)"not starting, properties not set");
            return;
        }
        try {
            String s = null;
            if (s != null) {
                if (!this.useJPCSC) {
                    s = s.replaceAll(CARD_TERMINAL_FACTORY_JPCSC, "");
                }
                if (!this.useCTAPI) {
                    s = s.replaceAll(CARD_TERMINAL_FACTORY_CTAPI, "");
                }
            }
            if (s == null) {
                s = CARD_TERMINAL_FACTORY_META;
            }
            System.setProperty("OpenCard.terminals", s == null ? "" : s);
            System.setProperty("OpenCard.services", OCFProvider.Settings.getInstance().getCardServiceFactory());
            System.setProperty("OpenCard.loaderClassName", EmptyOpenCardConfigurationProvider.class.getName());
            SmartCard.start();
            log.debug((Object)"... start up Smart Card Services done!");
        }
        catch (Throwable ex) {
            if (ex instanceof CardTerminalException) {
                ProblemManager.getManager().getProblems().add(ex);
            }
            if (!_recursed && ex.getMessage() != null && ex.getMessage().indexOf("JPCSCCardTerminal") != -1) {
                this.useJPCSC = false;
                try {
                    SmartCard.shutdown();
                }
                catch (CardTerminalException ex1) {
                    log.fatal((Object)"", (Throwable)ex1);
                    return;
                }
                log.debug((Object)"just trace 1. : ", ex);
                this.startSmartCardServices(true);
            }
            log.debug((Object)"just trace 2. : ", ex);
            return;
        }
        log.debug((Object)"registered card terminals:");
        Enumeration<CardTerminal> e = CardTerminalRegistry.getRegistry().getCardTerminals();
        ArrayList<String> listReaders = new ArrayList<String>();
        while (e.hasMoreElements()) {
            CardTerminal ct = e.nextElement();
            String cardPresent = "";
            try {
                cardPresent = ct.isCardPresent(0) ? "card present" : "card absent";
            }
            catch (CardTerminalException e1) {
                cardPresent = "failed";
            }
            log.debug((Object)("  " + ct.getName() + " [" + cardPresent + "]"));
            listReaders.add(ct.getName());
        }
        log.debug((Object)"--------------------------");
        EventGenerator.getGenerator().removeCTListener(this);
        EventGenerator.getGenerator().addCTListener(this);
        try {
            EventGenerator.getGenerator().createEventsForPresentCards(this);
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        this.managePCSCPollable(pollable, true, listReaders);
        ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).start(this);
    }

    private JPCSCUpdatePollable managePCSCPollable(JPCSCUpdatePollable pollable, boolean active, List<String> readerList) {
        JPCSCUpdatePollable lPollable;
        JPCSCUpdatePollable jPCSCUpdatePollable = lPollable = pollable == null ? JPCSCUpdatePollable.getInstance(this) : pollable;
        if (this.useJPCSC) {
            List<String> lReaderList;
            List<Object> list = lReaderList = readerList == null ? Collections.emptyList() : readerList;
            if (!lPollable.isActive() && active) {
                lPollable.setReaderList(lReaderList);
            }
            lPollable.setActive(active);
            if (!active) {
                lPollable.setReaderList(lReaderList);
            }
        }
        return lPollable;
    }

    public synchronized void stopSmartCardServices() {
        if (!SmartCard.isStarted()) {
            log.debug((Object)"... already stopped Smart Card Services - done!");
            return;
        }
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        JPCSCUpdatePollable pollable = this.managePCSCPollable(null, false, null);
        JPCSCCardTerminalFactory.clearUsedTerminalTypesList();
        OCFBCSTerminalFactory.clearUsedTerminalTypesList();
        try {
            Class<?> c = Class.forName("de.bos_bremen.gov2.jca_provider.ocf.cards.debug.ZCxxZeitControlBasicCardDebug");
            Field f = c.getField("instanceCounter");
            f.set(null, 0);
        }
        catch (Throwable c) {
            // empty catch block
        }
        try {
            log.debug((Object)"shut down Smart Card Services ...");
            SmartCard.shutdown();
            log.debug((Object)"... shut down Smart Card Services done!");
            this.services.clear();
        }
        catch (Exception ex) {
            log.debug((Object)"just trace : ", (Throwable)ex);
        }
        pollable.indicateShutdown();
        ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).shutdown(this);
    }

    private void ensureNativeLibrariesAvailableAndInitializeDriver() {
        if (this.nativeLibrariesLoadedAndDriversInitialized) {
            return;
        }
        try {
            JavaSystemBridge.loadLibrary();
            this.nativeLibrariesLoadedAndDriversInitialized = true;
        }
        catch (Throwable e) {
            log.debug((Object)"loading JSB failed, requirements not satisfied: PC/SC and CT-API not available, see causing Exception for details", e);
            this.useJPCSC = false;
            this.useCTAPI = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInserted(final CardTerminalEvent ctEvent) throws CardTerminalException {
        final String terminalSlot = ctEvent.getCardTerminal() + "-" + ctEvent.getSlotID();
        if (this.recognitionInsertThreads.containsKey(terminalSlot)) {
            return;
        }
        Map<String, Thread> map = this.recognitionRemoveThreads;
        synchronized (map) {
            if (this.recognitionRemoveThreads.containsKey(terminalSlot)) {
                this.recognitionRemoveThreads.get(terminalSlot).stop();
            }
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SmartCard sc;
                CardTerminal ct;
                block15: {
                    block14: {
                        log.debug((Object)("cardInserted: " + Thread.currentThread().getStackTrace()[2] + new SimpleDateFormat("kk:mm:ss.SSS").format(new Date(System.currentTimeMillis()))));
                        if (!CardTerminalManager.this.isAvailable()) {
                            throw new NullPointerException("uninitializable");
                        }
                        ct = ctEvent.getCardTerminal();
                        CardObjectRegistryImpl registry = (CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance();
                        registry.addTerminal(ct);
                        try {
                            CardRequest cr = new CardRequest(1, ct, GovCS.class);
                            try {
                                sc = SmartCard.getSmartCard(ctEvent, cr);
                            }
                            catch (CardTerminalException e1) {
                                CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                                CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                            CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                            throw throwable;
                        }
                        if (sc == null || !PCSCCardTerminal.class.isInstance(ct) || ((PCSCCardTerminal)ct).isTransactionLocked()) break block14;
                        log.debug((Object)"PC/SC terminal not locked: transaction not started");
                        CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                        CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                        return;
                    }
                    if (sc != null) break block15;
                    log.debug((Object)"sending event to registered CardListener about processed card (card was not recognized and/or is not supported");
                    ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).notifyCardListenerUnknownCard();
                    CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                    CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                    return;
                }
                GovCS gcs = null;
                try {
                    gcs = (GovCS)sc.getCardService(GovCS.class, true);
                }
                catch (Throwable ex) {
                    log.debug((Object)"just trace : ", ex);
                    ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).notifyCardListener(sc);
                    CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                    CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                    return;
                }
                ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).addCard(CardTerminalManager.this, ctEvent, sc, gcs);
                try {
                    gcs.analizeCardTerminal(ct, Boolean.valueOf(CardTerminalManager.this.ocfProperties.getProperty(CardTerminalManager.USE_KEYBOARD)));
                }
                catch (CardTerminalException e) {
                    CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                    CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
                    return;
                }
                gcs.setProgressSessionListener(CardTerminalManager.this.progressSessionListener);
                gcs.setParentWindow(CardTerminalManager.this.parentWindow);
                gcs.setGovCHVDialog(CardTerminalManager.this.chvDialogClass);
                gcs.setCertLoader(CardTerminalManager.this.certLoader);
                CardTerminalManager.this.services.add(gcs);
                CardTerminalManager.this.fireGovCSAdded(gcs);
                ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).notifyCardListener(sc);
                CardTerminalManager.this.recognitionInsertThreads.remove(terminalSlot);
                CardTerminalManager.endTransaction(ct, !PCSCCardTerminal.class.isInstance(ct) ? false : ((PCSCCardTerminal)ct).isTransactionLocked());
            }
        }, "INSERT-" + ctEvent.getCardTerminal().getName() + "-" + ctEvent.getSlotID());
        this.recognitionInsertThreads.put(terminalSlot, t);
        t.start();
    }

    public static boolean beginTransaction(CardTerminal ct) {
        return CardTerminalManager.beginTransaction(ct, 10000L);
    }

    public static boolean beginTransaction(CardTerminal ct, long timeout) {
        boolean transactionStarted = false;
        PCSCCardTerminal pcsct = null;
        if (PCSCCardTerminal.class.isInstance(ct)) {
            pcsct = (PCSCCardTerminal)ct;
        }
        if (pcsct != null) {
            try {
                while (!transactionStarted) {
                    transactionStarted = pcsct.beginTransaction(timeout);
                }
            }
            catch (IllegalStateException e) {
                return false;
            }
            log.debug((Object)("transaction.start: " + new SimpleDateFormat("kk:mm:ss.SSS").format(new Date(System.currentTimeMillis()))));
        }
        return transactionStarted;
    }

    public static boolean isTransactionStarted(CardTerminal ct) {
        boolean transactionStarted = false;
        PCSCCardTerminal pcsct = null;
        if (PCSCCardTerminal.class.isInstance(ct)) {
            pcsct = (PCSCCardTerminal)ct;
            if (pcsct != null) {
                transactionStarted = pcsct.isTransactionLocked();
            }
        } else if (AbstractOCFBCSTerminal.class.isInstance(ct)) {
            transactionStarted = ((AbstractOCFBCSTerminal)AbstractOCFBCSTerminal.class.cast(ct)).isConnected();
        }
        return transactionStarted;
    }

    public static void endTransaction(CardTerminal ct, boolean transactionStarted) {
        if (!transactionStarted) {
            return;
        }
        PCSCCardTerminal pcsct = null;
        if (PCSCCardTerminal.class.isInstance(ct)) {
            pcsct = (PCSCCardTerminal)ct;
        }
        if (pcsct != null) {
            try {
                while (!pcsct.endTransaction()) {
                }
            }
            catch (IllegalStateException e) {
                return;
            }
            log.debug((Object)("transaction.end: " + new SimpleDateFormat("kk:mm:ss.SSS").format(new Date(System.currentTimeMillis()))));
        }
    }

    public synchronized void addListener(CTListener listener) {
        if (listener != null && this.listenerList != null && !this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public synchronized void removeListener(CTListener listener) {
        if (listener != null && this.listenerList != null && this.listenerList.contains(listener)) {
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardRemoved(final CardTerminalEvent ctEvent) throws CardTerminalException {
        final String terminalSlot = ctEvent.getCardTerminal() + "-" + ctEvent.getSlotID();
        if (this.recognitionRemoveThreads.containsKey(terminalSlot)) {
            return;
        }
        Map<String, Thread> map = this.recognitionInsertThreads;
        synchronized (map) {
            if (this.recognitionInsertThreads.containsKey(terminalSlot)) {
                this.recognitionInsertThreads.get(terminalSlot).stop();
            }
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (CardTerminalManager.this.listenerList != null) {
                        for (CTListener l : CardTerminalManager.this.listenerList) {
                            try {
                                l.cardRemoved(ctEvent);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    log.debug((Object)("card removed from '" + ctEvent.getCardTerminal().getName() + "' at slot " + ctEvent.getSlotID()));
                    if (!CardTerminalManager.this.isAvailable()) {
                        throw new NullPointerException("uninitializable");
                    }
                    CardTerminal ct = ctEvent.getCardTerminal();
                    Iterator<GovCS> iter = CardTerminalManager.this.services.iterator();
                    while (iter.hasNext()) {
                        GovCS item = iter.next();
                        if (!ct.equals(item.getCardTerminal())) continue;
                        item.close(ctEvent);
                        log.debug((Object)("card '" + item.getDisplayName() + "' removed"));
                        iter.remove();
                        try {
                            item.reset();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        CardTerminalManager.this.fireGovCSRemoved(item);
                        break;
                    }
                    ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).removeCard(ctEvent);
                }
                finally {
                    CardTerminalManager.this.recognitionRemoveThreads.remove(terminalSlot);
                }
            }
        }, "REMOVE-" + ctEvent.getCardTerminal().getName() + "-" + ctEvent.getSlotID());
        this.recognitionRemoveThreads.put(terminalSlot, t);
        t.start();
    }

    public void fireGovCSAdded(GovCS _addedGovCS) {
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        for (GovCSListener l : this.govCSListeners) {
            l.cardServiceAdded(_addedGovCS);
        }
    }

    public void fireGovCSRemoved(GovCS _removedGovCS) {
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        for (GovCSListener l : this.govCSListeners) {
            l.cardServiceRemoved(_removedGovCS);
        }
    }

    public void addGovCSListener(GovCSListener listener) {
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        this.govCSListeners.add(listener);
    }

    public void removeGovCSListener(GovCSListener listener) {
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        this.govCSListeners.remove(listener);
    }

    public Vector<GovCS> getConnectedCardServices() {
        if (!this.isAvailable()) {
            throw new NullPointerException("uninitializable");
        }
        return new Vector<GovCS>(this.services);
    }

    public void setParentWindow(Object _parentWindow) {
        if (!this.useJPCSC && !this.useCTAPI) {
            throw new NullPointerException("uninitializable");
        }
        this.parentWindow = _parentWindow;
        for (GovCS cs : this.services) {
            cs.setParentWindow(this.parentWindow);
        }
    }

    protected Class<?> getCHVDialogClass() {
        if (!this.useJPCSC && !this.useCTAPI) {
            throw new NullPointerException("uninitializable");
        }
        Class<?> result = null;
        String classname = this.ocfProperties.getProperty(CHV_CLASS);
        GovCHVDialogProvider provider = GovCHVDialogProvider.getInstance();
        if (!GovCHVDialogDelegate.class.getName().equals(classname)) {
            provider.setDialogClass(classname);
        }
        if ((classname = GovCHVDialogDelegate.class.getName()) != null) {
            try {
                result = Class.forName(classname);
                result.newInstance();
            }
            catch (Throwable ex) {
                log.error((Object)("can't create chv dialog from property\n\t " + classname + "\n-> use default instead..."), ex);
                result = null;
            }
        }
        if (result == null) {
            result = this.createDefaultCHVDialog();
        }
        return result;
    }

    private Class<?> createDefaultCHVDialog() {
        if (!this.useJPCSC && !this.useCTAPI) {
            throw new NullPointerException("uninitializable");
        }
        Class<?> result = null;
        String classname = DEFAULT_DIALOG;
        GovCHVDialogProvider provider = GovCHVDialogProvider.getInstance();
        provider.setDialogClass(classname);
        classname = GovCHVDialogDelegate.class.getName();
        try {
            result = Class.forName(classname);
            result.newInstance();
        }
        catch (Throwable ex) {
            throw new InstantiationError("no class found implementing \"GovCHVDialog\"");
        }
        return result;
    }

    public static boolean supportsReaderReset(CardTerminal terminal) {
        return terminal == null ? false : CardTerminalManager.supportsReaderReset(terminal.getName());
    }

    public static boolean supportsReaderReset(String terminalName) {
        return terminalName.indexOf("5x21") < 0;
    }

    public static class EmptyOpenCardConfigurationProvider
    implements OpenCardConfigurationProvider {
        @Override
        public void loadProperties() throws OpenCardPropertyLoadingException {
        }
    }
}

