/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.eccipher.ECUtils;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHCUnifiedAgreement;
import org.bouncycastle.crypto.agreement.ECMQVBasicAgreement;
import org.bouncycastle.crypto.agreement.kdf.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDHUPrivateParameters;
import org.bouncycastle.crypto.params.ECDHUPublicParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.MQVPrivateParameters;
import org.bouncycastle.crypto.params.MQVPublicParameters;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.bouncycastle.jcajce.provider.symmetric.DESede;
import org.bouncycastle.jcajce.spec.DHUParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.interfaces.MQVPrivateKey;
import org.bouncycastle.jce.interfaces.MQVPublicKey;
import org.bouncycastle.util.Arrays;

public class OCFECDHKeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private final String kaAlgorithmValue;
    private ECDomainParameters parameters;
    private Object agreement;
    private MQVParameterSpec mqvParameters;
    private DHUParameterSpec dheParameters;
    private byte[] result;
    private OCFPrivateKey ocfkey;

    public static Recipient createRecipient(OCFPrivateKey key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("key required to create recipient");
        }
        return OCFECDHKeyAgreementSpi.createRecipient(key, key.getOCFCertificatInfo().getX509Certificate());
    }

    public static Recipient createRecipient(PrivateKey key, Certificate certificate) throws Exception {
        String providerName;
        if (key == null) {
            throw new IllegalArgumentException("key required to create recipient");
        }
        String string = providerName = key instanceof OCFPrivateKey ? "OCF" : "BC";
        if ("EC".equals(key.getAlgorithm())) {
            JceKeyAgreeEnvelopedRecipient jceKeyAgreeEnvelopedRecipient = new JceKeyAgreeEnvelopedRecipient(key);
            jceKeyAgreeEnvelopedRecipient.setProvider(providerName);
            jceKeyAgreeEnvelopedRecipient.setContentProvider("BC");
            if (key instanceof OCFPrivateKey) {
                if (certificate == null) {
                    throw new IllegalArgumentException("certificate required in case of OCF key");
                }
                AlgorithmIdentifier privateKeyAlgorithm = new X509CertificateHolder(((OCFPrivateKey)key).getOCFCertificatInfo().getX509Certificate().getEncoded()).getSubjectPublicKeyInfo().getAlgorithm();
                jceKeyAgreeEnvelopedRecipient.setPrivateKeyAlgorithmIdentifier(privateKeyAlgorithm);
            }
            return jceKeyAgreeEnvelopedRecipient;
        }
        JceKeyTransEnvelopedRecipient jceKeyTransEnvelopedRecipient = new JceKeyTransEnvelopedRecipient(key);
        jceKeyTransEnvelopedRecipient.setProvider(providerName);
        jceKeyTransEnvelopedRecipient.setContentProvider("BC");
        return jceKeyTransEnvelopedRecipient;
    }

    public static void addCMSEntries(Provider provider) {
        provider.put("KeyAgreement.1.3.133.16.840.63.0.2", DHwithSHA1KDFAndSharedInfo.class.getName());
        provider.put("KeyAgreement.1.3.132.1.11.0", DHwithSHA224KDFAndSharedInfo.class.getName());
        provider.put("KeyAgreement.1.3.132.1.11.1", DHwithSHA256KDFAndSharedInfo.class.getName());
        provider.put("KeyAgreement.1.3.132.1.11.2", DHwithSHA384KDFAndSharedInfo.class.getName());
        provider.put("KeyAgreement.1.3.132.1.11.3", DHwithSHA512KDFAndSharedInfo.class.getName());
        provider.put("KeyFactory.EC", KeyFactorySpi.EC.class.getName());
        provider.put("Alg.Alias.KeyFactory.1.2.840.10045.2.1", "EC");
        provider.put("KeyPairGenerator.EC", KeyPairGeneratorSpi.EC.class.getName());
        provider.put("Alg.Alias.KeyPairGenerator.1.3.132.1.11.3", "EC");
        provider.put("Cipher.1.2.840.113549.3.7", DESede.CBC.class.getName());
        provider.put("Cipher.1.2.840.113549.1.9.16.3.6", DESede.Wrap.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.2", AES.CBC.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.3", AES.OFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.4", AES.CFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.6", AES.GCM.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.7", AES.CCM.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.22", AES.CBC.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.23", AES.OFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.24", AES.CFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.26", AES.GCM.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.27", AES.CCM.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.42", AES.CBC.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.43", AES.OFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.44", AES.CFB.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.46", AES.GCM.class.getName());
        provider.put("Cipher.2.16.840.1.101.3.4.1.47", AES.CCM.class.getName());
        provider.put("Cipher.AESWRAP", "SupportedKeyClasses: javax.crypto.SecretKey");
        provider.put("Cipher.AESWRAP", "SupportedKeyFormats: RAW");
        provider.put("Cipher.AESWRAP", AES.Wrap.class.getName());
        provider.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.1.5", "AESWRAP");
        provider.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.1.25", "AESWRAP");
        provider.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.1.45", "AESWRAP");
    }

    protected OCFECDHKeyAgreementSpi(String kaAlgorithm, BasicAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithmValue = kaAlgorithm;
        this.agreement = agreement;
    }

    protected OCFECDHKeyAgreementSpi(String kaAlgorithm, ECDHCUnifiedAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithmValue = kaAlgorithm;
        this.agreement = agreement;
    }

    protected byte[] bigIntToBytes(BigInteger r) {
        return converter.integerToBytes(r, converter.getByteLength(this.parameters.getCurve()));
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        AsymmetricKeyParameter pubKey;
        ECPublicKeyParameters staticKey;
        if (this.ocfkey == null && !(key instanceof OCFPrivateKey) && this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithmValue + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithmValue + " can only be between two parties.");
        }
        if (this.agreement instanceof ECMQVBasicAgreement) {
            if (!(key instanceof MQVPublicKey)) {
                staticKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter((PublicKey)key);
                ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(this.mqvParameters.getOtherPartyEphemeralKey());
                pubKey = new MQVPublicParameters(staticKey, ephemKey);
            } else {
                MQVPublicKey mqvPubKey = (MQVPublicKey)key;
                ECPublicKeyParameters staticKey2 = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mqvPubKey.getStaticKey());
                ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mqvPubKey.getEphemeralKey());
                pubKey = new MQVPublicParameters(staticKey2, ephemKey);
            }
        } else if (this.agreement instanceof ECDHCUnifiedAgreement) {
            staticKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter((PublicKey)key);
            ECPublicKeyParameters ephemKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(this.dheParameters.getOtherPartyEphemeralKey());
            pubKey = new ECDHUPublicParameters(staticKey, ephemKey);
        } else {
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException(this.kaAlgorithmValue + " key agreement requires " + OCFECDHKeyAgreementSpi.getSimpleName(ECPublicKey.class) + " for doPhase");
            }
            pubKey = ECUtils.generatePublicKeyParameter((PublicKey)key);
        }
        try {
            if (this.agreement instanceof BasicAgreement) {
                this.result = this.bigIntToBytes(((BasicAgreement)this.agreement).calculateAgreement((CipherParameters)pubKey));
            } else if (this.ocfkey != null && this.agreement instanceof KeyAgreement) {
                KeyAgreement kagreement = (KeyAgreement)this.agreement;
                kagreement.doPhase((PublicKey)key, true);
                this.result = kagreement.generateSecret();
            } else {
                this.result = ((ECDHCUnifiedAgreement)this.agreement).calculateAgreement((CipherParameters)pubKey);
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("calculation failed: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        return null;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(params == null || params instanceof MQVParameterSpec || params instanceof UserKeyingMaterialSpec || params instanceof DHUParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, params);
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.initFromKey(key, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private void initFromKey(Key key, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.agreement instanceof ECMQVBasicAgreement) {
            ECPublicKeyParameters ephemPubKey;
            ECPrivateKeyParameters ephemPrivKey;
            ECPrivateKeyParameters staticPrivKey;
            this.mqvParameters = null;
            if (!(key instanceof MQVPrivateKey) && !(parameterSpec instanceof MQVParameterSpec)) {
                throw new InvalidAlgorithmParameterException(this.kaAlgorithmValue + " key agreement requires " + OCFECDHKeyAgreementSpi.getSimpleName(MQVParameterSpec.class) + " for initialisation");
            }
            if (key instanceof MQVPrivateKey) {
                MQVPrivateKey mqvPrivKey = (MQVPrivateKey)key;
                staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)mqvPrivKey.getStaticPrivateKey());
                ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)mqvPrivKey.getEphemeralPrivateKey());
                ephemPubKey = null;
                if (mqvPrivKey.getEphemeralPublicKey() != null) {
                    ephemPubKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mqvPrivKey.getEphemeralPublicKey());
                }
            } else {
                MQVParameterSpec mqvParameterSpec = (MQVParameterSpec)parameterSpec;
                staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
                ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)mqvParameterSpec.getEphemeralPrivateKey());
                ephemPubKey = null;
                if (mqvParameterSpec.getEphemeralPublicKey() != null) {
                    ephemPubKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(mqvParameterSpec.getEphemeralPublicKey());
                }
                this.mqvParameters = mqvParameterSpec;
                this.ukmParameters = mqvParameterSpec.getUserKeyingMaterial();
            }
            MQVPrivateParameters localParams = new MQVPrivateParameters(staticPrivKey, ephemPrivKey, ephemPubKey);
            this.parameters = staticPrivKey.getParameters();
            ((ECMQVBasicAgreement)this.agreement).init((CipherParameters)localParams);
        } else if (parameterSpec instanceof DHUParameterSpec) {
            if (!(this.agreement instanceof ECDHCUnifiedAgreement)) {
                throw new InvalidAlgorithmParameterException(this.kaAlgorithmValue + " key agreement cannot be used with " + OCFECDHKeyAgreementSpi.getSimpleName(DHUParameterSpec.class));
            }
            DHUParameterSpec dheParameterSpec = (DHUParameterSpec)parameterSpec;
            ECPrivateKeyParameters staticPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
            ECPrivateKeyParameters ephemPrivKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)dheParameterSpec.getEphemeralPrivateKey());
            ECPublicKeyParameters ephemPubKey = null;
            if (dheParameterSpec.getEphemeralPublicKey() != null) {
                ephemPubKey = (ECPublicKeyParameters)ECUtils.generatePublicKeyParameter(dheParameterSpec.getEphemeralPublicKey());
            }
            this.dheParameters = dheParameterSpec;
            this.ukmParameters = dheParameterSpec.getUserKeyingMaterial();
            ECDHUPrivateParameters localParams = new ECDHUPrivateParameters(staticPrivKey, ephemPrivKey, ephemPubKey);
            this.parameters = staticPrivKey.getParameters();
            ((ECDHCUnifiedAgreement)this.agreement).init((CipherParameters)localParams);
        } else {
            if (!(key instanceof PrivateKey)) {
                throw new InvalidKeyException(this.kaAlgorithmValue + " key agreement requires " + OCFECDHKeyAgreementSpi.getSimpleName(ECPrivateKey.class) + " for initialisation");
            }
            if (this.kdf == null && parameterSpec instanceof UserKeyingMaterialSpec) {
                throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
            }
            if (key instanceof OCFPrivateKey) {
                try {
                    this.ocfkey = (OCFPrivateKey)key;
                    this.agreement = KeyAgreement.getInstance("ECDH", "OCF");
                    ((KeyAgreement)this.agreement).init(key);
                    this.ukmParameters = parameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)parameterSpec).getUserKeyingMaterial() : null;
                    return;
                }
                catch (Exception e) {
                    new InvalidKeyException(e);
                }
            }
            ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
            this.parameters = privKey.getParameters();
            this.ukmParameters = parameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)parameterSpec).getUserKeyingMaterial() : null;
            ((BasicAgreement)this.agreement).init((CipherParameters)privKey);
        }
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    protected void doInitFromKey(Key key, AlgorithmParameterSpec parameterSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initFromKey(key, parameterSpec);
    }

    protected byte[] doCalcSecret() {
        return Arrays.clone((byte[])this.result);
    }

    public static class ECKAEGwithSHA512KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithSHA512KDF() {
            super("ECKAEGwithSHA512KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class ECKAEGwithSHA384KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithSHA384KDF() {
            super("ECKAEGwithSHA384KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class ECKAEGwithSHA256KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithSHA256KDF() {
            super("ECKAEGwithSHA256KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class ECKAEGwithSHA224KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithSHA224KDF() {
            super("ECKAEGwithSHA224KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class ECKAEGwithRIPEMD160KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithRIPEMD160KDF() {
            super("ECKAEGwithRIPEMD160KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator((Digest)new RIPEMD160Digest()));
        }
    }

    public static class ECKAEGwithSHA1KDF
    extends OCFECDHKeyAgreementSpi {
        public ECKAEGwithSHA1KDF() {
            super("ECKAEGwithSHA1KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHUwithSHA512KDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA512KDF() {
            super("ECCDHUwithSHA512KDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHUwithSHA384KDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA384KDF() {
            super("ECCDHUwithSHA384KDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHUwithSHA256KDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA256KDF() {
            super("ECCDHUwithSHA256KDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHUwithSHA224KDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA224KDF() {
            super("ECCDHUwithSHA224KDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHUwithSHA1KDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA1KDF() {
            super("ECCDHUwithSHA1KDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHUwithSHA512CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA512CKDF() {
            super("ECCDHUwithSHA512CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHUwithSHA384CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA384CKDF() {
            super("ECCDHUwithSHA384CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHUwithSHA256CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA256CKDF() {
            super("ECCDHUwithSHA256CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHUwithSHA224CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA224CKDF() {
            super("ECCDHUwithSHA224CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHUwithSHA1CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHUwithSHA1CKDF() {
            super("ECCDHUwithSHA1CKDF", new ECDHCUnifiedAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class MQVwithSHA512KDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA512KDF() {
            super("ECMQVwithSHA512KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class MQVwithSHA384KDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA384KDF() {
            super("ECMQVwithSHA384KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class MQVwithSHA256KDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA256KDF() {
            super("ECMQVwithSHA256KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class MQVwithSHA224KDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA224KDF() {
            super("ECMQVwithSHA224KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class MQVwithSHA1KDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA1KDF() {
            super("ECMQVwithSHA1KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class MQVwithSHA512CKDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA512CKDF() {
            super("ECMQVwithSHA512CKDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class MQVwithSHA384CKDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA384CKDF() {
            super("ECMQVwithSHA384CKDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class MQVwithSHA256CKDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA256CKDF() {
            super("ECMQVwithSHA256CKDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class MQVwithSHA224CKDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA224CKDF() {
            super("ECMQVwithSHA224CKDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class MQVwithSHA1CKDF
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA1CKDF() {
            super("ECMQVwithSHA1CKDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA512CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA512CKDF() {
            super("ECDHwithSHA512CKDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHwithSHA384CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA384CKDF() {
            super("ECDHwithSHA384CKDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHwithSHA256CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA256CKDF() {
            super("ECDHwithSHA256CKDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHwithSHA1CKDF
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA1CKDF() {
            super("ECDHwithSHA1CKDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new ConcatenationKDFGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class MQVwithSHA512KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA512KDFAndSharedInfo() {
            super("ECMQVwithSHA512KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class MQVwithSHA384KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA384KDFAndSharedInfo() {
            super("ECMQVwithSHA384KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class MQVwithSHA256KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA256KDFAndSharedInfo() {
            super("ECMQVwithSHA256KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class MQVwithSHA224KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA224KDFAndSharedInfo() {
            super("ECMQVwithSHA224KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class MQVwithSHA1KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public MQVwithSHA1KDFAndSharedInfo() {
            super("ECMQVwithSHA1KDF", (BasicAgreement)new ECMQVBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class CDHwithSHA512KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public CDHwithSHA512KDFAndSharedInfo() {
            super("ECCDHwithSHA512KDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class DHwithSHA512KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA512KDFAndSharedInfo() {
            super("ECDHwithSHA512KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA512()));
        }
    }

    public static class CDHwithSHA384KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public CDHwithSHA384KDFAndSharedInfo() {
            super("ECCDHwithSHA384KDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class DHwithSHA384KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA384KDFAndSharedInfo() {
            super("ECDHwithSHA384KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA384()));
        }
    }

    public static class CDHwithSHA256KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public CDHwithSHA256KDFAndSharedInfo() {
            super("ECCDHwithSHA256KDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class DHwithSHA256KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA256KDFAndSharedInfo() {
            super("ECDHwithSHA256KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA256()));
        }
    }

    public static class CDHwithSHA224KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public CDHwithSHA224KDFAndSharedInfo() {
            super("ECCDHwithSHA224KDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class DHwithSHA224KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA224KDFAndSharedInfo() {
            super("ECDHwithSHA224KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA224()));
        }
    }

    public static class CDHwithSHA1KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public CDHwithSHA1KDFAndSharedInfo() {
            super("ECCDHwithSHA1KDF", (BasicAgreement)new ECDHCBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA1KDFAndSharedInfo
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA1KDFAndSharedInfo() {
            super("ECDHwithSHA1KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHwithSHA1KDF
    extends OCFECDHKeyAgreementSpi {
        public DHwithSHA1KDF() {
            super("ECDHwithSHA1KDF", (BasicAgreement)new ECDHBasicAgreement(), (DerivationFunction)new KDF2BytesGenerator(DigestFactory.createSHA1()));
        }
    }

    public static class DHUC
    extends OCFECDHKeyAgreementSpi {
        public DHUC() {
            super("ECCDHU", new ECDHCUnifiedAgreement(), null);
        }
    }

    public static class MQV
    extends OCFECDHKeyAgreementSpi {
        public MQV() {
            super("ECMQV", (BasicAgreement)new ECMQVBasicAgreement(), null);
        }
    }

    public static class DHC
    extends OCFECDHKeyAgreementSpi {
        public DHC() {
            super("ECDHC", (BasicAgreement)new ECDHCBasicAgreement(), null);
        }
    }

    public static class DH
    extends OCFECDHKeyAgreementSpi {
        public DH() {
            super("ECDH", (BasicAgreement)new ECDHBasicAgreement(), null);
        }
    }
}

