/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.ECPublicKey;

public final class EcTempKeyPairGenerator {
    private EcTempKeyPairGenerator() {
    }

    public static KeyPair generateKeyPair(Certificate templateCertificate) throws IllegalArgumentException, InvalidAlgorithmParameterException {
        return EcTempKeyPairGenerator.generateKeyPair(templateCertificate, null);
    }

    public static KeyPair generateKeyPair(Certificate templateCertificate, String provider) throws IllegalArgumentException, IllegalStateException, InvalidAlgorithmParameterException {
        PublicKey publicKey;
        if (templateCertificate == null) {
            // empty if block
        }
        if ((publicKey = templateCertificate.getPublicKey()) instanceof ECPublicKey) {
            return EcTempKeyPairGenerator.generateKeyPair((ECPublicKey)publicKey, provider);
        }
        throw new IllegalArgumentException("only ECPublicKey supported by this generator");
    }

    public static KeyPair generateKeyPair(PublicKey templateKey) throws IllegalArgumentException, InvalidAlgorithmParameterException {
        return EcTempKeyPairGenerator.generateKeyPair(templateKey, null);
    }

    public static KeyPair generateKeyPair(PublicKey templateKey, String provider) throws IllegalArgumentException, IllegalStateException, InvalidAlgorithmParameterException {
        if (templateKey instanceof ECPublicKey) {
            return EcTempKeyPairGenerator.generateKeyPair((ECPublicKey)templateKey, provider);
        }
        throw new IllegalArgumentException("only ECPublicKey supported by this generator");
    }

    public static KeyPair generateKeyPair(ECPublicKey templateKey) throws IllegalArgumentException, InvalidAlgorithmParameterException {
        return EcTempKeyPairGenerator.generateKeyPair(templateKey, null);
    }

    public static KeyPair generateKeyPair(ECPublicKey templateKey, String provider) throws IllegalArgumentException, IllegalStateException, InvalidAlgorithmParameterException {
        if (templateKey == null) {
            throw new IllegalArgumentException("ECPublicKey can not be null");
        }
        KeyPairGenerator kpg = null;
        try {
            kpg = provider == null || provider.isEmpty() ? KeyPairGenerator.getInstance(templateKey.getAlgorithm()) : KeyPairGenerator.getInstance(templateKey.getAlgorithm(), provider);
        }
        catch (NoSuchAlgorithmException e) {
            if (provider == null || provider.isEmpty()) {
                throw new IllegalStateException("EC key pair generation not supported by default provider");
            }
            throw new IllegalStateException("EC key pair generation not supported by provider '" + provider + "'");
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException("provider '" + provider + "' not registered");
        }
        kpg.initialize(templateKey.getParams());
        return kpg.generateKeyPair();
    }
}

