/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.provider.JCEECPrivateKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;

public class ECUtils {
    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        return ECUtil.generatePublicKeyParameter((PublicKey)key);
    }

    static X9ECParameters getDomainParametersFromGenSpec(ECGenParameterSpec genSpec) {
        return ECUtils.getDomainParametersFromName(genSpec.getName());
    }

    static X9ECParameters getDomainParametersFromName(String curveName) {
        X9ECParameters domainParameters;
        try {
            if (curveName.charAt(0) >= '0' && curveName.charAt(0) <= '2') {
                ASN1ObjectIdentifier oidID = new ASN1ObjectIdentifier(curveName);
                domainParameters = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)oidID);
            } else if (curveName.indexOf(32) > 0) {
                curveName = curveName.substring(curveName.indexOf(32) + 1);
                domainParameters = ECUtil.getNamedCurveByName((String)curveName);
            } else {
                domainParameters = ECUtil.getNamedCurveByName((String)curveName);
            }
        }
        catch (IllegalArgumentException ex) {
            domainParameters = ECUtil.getNamedCurveByName((String)curveName);
        }
        return domainParameters;
    }

    static X962Parameters getDomainParametersFromName(ECParameterSpec ecSpec, boolean withCompression) {
        X962Parameters params;
        if (ecSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)ecSpec).getName());
            if (curveOid == null) {
                curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)ecSpec).getName());
            }
            params = new X962Parameters(curveOid);
        } else if (ecSpec == null) {
            params = new X962Parameters((ASN1Null)DERNull.INSTANCE);
        } else {
            ECCurve curve = EC5Util.convertCurve((EllipticCurve)ecSpec.getCurve());
            X9ECParameters ecP = new X9ECParameters(curve, new X9ECPoint(EC5Util.convertPoint((ECCurve)curve, (ECPoint)ecSpec.getGenerator()), withCompression), ecSpec.getOrder(), BigInteger.valueOf(ecSpec.getCofactor()), ecSpec.getCurve().getSeed());
            params = new X962Parameters(ecP);
        }
        return params;
    }

    public static KeyPair adjustKeyPair(KeyPair keyPair) {
        return new KeyPair((PublicKey)ECUtils.publicKey2JCEECPublicKey(keyPair.getPublic()), (PrivateKey)ECUtils.privateKey2JCEECPrivateKey(keyPair.getPrivate()));
    }

    public static JCEECPublicKey publicKey2JCEECPublicKey(PublicKey pubKey) {
        if (pubKey == null) {
            throw new IllegalArgumentException("public key null not permitted");
        }
        JCEECPublicKey result = null;
        if (pubKey instanceof JCEECPublicKey) {
            result = (JCEECPublicKey)pubKey;
        } else if (pubKey instanceof ECPublicKey) {
            result = new JCEECPublicKey((ECPublicKey)pubKey);
        } else {
            throw new IllegalArgumentException("not supported public key: " + pubKey.getClass());
        }
        return result;
    }

    public static JCEECPrivateKey privateKey2JCEECPrivateKey(PrivateKey privKey) {
        if (privKey == null) {
            throw new IllegalArgumentException("private key null not permitted");
        }
        JCEECPrivateKey result = null;
        if (privKey instanceof JCEECPrivateKey) {
            result = (JCEECPrivateKey)privKey;
        } else if (privKey instanceof ECPrivateKey) {
            result = new JCEECPrivateKey((ECPrivateKey)privKey);
        } else {
            throw new IllegalArgumentException("not supported private key: " + privKey.getClass());
        }
        return result;
    }
}

