/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.eccipher.KeyDerivationParameters;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class ECCipherParameterSpec
implements AlgorithmParameterSpec {
    public static final String KDF_CONCAT = "ConcatKDF";
    private ECPublicKey senderPublicKey = null;
    private String keyDerivationAlgorithm = null;
    private KeyDerivationParameters keyDerivationParameters = null;
    private int keyEncryptionKeySize = 0;
    private String keyWrapAlgorithm = null;
    private byte[] wrappedDataKey = null;
    private String dataCipherAlgorithm = null;

    public ECCipherParameterSpec(ECPublicKey senderPublicKey, String keyDerivationAlgorithm, KeyDerivationParameters keyDerivationParameters, int keyEncryptionKeySize, String keyWrapAlgorithm, byte[] wrappedDataKey, String dataCipherAlgorithm) throws IllegalArgumentException {
        AssertUtil.notNull(senderPublicKey, "public key of sender");
        AssertUtil.notNullOrEmpty(keyDerivationAlgorithm, "key derivation algorithm");
        if (keyDerivationAlgorithm != KDF_CONCAT) {
            throw new IllegalArgumentException("only ConcatKDF supported as key derivation algorithm");
        }
        AssertUtil.notNull(keyDerivationParameters, "key derivation parameters");
        AssertUtil.greater(keyEncryptionKeySize, 0, "key encryption key size");
        AssertUtil.notNullOrEmpty(keyWrapAlgorithm, "key wrap algorithm");
        AssertUtil.notNullOrEmpty(wrappedDataKey, "wrapped data key");
        AssertUtil.notNullOrEmpty(dataCipherAlgorithm, "data cipher algorithm");
        this.senderPublicKey = senderPublicKey;
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
        this.keyDerivationParameters = keyDerivationParameters;
        this.keyEncryptionKeySize = keyEncryptionKeySize;
        this.keyWrapAlgorithm = keyWrapAlgorithm;
        this.wrappedDataKey = wrappedDataKey;
        this.dataCipherAlgorithm = dataCipherAlgorithm;
    }

    public ECPublicKey getSenderPublicKey() {
        return this.senderPublicKey;
    }

    public String getKeyDerivationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public KeyDerivationParameters getKeyDerivationParameters() {
        return this.keyDerivationParameters;
    }

    public int getKeyEncryptionKeySize() {
        return this.keyEncryptionKeySize;
    }

    public String getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    public byte[] getWrappedDataKey() {
        return this.wrappedDataKey;
    }

    public String getDataCipherAlgorithm() {
        return this.dataCipherAlgorithm;
    }
}

