/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.gov2.jca_provider.CipherNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.CipherOperationCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTooLongException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputTooShortException;
import de.bos_bremen.gov2.jca_provider.CipherResponseCodeException;
import de.bos_bremen.gov2.jca_provider.CipherRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.CipherWrongPINException;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.eccipher.ConcatKDF;
import de.bos_bremen.gov2.jca_provider.eccipher.ConcatKDFParameters;
import de.bos_bremen.gov2.jca_provider.eccipher.ECCipherParameterSpec;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.base.HPCHBAG2Card;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.JCEECPublicKey;

public class ECCipher
extends CipherSpi {
    private final ECCipherEngine engine = new ECCipherEngine(true);

    @Override
    protected void engineInit(int mode, Key privateKey, AlgorithmParameterSpec parameterSpec, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalArgumentException {
        this.engine.engineInit(mode, privateKey, parameterSpec, sr);
    }

    @Override
    protected void engineInit(int mode, Key privateKey, AlgorithmParameters parameters, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engine.engineInit(mode, privateKey, parameters, sr);
    }

    @Override
    protected void engineInit(int mode, Key privateKey, SecureRandom sr) throws InvalidKeyException {
        this.engine.engineInit(mode, privateKey, sr);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int offset, int length) throws IllegalArgumentException {
        return this.engine.engineUpdate(input, offset, length);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalArgumentException {
        return this.engine.engineUpdate(input, inputOffset, inputLength, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int offset, int length) throws IllegalBlockSizeException, BadPaddingException, IllegalArgumentException, IllegalStateException {
        return this.engine.engineDoFinal(input, offset, length);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, IllegalArgumentException {
        return this.engine.engineDoFinal(input, inputOffset, inputLength, output, outputOffset);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.engine.engineGetParameters();
    }

    @Override
    protected int engineGetBlockSize() {
        return this.engine.engineGetBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        return this.engine.engineGetIV();
    }

    @Override
    protected int engineGetOutputSize(int arg0) {
        return this.engine.engineGetOutputSize(arg0);
    }

    @Override
    protected void engineSetMode(String arg0) throws NoSuchAlgorithmException {
        this.engine.engineSetMode(arg0);
    }

    @Override
    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
        this.engine.engineSetPadding(arg0);
    }

    public static class ECCipherEngine {
        private OCFPrivateKey privateKey = null;
        private ECCipherParameterSpec paramSpec = null;
        private ByteArrayOutputStream cipheredBytes = null;
        private final boolean secure;

        public ECCipherEngine(boolean secure) {
            this.secure = secure;
        }

        public void engineInit(int mode, Key privateKey, AlgorithmParameterSpec parameterSpec, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException, IllegalArgumentException {
            if (mode != 2) {
                throw new IllegalArgumentException("only decrypting supported");
            }
            AssertUtil.notNull(privateKey, "private key");
            if (!(privateKey instanceof OCFPrivateKey)) {
                throw new InvalidKeyException("only OCFPrivateKey accepted");
            }
            this.privateKey = (OCFPrivateKey)privateKey;
            AssertUtil.notNull(parameterSpec, "parameters");
            if (!(parameterSpec instanceof ECCipherParameterSpec)) {
                throw new InvalidAlgorithmParameterException("only ECCipherParameterSpec accepted");
            }
            this.paramSpec = (ECCipherParameterSpec)parameterSpec;
            this.cipheredBytes = new ByteArrayOutputStream();
        }

        public void engineInit(int mode, Key privateKey, AlgorithmParameters parameters, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
            try {
                ECCipherParameterSpec spec = parameters.getParameterSpec(ECCipherParameterSpec.class);
                this.engineInit(mode, privateKey, spec, sr);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
        }

        public void engineInit(int mode, Key privateKey, SecureRandom sr) throws InvalidKeyException {
            throw new UnsupportedOperationException("can only process init with AlgorithmParameterSpec");
        }

        public byte[] engineUpdate(byte[] input, int offset, int length) throws IllegalArgumentException {
            if (this.cipheredBytes == null) {
                throw new IllegalArgumentException("not initialized yet!");
            }
            if (input != null) {
                this.cipheredBytes.write(input, offset, length);
            }
            return null;
        }

        public int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalArgumentException {
            this.engineUpdate(input, inputOffset, inputLength);
            return 0;
        }

        public byte[] engineDoFinal(byte[] input, int offset, int length) throws IllegalBlockSizeException, BadPaddingException, IllegalArgumentException, IllegalStateException {
            this.engineUpdate(input, offset, length);
            if (this.paramSpec == null) {
                throw new IllegalStateException("not initialized yet!");
            }
            if (this.privateKey.getCardService() instanceof HPCHBAG2Card) {
                throw new UnsupportedOperationException("HPC/HBA decryption not supported currently");
            }
            try {
                byte[] kekMaterial = null;
                byte[] sharedSecret = null;
                if (this.paramSpec.getKeyDerivationAlgorithm() == "ConcatKDF") {
                    ConcatKDFParameters kdfParams = (ConcatKDFParameters)this.paramSpec.getKeyDerivationParameters();
                    ConcatKDF kdf = new ConcatKDF(kdfParams.getDigestAlgorithm());
                    sharedSecret = ECCipherEngine.generateSharedSecretECDH(this.privateKey, this.paramSpec.getSenderPublicKey(), this.secure);
                    kekMaterial = kdf.kdf(sharedSecret, this.paramSpec.getKeyEncryptionKeySize(), kdfParams.getOtherInfo());
                }
                SecretKeySpec kek = new SecretKeySpec(kekMaterial, this.paramSpec.getKeyWrapAlgorithm());
                Cipher wrapCipher = Cipher.getInstance(this.paramSpec.getKeyWrapAlgorithm());
                wrapCipher.init(4, kek);
                Key dataKey = wrapCipher.unwrap(this.paramSpec.getWrappedDataKey(), this.paramSpec.getDataCipherAlgorithm(), 3);
                Cipher dataCipher = Cipher.getInstance(this.paramSpec.getDataCipherAlgorithm());
                dataCipher.init(2, dataKey);
                return dataCipher.doFinal(this.cipheredBytes.toByteArray());
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException("cipher cannot work with given parameters");
            }
        }

        public static byte[] generateSharedSecretECDH(OCFPrivateKey cardPrivateKey, ECPublicKey senderPublicKey, boolean secure) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, CipherWrongPINException, CipherRetryCounterExpiredException, CipherNotYetInitializedException, CipherOperationCancelledException, CipherResponseCodeException {
            byte[] sharedSecret = null;
            try {
                KeyAgreement ka = KeyAgreement.getInstance("ECDH", "OCF");
                ka.init(cardPrivateKey);
                ka.doPhase(senderPublicKey, true);
                sharedSecret = ka.generateSecret();
            }
            catch (NoSuchProviderException e) {
                if (secure) {
                    throw e;
                }
                OCFPrivateKey ocfKey = cardPrivateKey;
                GovCS gcs = ocfKey.getCardService();
                byte[] keyBytes = new JCEECPublicKey(senderPublicKey).getQ().getEncoded(false);
                AlgorithmParameters algorithmParameters = null;
                try {
                    algorithmParameters = AlgorithmParameters.getInstance("OCFSIGN", "OCF");
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    // empty catch block
                }
                GovCS.ResultObject ro = null;
                try {
                    ro = gcs.decrypt(ocfKey.getOCFCertificatInfo(), keyBytes, null, algorithmParameters);
                }
                catch (PinInputCancelledException e1) {
                    throw new CipherPINInputCancelledException(e1);
                }
                catch (PinInputTooShortException e1) {
                    throw new CipherPINInputTooShortException(e1);
                }
                catch (PinInputTooLongException e1) {
                    throw new CipherPINInputTooLongException(e1);
                }
                catch (PinInputTimeoutException e1) {
                    throw new CipherPINInputTimeoutException(e1);
                }
                catch (WrongPinException e1) {
                    throw new CipherWrongPINException(e1);
                }
                catch (RetryCounterExpiredException e1) {
                    throw new CipherRetryCounterExpiredException(e1);
                }
                catch (NotYetInitializedException e1) {
                    throw new CipherNotYetInitializedException(e1);
                }
                catch (OperationCancelledException e1) {
                    throw new CipherOperationCancelledException(e1);
                }
                catch (ResponseCodeException e1) {
                    throw new CipherResponseCodeException(e1);
                }
                if (ro.getResultCode() == 36864 && byte[].class.isInstance(ro.getResultData())) {
                    sharedSecret = (byte[])ro.getResultData();
                }
                throw new IllegalArgumentException("cipher cannot work with given parameters");
            }
            return sharedSecret;
        }

        public int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException, IllegalArgumentException {
            byte[] result = this.engineDoFinal(input, inputOffset, inputLength);
            try {
                ByteUtil.replace(output, result, outputOffset);
            }
            catch (IllegalArgumentException e) {
                throw (ShortBufferException)new ShortBufferException().initCause(e);
            }
            return result.length;
        }

        public AlgorithmParameters engineGetParameters() {
            throw new UnsupportedOperationException();
        }

        public int engineGetBlockSize() {
            throw new UnsupportedOperationException();
        }

        public byte[] engineGetIV() {
            throw new UnsupportedOperationException();
        }

        public int engineGetOutputSize(int arg0) {
            throw new UnsupportedOperationException();
        }

        public void engineSetMode(String arg0) throws NoSuchAlgorithmException {
            throw new UnsupportedOperationException();
        }

        public void engineSetPadding(String arg0) throws NoSuchPaddingException {
            throw new UnsupportedOperationException();
        }
    }
}

