/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider.eccipher;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.eccipher.KeyDerivationFunction;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ConcatKDF
implements KeyDerivationFunction {
    private MessageDigest digest = null;

    public ConcatKDF(String digestAlg) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(digestAlg);
    }

    public byte[] kdf(byte[] seed, long requestedLength, byte[] otherInfo) throws IllegalArgumentException {
        AssertUtil.notNull(seed, "seed");
        AssertUtil.greater(requestedLength, 0L, "requested output length");
        long iterations = requestedLength / (long)(this.digest.getDigestLength() * 8);
        if (iterations == 0L) {
            ++iterations;
        }
        if (iterations > (long)(Math.pow(2.0, 32.0) - 1.0)) {
            throw new IllegalArgumentException("requested output length exceeds maximum of " + (double)(this.digest.getDigestLength() * 8) * (Math.pow(2.0, 32.0) - 1.0));
        }
        long remainingBits = requestedLength % (long)(this.digest.getDigestLength() * 8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] cnt = new byte[4];
        cnt[3] = 1;
        for (long i = 0L; i < iterations; ++i) {
            this.digest.update(cnt);
            this.digest.update(seed);
            if (otherInfo != null) {
                this.digest.update(otherInfo);
            }
            byte[] dRes = this.digest.digest();
            ConcatKDF.increaseCounter(cnt);
            if (i != iterations - 1L || remainingBits == 0L) {
                baos.write(dRes, 0, dRes.length);
                continue;
            }
            if (remainingBits % 8L == 0L) {
                baos.write(dRes, 0, (int)remainingBits / 8);
                continue;
            }
            int n = (int)(remainingBits / 8L);
            dRes[n] = (byte)(dRes[n] & -1 << (int)(8L - remainingBits % 8L));
            baos.write(dRes, 0, 1 + (int)remainingBits / 8);
        }
        return baos.toByteArray();
    }

    private static void increaseCounter(byte[] counter) throws IllegalArgumentException {
        int i;
        AssertUtil.notNullOrEmpty(counter, "counter");
        int n = i = counter.length - 1;
        counter[n] = (byte)(counter[n] + 1);
        while (counter[i] == 0 && i > 0) {
            int n2 = i - 1;
            counter[n2] = (byte)(counter[n2] + 1);
            --i;
        }
    }
}

