/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SingleDebugListener
implements CardListener,
CTListener,
OCFKeyStoreListener,
ProgressSessionListener,
ReloadListener {
    private static final String VALUE_SEPARATOR = " - ";
    private static final Log LOG = LogFactory.getLog(SingleDebugListener.class);
    private static final String UNKOWMN_TERMINAL = "unkowmn terminal";
    private final String name;

    public SingleDebugListener(String name) {
        this.name = name;
    }

    @Override
    public void aliasAdded(String alias) {
        this.logOCFKeyStoreListener("aliasAdded", alias, true);
    }

    @Override
    public void aliasRemoved(String alias) {
        this.logOCFKeyStoreListener("aliasRemoved", alias, false);
    }

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.logCTListener("cardInserted", ctEvent, true);
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.logCTListener("cardRemoved", ctEvent, false);
    }

    private void log(Class<?> listenerClass, String methodName, Class<?> valueClass, String message, Boolean inserted) {
        Object additionalMessage = "";
        if (inserted != null) {
            additionalMessage = VALUE_SEPARATOR + (inserted != false ? "inserted" : "removed");
        }
        LOG.info((Object)(this.name + VALUE_SEPARATOR + listenerClass.getSimpleName() + "." + methodName + " - value: " + valueClass.getSimpleName() + VALUE_SEPARATOR + message + (String)additionalMessage));
    }

    private void logCTListener(String methodName, CardTerminalEvent ctEvent, boolean inserted) {
        try {
            String terminalName = ctEvent == null ? UNKOWMN_TERMINAL : ctEvent.getCardTerminal().getName();
            this.log(CTListener.class, methodName, CardTerminalEvent.class, terminalName, inserted);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void logOCFKeyStoreListener(String methodName, String alias, boolean inserted) {
        this.log(OCFKeyStoreListener.class, methodName, String.class, alias, inserted);
    }

    private void logProgresssionSessionListener(String methodName, ProgressSession session) {
        try {
            String message = session.getID() + VALUE_SEPARATOR + session.getCurrentStep() + " of " + session.getStepCount() + VALUE_SEPARATOR + session.getMessageKey() + VALUE_SEPARATOR + session.getMessage() + VALUE_SEPARATOR + session.getProgressMessage();
            this.log(ProgressSessionListener.class, methodName, ProgressSession.class, message, null);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void processEvent(CardEvent event) {
        try {
            String terminalName;
            String string = terminalName = event == null ? UNKOWMN_TERMINAL : event.getCard().getCardTerminal().getName();
            boolean inserted = event == null ? null : Boolean.valueOf(event.getType() == 0);
            this.log(CardListener.class, "processEvent", CardEvent.class, terminalName, inserted);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void progressSessionStarted(ProgressSession session) {
        this.logProgresssionSessionListener("progressSessionStarted", session);
    }

    @Override
    public void progressSessionStopped(ProgressSession session) {
        this.logProgresssionSessionListener("progressSessionStopped", session);
    }

    @Override
    public void progressSessionUpdate(ProgressSession session) {
        this.logProgresssionSessionListener("progressSessionUpdate", session);
    }

    @Override
    public void progressSessionWillStart(ProgressSession session) {
        this.logProgresssionSessionListener("progressSessionWillStart", session);
    }

    @Override
    public void progressSessionWillStop(ProgressSession session) {
        this.logProgresssionSessionListener("progressSessionWillStop", session);
    }

    @Override
    public void keyStoreCleanedUp() {
        this.log(ReloadListener.class, "keyStoreCleanedUp", Void.class, "", null);
    }
}

