/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.common.asn1.ASN1;
import de.bos_bremen.common.asn1.OID;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SimpleSignatureLevel {
    public static final String COUNTRY_DE = "DE";
    public static final String DN_COUNTRY_PART = "C";
    public static final String DN_SEPARATOR_PAIR2 = ",";
    public static final String DN_SEPARATOR_PAIR1 = ", ";
    public static final List<String> DN_SEPARATOR_PAIRS = Collections.unmodifiableList(Arrays.asList(", ", ","));
    public static final String DN_SEPARATOR_VALUE = "=";
    private static final Log LOG = LogFactory.getLog(SimpleSignatureLevel.class);
    public static final String OID_STRING_CERTIFICATE_EXTENSION_QC_COMPLIANCE = "0.4.0.1862.1.1";
    public static final String OID_STRING_CERTIFICATE_EXTENSION_QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    public static final int KEY_USAGE_FLAG_INDEX_1_NON_REPUDIATION = 1;
    public static final int KEY_USAGE_FLAG_INDEX_0_DIGITAL_SIGNATURE = 0;

    private SimpleSignatureLevel() {
    }

    public static boolean isQESSignatureAlias(KeyStore keyStore, String alias) throws KeyStoreException {
        return SimpleSignatureLevel.isQESSignatureAlias(keyStore, alias, QESKeyDetectionMode.DEFAULT);
    }

    public static boolean isQESSignatureAlias(KeyStore keyStore, String alias, QESKeyDetectionMode mode) throws KeyStoreException {
        LOG.debug((Object)("null keystore: " + keyStore == null ? 1 : 0));
        LOG.debug((Object)("null alias: " + alias == null ? 1 : 0));
        LOG.debug((Object)("empty alias: " + "".equals(alias)));
        if (keyStore == null || alias == null || "".equals(alias)) {
            return false;
        }
        Certificate cert = keyStore.getCertificate(alias);
        if (!keyStore.isKeyEntry(alias) || cert == null) {
            return false;
        }
        OCFPrivateKey ocfPrivateKey = null;
        try {
            ocfPrivateKey = (OCFPrivateKey)keyStore.getKey(alias, null);
        }
        catch (GeneralSecurityException e) {
            LOG.error((Object)("cannot retrieve key from keystore for alias: " + alias), (Throwable)e);
            return false;
        }
        if (ocfPrivateKey == null || OCFCertificateInfo.Usage.UNK == ocfPrivateKey.getOCFCertificatInfo().getUsage()) {
            return false;
        }
        boolean result = false;
        if (X509Certificate.class.isInstance(cert)) {
            X509Certificate x509 = (X509Certificate)X509Certificate.class.cast(cert);
            result = x509.getKeyUsage()[1] && !x509.getKeyUsage()[0];
            String dnCountry = SimpleSignatureLevel.getCountryPart(x509.getIssuerDN().toString());
            if (COUNTRY_DE.equals(dnCountry)) {
                result = false;
                byte[] keyQCStatementExtension = x509.getExtensionValue(OID_STRING_CERTIFICATE_EXTENSION_QC_STATEMENTS);
                if (keyQCStatementExtension != null && keyQCStatementExtension.length > 0) {
                    try {
                        ASN1 qcStatement = new ASN1(keyQCStatementExtension);
                        ASN1 qcStatementValue = new ASN1(qcStatement.getValue());
                        for (ASN1 qcStatementValueChild : qcStatementValue.getChildElementList()) {
                            for (ASN1 child : qcStatementValueChild.getChildElementList()) {
                                String oidString;
                                if (!child.getTag().equals(BigInteger.valueOf(6L)) || !(oidString = new OID(child.getEncoded()).getOIDString()).equals(OID_STRING_CERTIFICATE_EXTENSION_QC_COMPLIANCE)) continue;
                                result = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        result = false;
                    }
                }
            }
            if (!result && mode == QESKeyDetectionMode.TEST && OCFCertificateInfo.Usage.SIG == ocfPrivateKey.getOCFCertificatInfo().getUsage()) {
                result = true;
            }
        }
        return result;
    }

    public static String getCountryPart(String dn) {
        return SimpleSignatureLevel.getDNPart(DN_COUNTRY_PART, dn);
    }

    public static String getDNPart(String part, String dn) {
        String result = null;
        if (part != null && part.length() > 0 && dn != null && dn.length() > 0) {
            int idxBegin = -1;
            for (String separator : DN_SEPARATOR_PAIRS) {
                String partWithSeparator = part + DN_SEPARATOR_VALUE;
                if (dn.startsWith(partWithSeparator)) {
                    idxBegin += partWithSeparator.length() + 1;
                    break;
                }
                idxBegin = dn.indexOf(partWithSeparator = separator + partWithSeparator);
                if (idxBegin < 0) continue;
                idxBegin += partWithSeparator.length();
                break;
            }
            if (idxBegin >= 0) {
                for (String separator : DN_SEPARATOR_PAIRS) {
                    int idxEnd = dn.indexOf(separator, idxBegin);
                    if (idxEnd < 0) continue;
                    result = dn.substring(idxBegin, idxEnd);
                }
                if (result == null) {
                    result = dn.substring(idxBegin);
                }
            }
        }
        return result;
    }

    public static enum QESKeyDetectionMode {
        STRICT_COMMON_PKI,
        TEST;

        public static final QESKeyDetectionMode DEFAULT;

        static {
            DEFAULT = TEST;
        }
    }
}

