/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.ExtReloadListener;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadListenerAdapter
implements ExtReloadListener {
    private static final Log log = LogFactory.getLog(ReloadListenerAdapter.class);
    private final ReloadListener listener;
    private final ExtReloadListener extListener;

    public ReloadListenerAdapter(ReloadListener reloadListener) {
        this.listener = reloadListener == null ? ExtReloadListener.DEFAULT : reloadListener;
        this.extListener = reloadListener instanceof ExtReloadListener ? (ExtReloadListener)this.listener : ExtReloadListener.DEFAULT;
    }

    @Override
    public void keyStoreCleanedUp() {
        log.debug((Object)"reload adapter listener - begin");
        try {
            this.listener.keyStoreCleanedUp();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
        }
        finally {
            log.debug((Object)"reload adapter listener - end");
        }
    }

    @Override
    public void reloadStarted() {
        log.debug((Object)"reload adapter started - begin");
        try {
            this.extListener.reloadStarted();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
        }
        finally {
            log.debug((Object)"reload adapter started - end");
        }
    }

    @Override
    public void reloadFinished() {
        log.debug((Object)"reload adapter finished - begin");
        try {
            this.extListener.reloadFinished();
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage());
            }
        }
        finally {
            log.debug((Object)"reload adapter finished - end");
        }
    }
}

