/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.DispatchListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import opencard.core.event.CTListener;

public class ProxyDispatchListener<L>
implements InvocationHandler,
DispatchListener<L> {
    private List<L> listeners;
    private final ListenerCallReturnValueStrategy returnValueStrategy;
    private final ListenerCallFailStrategy failStrategy;

    @Override
    public void addListener(L listener) {
        if (listener == null) {
            return;
        }
        this.removeListener(listener);
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(L listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public ProxyDispatchListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        this.returnValueStrategy = returnValueStrategy;
        this.failStrategy = failStrategy;
        this.listeners = new ArrayList<L>();
    }

    public static <L extends CTListener & DispatchListener<CTListener>> L newInstanceCTListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)ProxyDispatchListener.newProxy(CTListener.class, returnValueStrategy, failStrategy);
    }

    public static <L extends CardListener & DispatchListener<CardListener>> L newInstanceCardListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)ProxyDispatchListener.newProxy(CardListener.class, returnValueStrategy, failStrategy);
    }

    public static <L extends ProgressSessionListener & DispatchListener<ProgressSessionListener>> L newInstanceProgressSessionListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)ProxyDispatchListener.newProxy(ProgressSessionListener.class, returnValueStrategy, failStrategy);
    }

    public static <L extends ReloadListener & DispatchListener<ReloadListener>> L newInstanceReloadListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)ProxyDispatchListener.newProxy(ReloadListener.class, returnValueStrategy, failStrategy);
    }

    public static <L extends OCFKeyStoreListener & DispatchListener<OCFKeyStoreListener>> L newInstanceOCFKeyStoreListener(ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)ProxyDispatchListener.newProxy(OCFKeyStoreListener.class, returnValueStrategy, failStrategy);
    }

    private static <L> L newProxy(Class<L> listenerClass, ListenerCallReturnValueStrategy returnValueStrategy, ListenerCallFailStrategy failStrategy) {
        return (L)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass, DispatchListener.class}, new ProxyDispatchListener<L>(returnValueStrategy, failStrategy));
    }

    public String toString() {
        return super.toString() + "(" + this.listeners.size() + ")" + this.listeners;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        if (!DispatchListener.class.equals(method.getDeclaringClass())) {
            if (this.listeners.isEmpty()) {
                return null;
            }
            ArrayList<Object> invocationValues = new ArrayList<Object>();
            Throwable invocationFailure = null;
            for (L listener : this.listeners) {
                if (listener == null) continue;
                try {
                    invocationValues.add(method.invoke(listener, args));
                }
                catch (InvocationTargetException t) {
                    switch (this.failStrategy) {
                        case FAIL_ON_FIRST_FAILURE: {
                            throw t.getTargetException();
                        }
                        case CALL_ALL_FAIL_ON_FIRST_FAILURE: {
                            if (invocationFailure != null) break;
                            invocationFailure = t.getTargetException();
                            break;
                        }
                        case CALL_ALL_FAIL_ON_LAST_FAILURE: {
                            invocationFailure = t.getTargetException();
                            break;
                        }
                    }
                    invocationValues.add(null);
                }
                catch (Throwable t) {
                    switch (this.failStrategy) {
                        case FAIL_ON_FIRST_FAILURE: {
                            throw t;
                        }
                        case CALL_ALL_FAIL_ON_FIRST_FAILURE: {
                            if (invocationFailure != null) break;
                            invocationFailure = t;
                            break;
                        }
                        case CALL_ALL_FAIL_ON_LAST_FAILURE: {
                            invocationFailure = t;
                            break;
                        }
                    }
                    invocationValues.add(null);
                }
            }
            if (invocationFailure != null) {
                throw invocationFailure;
            }
            if (ListenerCallReturnValueStrategy.RETURN_FIRST.equals((Object)this.returnValueStrategy)) {
                return invocationValues.get(0);
            }
            return invocationValues.get(invocationValues.size() - 1);
        }
        return method.invoke((Object)this, args);
    }

    @Override
    public int listenerSize() {
        return this.listeners.size();
    }

    @Override
    public boolean areListenerEmpty() {
        return this.listeners.isEmpty();
    }

    public static enum ListenerCallReturnValueStrategy {
        RETURN_FIRST,
        RETURN_LAST;

    }

    public static enum ListenerCallFailStrategy {
        IGNORE_ANY_FAILURE,
        FAIL_ON_FIRST_FAILURE,
        CALL_ALL_FAIL_ON_FIRST_FAILURE,
        CALL_ALL_FAIL_ON_LAST_FAILURE;

    }
}

