/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.gov2.jca_provider.OCFAlgorithmParameters;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFSignatureSpi;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OCF_PSS_Signature
extends OCFSignatureSpi {
    private static final Log LOG = LogFactory.getLog(OCF_PSS_Signature.class);
    private OCFPrivateKey privateKey = null;
    private MessageDigest messageDigest = null;
    private final String algorithm;
    private final String hashAlgorithm;
    private AlgorithmParameters algorithmParameters;

    OCF_PSS_Signature(String _hashAlgorithm) {
        this.hashAlgorithm = _hashAlgorithm;
        this.algorithm = _hashAlgorithm + "withRSAandMGF1";
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        LOG.debug((Object)"engineSetParameter(String,Object)");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec param) throws InvalidParameterException {
        LOG.debug((Object)"engineSetParameter(AlgorithmParameterSpec)");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        LOG.debug((Object)"engineGetParameters()");
        return this.algorithmParameters;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int offset, int length) throws SignatureException {
        this.messageDigest.update(bytes, offset, length);
    }

    @Override
    protected void engineInitSign(PrivateKey _privateKey) throws InvalidKeyException {
        if (!(_privateKey instanceof OCFPrivateKey)) {
            throw new InvalidKeyException("must be an OCF private key");
        }
        this.privateKey = (OCFPrivateKey)_privateKey;
        X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
        if (c.getKeyUsage() == null) {
            throw new InvalidKeyException("no key usage available");
        }
        if (!c.getKeyUsage()[0] && !c.getKeyUsage()[1]) {
            throw new InvalidKeyException("wrong key usage");
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.hashAlgorithm, "BC");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidKeyException("can not instantiate message digest for \"" + this.hashAlgorithm + "\"");
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException("can not find provider Bouncy Castle");
        }
        try {
            if (c.getKeyUsage()[1]) {
                LOG.debug((Object)"using signature algorithm parameters");
                this.algorithmParameters = OCFAlgorithmParameters.getInstance(this.algorithm, this.privateKey.getAlgorithm(UsageRelated.Usage.SIGNATURE, this.algorithm).getAlgorithmParameterSpec());
            } else if (c.getKeyUsage()[0]) {
                LOG.debug((Object)"using authentication algorithm parameters");
                this.algorithmParameters = OCFAlgorithmParameters.getInstance(this.algorithm, this.privateKey.getAlgorithm(UsageRelated.Usage.AUTHENTICATION, this.algorithm).getAlgorithmParameterSpec());
            }
            LOG.debug((Object)("algorithm parameters found: " + (this.algorithmParameters != null)));
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GovCS.ResultObject engineSignOCF() throws SignatureException, InvalidCardChannelException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, NotYetInitializedException, RetryCounterExpiredException, WrongPinException, PinInputCancelledException, OperationCancelledException, ResponseCodeException, CardTerminalException, IllegalArgumentException {
        GovCS.ResultObject ro = null;
        try {
            byte[] digest = this.messageDigest.digest();
            GovCS cs = this.privateKey.getCardService();
            X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
            if (c.getKeyUsage()[1]) {
                LOG.debug((Object)"GovCS.signHash");
                ro = cs.signHash(this.privateKey.getOCFCertificatInfo(), digest, this.privateKey.getPIN(), this.hashAlgorithm, this.algorithmParameters);
            } else if (c.getKeyUsage()[0]) {
                LOG.debug((Object)"GovCS.authenticate");
                ro = cs.authentify(this.privateKey.getOCFCertificatInfo(), digest, this.privateKey.getPIN(), this.hashAlgorithm, this.algorithmParameters);
            }
        }
        finally {
            this.privateKey = null;
            this.messageDigest = null;
        }
        return ro;
    }

    public static class WHIRLPOOL
    extends OCF_PSS_Signature {
        public WHIRLPOOL() {
            super("WHIRLPOOL");
        }
    }

    public static class RIPEMD160
    extends OCF_PSS_Signature {
        public RIPEMD160() {
            super("RIPEMD160");
        }
    }

    public static class SHA512
    extends OCF_PSS_Signature {
        public SHA512() {
            super("SHA512");
        }
    }

    public static class SHA384
    extends OCF_PSS_Signature {
        public SHA384() {
            super("SHA384");
        }
    }

    public static class SHA224
    extends OCF_PSS_Signature {
        public SHA224() {
            super("SHA224");
        }
    }

    public static class SHA256
    extends OCF_PSS_Signature {
        public SHA256() {
            super("SHA256");
        }
    }

    public static class SHA1
    extends OCF_PSS_Signature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static class MD5
    extends OCF_PSS_Signature {
        public MD5() {
            super("MD5");
        }
    }
}

