/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.SignatureNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.SignatureOperationCancelledException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTooLongException;
import de.bos_bremen.gov2.jca_provider.SignaturePINInputTooShortException;
import de.bos_bremen.gov2.jca_provider.SignatureResponseCodeException;
import de.bos_bremen.gov2.jca_provider.SignatureRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.SignatureWrongPINException;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;

public abstract class OCFSignatureSpi
extends SignatureSpi {
    protected OCFSignatureSpi() {
    }

    @Override
    protected boolean engineVerify(byte[] parm1) throws SignatureException {
        throw new UnsupportedOperationException("verification of signatures using smartcards not supported");
    }

    @Override
    protected final void engineInitVerify(PublicKey initPublicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("verification of signatures using smartcards not supported");
    }

    protected abstract GovCS.ResultObject engineSignOCF() throws SignatureException, InvalidCardChannelException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, NotYetInitializedException, RetryCounterExpiredException, WrongPinException, PinInputCancelledException, OperationCancelledException, ResponseCodeException, CardTerminalException, IllegalArgumentException;

    @Override
    protected final synchronized byte[] engineSign() throws SignaturePINInputTimeoutException, SignaturePINInputTooShortException, SignaturePINInputTooLongException, SignaturePINInputCancelledException, SignatureOperationCancelledException, SignatureNotYetInitializedException, SignatureWrongPINException, SignatureRetryCounterExpiredException, SignatureException {
        GovCS.ResultObject ro = null;
        try {
            ro = this.engineSignOCF();
        }
        catch (InvalidCardChannelException ex) {
            throw new SignatureException("can't execute sign operation: card communication failed");
        }
        catch (PinInputTooShortException ex) {
            SignaturePINInputTooShortException e = new SignaturePINInputTooShortException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTooLongException ex) {
            SignaturePINInputTooLongException e = new SignaturePINInputTooLongException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTimeoutException ex) {
            SignaturePINInputTimeoutException e = new SignaturePINInputTimeoutException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (NotYetInitializedException ex) {
            SignatureNotYetInitializedException e = new SignatureNotYetInitializedException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (RetryCounterExpiredException ex) {
            SignatureRetryCounterExpiredException e = new SignatureRetryCounterExpiredException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (WrongPinException ex) {
            SignatureWrongPINException e = new SignatureWrongPINException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputCancelledException ex) {
            SignaturePINInputCancelledException e = new SignaturePINInputCancelledException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (OperationCancelledException ex) {
            SignatureOperationCancelledException e = new SignatureOperationCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (ResponseCodeException ex) {
            SignatureResponseCodeException e = new SignatureResponseCodeException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (CardTerminalException e) {
            SignatureException se = new SignatureException("can't execute sign hash operation, terminal failed");
            se.initCause(e);
            throw se;
        }
        catch (IllegalArgumentException e) {
            throw new SignatureException("internal error parameter spec initialization failed: " + e.getMessage(), e);
        }
        if (ro == null) {
            throw new SignatureException("can't execute sign operation, no result received");
        }
        if (ro.getResultCode() != 36864) {
            throw new SignatureException(APDUCommands.getPerformSecurityOperationErrorMsg(ro.getResultCode()));
        }
        return (byte[])ro.getResultData();
    }
}

