/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.common.asn1.DigestInfo;
import de.bos_bremen.common.asn1.HashAlgorithm;
import de.bos_bremen.common.crypto.ECDSASignatureConverter;
import de.bos_bremen.gov2.jca_provider.OCFAlgorithmParameters;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFSignatureSpi;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OCFSignature
extends OCFSignatureSpi {
    private static final Log LOG = LogFactory.getLog(OCFSignature.class);
    private OCFPrivateKey privateKey = null;
    private MessageDigest messageDigest = null;
    private final String hashAlgorithm;
    private final String algorithm;
    private AlgorithmParameters algorithmParameters;
    private PublicKey publicKey = null;

    protected OCFSignature(String _hashAlgorithm, String algorithm) {
        this.hashAlgorithm = _hashAlgorithm;
        this.algorithm = _hashAlgorithm + "with" + algorithm;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.algorithmParameters;
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec param) throws InvalidParameterException {
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean engineVerify(byte[] signature) throws SignatureException {
        boolean result = false;
        try {
            byte[] hashValue = this.messageDigest.digest();
            Cipher cipher = Cipher.getInstance(this.publicKey.getAlgorithm() + "/ECB/PKCS1Padding", "BC");
            cipher.init(2, this.publicKey);
            byte[] decSig = cipher.doFinal(signature);
            byte[] digestInfo = new DigestInfo(HashAlgorithm.Algorithm.WHIRLPOOL, hashValue).getEncoded();
            result = Arrays.equals(decSig, digestInfo);
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            this.publicKey = null;
            this.messageDigest = null;
        }
        return result;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int offset, int length) throws SignatureException {
        this.messageDigest.update(bytes, offset, length);
    }

    @Override
    protected void engineInitSign(PrivateKey _privateKey) throws InvalidKeyException {
        if (!(_privateKey instanceof OCFPrivateKey)) {
            throw new InvalidKeyException("must be an OCF private key");
        }
        this.privateKey = (OCFPrivateKey)_privateKey;
        X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
        if (c.getKeyUsage() == null) {
            throw new InvalidKeyException("no key usage available");
        }
        if (!c.getKeyUsage()[0] && !c.getKeyUsage()[1]) {
            throw new InvalidKeyException("wrong key usage");
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.hashAlgorithm, "BC");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidKeyException("can not instantiate message digest for \"" + this.hashAlgorithm + "\"");
        }
        catch (NoSuchProviderException ex) {
            throw new InvalidKeyException("can not find JCA provider Bouncy Castle");
        }
        try {
            if (c.getKeyUsage()[1]) {
                LOG.debug((Object)"using signature algorithm parameters");
                this.algorithmParameters = OCFAlgorithmParameters.getInstance(this.algorithm, this.privateKey.getAlgorithm(UsageRelated.Usage.SIGNATURE, this.algorithm).getAlgorithmParameterSpec());
            } else if (c.getKeyUsage()[0]) {
                LOG.debug((Object)"using authentication algorithm parameters");
                this.algorithmParameters = OCFAlgorithmParameters.getInstance(this.algorithm, this.privateKey.getAlgorithm(UsageRelated.Usage.AUTHENTICATION, this.algorithm).getAlgorithmParameterSpec());
            }
            LOG.debug((Object)("algorithm parameters found: " + (this.algorithmParameters != null)));
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GovCS.ResultObject engineSignOCF() throws SignatureException, InvalidCardChannelException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, NotYetInitializedException, RetryCounterExpiredException, WrongPinException, PinInputCancelledException, OperationCancelledException, ResponseCodeException, CardTerminalException, IllegalArgumentException {
        GovCS.ResultObject ro = null;
        byte[] digest = this.messageDigest.digest();
        GovCS cs = this.privateKey.getCardService();
        try {
            X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
            if (c.getKeyUsage()[1]) {
                LOG.debug((Object)"GovCS.signHash");
                ro = cs.signHash(this.privateKey.getOCFCertificatInfo(), digest, this.privateKey.getPIN(), this.hashAlgorithm, this.algorithmParameters);
            } else if (c.getKeyUsage()[0]) {
                LOG.debug((Object)"GovCS.authenticate");
                ro = cs.authentify(this.privateKey.getOCFCertificatInfo(), digest, this.privateKey.getPIN(), this.hashAlgorithm, this.algorithmParameters);
            }
        }
        finally {
            this.privateKey = null;
            this.messageDigest = null;
        }
        return ro;
    }

    static abstract class CVCECDSASignature
    extends OCFSignature {
        protected CVCECDSASignature(String hashAlgorithm) {
            super(hashAlgorithm, "CVC-ECDSA");
        }

        public static class WHIRLPOOL
        extends CVCECDSASignature {
            public WHIRLPOOL() {
                super("WHIRLPOOL");
            }
        }

        public static class RIPEMD160
        extends CVCECDSASignature {
            public RIPEMD160() {
                super("RIPEMD160");
            }
        }

        public static class SHA512
        extends CVCECDSASignature {
            public SHA512() {
                super("SHA512");
            }
        }

        public static class SHA384
        extends CVCECDSASignature {
            public SHA384() {
                super("SHA384");
            }
        }

        public static class SHA224
        extends CVCECDSASignature {
            public SHA224() {
                super("SHA224");
            }
        }

        public static class SHA256
        extends CVCECDSASignature {
            public SHA256() {
                super("SHA256");
            }
        }

        public static class SHA1
        extends CVCECDSASignature {
            public SHA1() {
                super("SHA1");
            }
        }

        public static class MD5
        extends CVCECDSASignature {
            public MD5() {
                super("MD5");
            }
        }
    }

    static abstract class X962ECDSASignature
    extends OCFSignature {
        protected X962ECDSASignature(String hashAlgorithm) {
            super(hashAlgorithm, "ECDSA");
        }

        @Override
        protected GovCS.ResultObject engineSignOCF() throws SignatureException, InvalidCardChannelException, PinInputTooShortException, PinInputTooLongException, PinInputTimeoutException, NotYetInitializedException, RetryCounterExpiredException, WrongPinException, PinInputCancelledException, OperationCancelledException, ResponseCodeException, CardTerminalException, IllegalArgumentException {
            GovCS.ResultObject plainSig = super.engineSignOCF();
            if (plainSig == null) {
                return plainSig;
            }
            try {
                plainSig.setResultData(ECDSASignatureConverter.toX9_62((byte[])plainSig.getResultData()));
            }
            catch (Exception e) {
                throw new SignatureException(e);
            }
            return plainSig;
        }

        public static class WHIRLPOOL
        extends X962ECDSASignature {
            public WHIRLPOOL() {
                super("WHIRLPOOL");
            }
        }

        public static class RIPEMD160
        extends X962ECDSASignature {
            public RIPEMD160() {
                super("RIPEMD160");
            }
        }

        public static class SHA512
        extends X962ECDSASignature {
            public SHA512() {
                super("SHA512");
            }
        }

        public static class SHA384
        extends X962ECDSASignature {
            public SHA384() {
                super("SHA384");
            }
        }

        public static class SHA224
        extends X962ECDSASignature {
            public SHA224() {
                super("SHA224");
            }
        }

        public static class SHA256
        extends X962ECDSASignature {
            public SHA256() {
                super("SHA256");
            }
        }

        public static class SHA1
        extends X962ECDSASignature {
            public SHA1() {
                super("SHA1");
            }
        }

        public static class MD5
        extends X962ECDSASignature {
            public MD5() throws NoSuchAlgorithmException, NoSuchProviderException {
                super("MD5");
            }
        }
    }

    public static class WHIRLPOOL
    extends RSA {
        public WHIRLPOOL() {
            super("WHIRLPOOL");
        }
    }

    public static class RIPEMD160
    extends RSA {
        public RIPEMD160() {
            super("RIPEMD160");
        }
    }

    public static class SHA512
    extends RSA {
        public SHA512() {
            super("SHA512");
        }
    }

    public static class SHA384
    extends RSA {
        public SHA384() {
            super("SHA384");
        }
    }

    public static class SHA224
    extends RSA {
        public SHA224() {
            super("SHA224");
        }
    }

    public static class SHA256
    extends RSA {
        public SHA256() {
            super("SHA256");
        }
    }

    public static class SHA1
    extends RSA {
        public SHA1() {
            super("SHA1");
        }
    }

    public static class MD5
    extends RSA {
        public MD5() {
            super("MD5");
        }
    }

    public static class RSA
    extends OCFSignature {
        public RSA(String hashAlgorithm) {
            super(hashAlgorithm, "RSA");
        }
    }

    public static class WHIRLPOOLDINSIG
    extends RSADINSIG {
        public WHIRLPOOLDINSIG() {
            super("WHIRLPOOL");
        }
    }

    public static class SHA512DINSIG
    extends RSADINSIG {
        public SHA512DINSIG() {
            super("SHA512");
        }
    }

    public static class SHA384DINSIG
    extends RSADINSIG {
        public SHA384DINSIG() {
            super("SHA384");
        }
    }

    public static class SHA256DINSIG
    extends RSADINSIG {
        public SHA256DINSIG() {
            super("SHA256");
        }
    }

    public static class SHA224DINSIG
    extends RSADINSIG {
        public SHA224DINSIG() {
            super("SHA224");
        }
    }

    public static class RIPEMD160DINSIG
    extends RSADINSIG {
        public RIPEMD160DINSIG() {
            super("RIPEMD160");
        }
    }

    public static class SHA1DINSIG
    extends RSADINSIG {
        public SHA1DINSIG() {
            super("SHA1");
        }
    }

    public static class MD5DINSIG
    extends RSADINSIG {
        public MD5DINSIG() {
            super("MD5");
        }
    }

    public static class RSADINSIG
    extends OCFSignature {
        public RSADINSIG(String hashAlgorithm) {
            super(hashAlgorithm, "RSA/ISO9796-2rnd");
        }
    }
}

