/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.common.StringUtil;
import de.bos_bremen.gov2.jca_provider.OCFAlgorithmParametersSpi;
import de.bos_bremen.gov2.jca_provider.OCFCipher;
import de.bos_bremen.gov2.jca_provider.OCFKeyAgreement;
import de.bos_bremen.gov2.jca_provider.OCFKeyStore;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.OCFSignature;
import de.bos_bremen.gov2.jca_provider.OCF_PSS_Signature;
import de.bos_bremen.gov2.jca_provider.OCF_RAW_PSS_Signature;
import de.bos_bremen.gov2.jca_provider.OCF_RAW_Signature;
import de.bos_bremen.gov2.jca_provider.eccipher.ECCipher;
import de.bos_bremen.gov2.jca_provider.eccipher.OCFECDHKeyAgreementSpi;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSClientFactory;
import de.bos_bremen.gov2.jca_provider.params.AbstractAlgorithmParameterSpi;
import de.bos_bremen.version.Versioned;
import de.governikus.CompInfo.ComponentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;

public class OCFProvider
extends Provider {
    private static final String COMPONENTINFO_MCARD_VERSION = "mcard.version";
    public static final String EXTERNAL_PROVIDER_NAME = "BC";
    public static final String EC_SIG_SCHEME_DSA = "DSA";
    public static final String EC_SIG_SCHEME_PREFIX_PLAIN_FORMAT = "CVC-";
    public static final String KEY_ALGORITHM_EC = "EC";
    public static final String KEY_ALGORITHM_RSA = "RSA";
    public static final String KEY_ALGORITHM_DSA = "DSA";
    public static final String EC_SIGNATURE_ALGORITHM_ECDSA_X962_FORMAT = "ECDSA";
    public static final String EC_SIGNATURE_ALGORITHM_ECDSA_PLAIN_FORMAT = "CVC-ECDSA";
    public static final String PARAMETERS_OCF_SIGN = "OCFSIGN";
    public static final String PARAMETERS_OCF_DECRYPT_RSA = "OCFDECRYPTRSA";
    public static final String PARAMETERS_OCF_DECRYPT_EC = "OCFDECRYPTEC";
    public static final String PROVIDER_ALGORITHM_PARAMETERS_KEY = "AlgorithmParameters.";
    public static final String PROVIDER_ALG_ALIAS_ALGORITHM_PARAMETERS_KEY = "Alg.Alias.AlgorithmParameters.";
    public static final String COMPONENT_NAME = "MCard Security Provider";
    private static final Log LOGGER = LogFactory.getLog(OCFProvider.class);
    public static final String ATTRIBUTE_PREFIX = " ";
    public static final String ATTRIBUTE_SUPPORTED_KEY_CLASSES = " SupportedKeyClasses";
    public static final String HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_HASHES = "hashedWith";
    public static final String HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_MESSAGES = "with";
    public static final String RSA_SCHEME_PKCS1 = "/PKCS1";
    public static final String RSA_SCHEME_ENC_PKCS1_V15 = "/ECB/PKCS1Padding";
    @Deprecated
    public static final String RSA_SCHEME_PKCS1_V15 = "/ECB/PKCS1Padding";
    public static final String RSA_SCHEME_SIG_ISO97962RND = "/ISO9796-2rnd";
    public static final String RSA_SCHEME_SIG_DINSIG = "/DINSIG";
    public static final String RSA_SCHEME_SIG_PSS = "/PSS";
    public static final String RSA_SCHEME_SIG_PSS_MGF1 = "andMGF1";
    public static final String BLOCK_MODE_ECB = "/ECB";
    public static final String RSA_SCHEME_ENC_OAEP = "/ECB/OAEP";
    private static final int VERSION_FRACTION_FACTOR = 1000;
    private static final int MINOR_VERSION_FRACTION_FACTOR = 1000;
    private static final int MAJOR_VERSION_FRACTION_FACTOR = 1000000;
    private static final int RELEASE_VERSION_FRACTION_FACTOR = 1000000000;
    public static final String PROVIDER_NAME = "OCF";
    @Deprecated
    public static final String PROVIDERNAME = "OCF";
    public static final String KEYSTORE_TYPE = "OCF";
    public static final double PROVIDER_VERSION = Versioned.Util.getComponentInfoVersion("mcard.version");
    static final long serialVersionUID = -4298100515446427739L;

    public static String toHashSignatureAlgorithmName(String algorithmName) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            return algorithmName;
        }
        if (algorithmName.contains(HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_MESSAGES)) {
            return algorithmName.replaceAll(HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_MESSAGES, HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_HASHES);
        }
        return algorithmName;
    }

    public static String toPlainFormatSignatureAlgorithmName(String algorithmName) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            return algorithmName;
        }
        String ecdsa = EC_SIGNATURE_ALGORITHM_ECDSA_X962_FORMAT;
        if (algorithmName.contains(ecdsa)) {
            return algorithmName.replaceAll(ecdsa, EC_SIG_SCHEME_PREFIX_PLAIN_FORMAT + ecdsa);
        }
        return algorithmName;
    }

    public OCFProvider() {
        super("OCF", OCFProvider.getVersionString(), "OCFProvider (MCard " + OCFProvider.getVersionString() + ")");
        this.addBaseParameters();
        this.addKeyStore();
        this.addCipher();
        this.addKeyAggreement();
        this.addSignature();
        OCFECDHKeyAgreementSpi.addCMSEntries(this);
        AbstractAlgorithmParameterSpi.addCMSEntries(this);
        Settings.getInstance();
    }

    private void addSignature() {
        this.addRSASignature();
        this.addECDSASignature();
    }

    private void addRSASignature() {
        String cryptoAlgorithm = KEY_ALGORITHM_RSA;
        String[] hashAlgorithms = new String[]{"MD5", "SHA1", "RIPEMD160", "SHA224", "SHA256", "SHA384", "SHA512", "WHIRLPOOL"};
        String[] hashAlgCryptoSeparators = new String[]{HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_MESSAGES, HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_HASHES};
        String[] cryptoAlgorithmSuffixes = new String[]{"", RSA_SCHEME_PKCS1, RSA_SCHEME_SIG_PSS_MGF1, RSA_SCHEME_SIG_PSS, RSA_SCHEME_SIG_ISO97962RND, RSA_SCHEME_SIG_DINSIG};
        this.addParameter(cryptoAlgorithm, hashAlgorithms, hashAlgCryptoSeparators, cryptoAlgorithmSuffixes, PARAMETERS_OCF_SIGN, true);
        this.put("Signature.MD5withRSA", OCFSignature.MD5.class.getName());
        this.put("Signature.SHA1withRSA", OCFSignature.SHA1.class.getName());
        this.put("Signature.RIPEMD160withRSA", OCFSignature.RIPEMD160.class.getName());
        this.put("Signature.SHA224withRSA", OCFSignature.SHA224.class.getName());
        this.put("Signature.SHA256withRSA", OCFSignature.SHA256.class.getName());
        this.put("Signature.SHA384withRSA", OCFSignature.SHA384.class.getName());
        this.put("Signature.SHA512withRSA", OCFSignature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLwithRSA", OCFSignature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.MD5withRSA/PKCS1", "MD5withRSA");
        this.put("Alg.Alias.Signature.SHA1withRSA/PKCS1", "SHA1withRSA");
        this.put("Alg.Alias.Signature.RIPEMD160withRSA/PKCS1", "RIPEMD160withRSA");
        this.put("Alg.Alias.Signature.SHA224withRSA/PKCS1", "SHA224withRSA");
        this.put("Alg.Alias.Signature.SHA256withRSA/PKCS1", "SHA256withRSA");
        this.put("Alg.Alias.Signature.SHA384withRSA/PKCS1", "SHA384withRSA");
        this.put("Alg.Alias.Signature.SHA512withRSA/PKCS1", "SHA512withRSA");
        this.put("Alg.Alias.Signature.WHIRLPOOLwithRSA/PKCS1", "WHIRLPOOLwithRSA");
        this.put("Signature.MD5withRSA/ISO9796-2rnd", OCFSignature.MD5DINSIG.class.getName());
        this.put("Signature.SHA1withRSA/ISO9796-2rnd", OCFSignature.SHA1DINSIG.class.getName());
        this.put("Signature.RIPEMD160withRSA/ISO9796-2rnd", OCFSignature.RIPEMD160DINSIG.class.getName());
        this.put("Signature.SHA224withRSA/ISO9796-2rnd", OCFSignature.SHA224DINSIG.class.getName());
        this.put("Signature.SHA256withRSA/ISO9796-2rnd", OCFSignature.SHA256DINSIG.class.getName());
        this.put("Signature.SHA384withRSA/ISO9796-2rnd", OCFSignature.SHA384DINSIG.class.getName());
        this.put("Signature.SHA512withRSA/ISO9796-2rnd", OCFSignature.SHA512DINSIG.class.getName());
        this.put("Signature.WHIRLPOOLwithRSA/ISO9796-2rnd", OCFSignature.WHIRLPOOLDINSIG.class.getName());
        this.put("Alg.Alias.Signature.MD5withRSA/DINSIG", "MD5withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA1withRSA/DINSIG", "SHA1withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.RIPEMD160withRSA/DINSIG", "RIPEMD160withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA224withRSA/DINSIG", "SHA224withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA256withRSA/DINSIG", "SHA256withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA384withRSA/DINSIG", "SHA384withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA512withRSA/DINSIG", "SHA512withRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.WHIRLPOOLwithRSA/DINSIG", "WHIRLPOOLwithRSA/ISO9796-2rnd");
        this.put("Signature.MD5withRSAandMGF1", OCF_PSS_Signature.MD5.class.getName());
        this.put("Signature.SHA1withRSAandMGF1", OCF_PSS_Signature.SHA1.class.getName());
        this.put("Signature.RIPEMD160withRSAandMGF1", OCF_PSS_Signature.RIPEMD160.class.getName());
        this.put("Signature.SHA224withRSAandMGF1", OCF_PSS_Signature.SHA224.class.getName());
        this.put("Signature.SHA256withRSAandMGF1", OCF_PSS_Signature.SHA256.class.getName());
        this.put("Signature.SHA384withRSAandMGF1", OCF_PSS_Signature.SHA384.class.getName());
        this.put("Signature.SHA512withRSAandMGF1", OCF_PSS_Signature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLwithRSAandMGF1", OCF_PSS_Signature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.MD5withRSA/PSS", "MD5withRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA1withRSA/PSS", "SHA1withRSAandMGF1");
        this.put("Alg.Alias.Signature.RIPEMD160withRSA/PSS", "RIPEMD160withRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA224withRSA/PSS", "SHA224withRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA256withRSA/PSS", "SHA256withRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA384withRSA/PSS", "SHA384withRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA512withRSA/PSS", "SHA512withRSAandMGF1");
        this.put("Alg.Alias.Signature.WHIRLPOOLwithRSA/PSS", "WHIRLPOOLwithRSAandMGF1");
        this.put("Signature.MD5hashedWithRSA", OCF_RAW_Signature.MD5.class.getName());
        this.put("Signature.SHA1hashedWithRSA", OCF_RAW_Signature.SHA1.class.getName());
        this.put("Signature.RIPEMD160hashedWithRSA", OCF_RAW_Signature.RIPEMD160.class.getName());
        this.put("Signature.SHA224hashedWithRSA", OCF_RAW_Signature.SHA224.class.getName());
        this.put("Signature.SHA256hashedWithRSA", OCF_RAW_Signature.SHA256.class.getName());
        this.put("Signature.SHA384hashedWithRSA", OCF_RAW_Signature.SHA384.class.getName());
        this.put("Signature.SHA512hashedWithRSA", OCF_RAW_Signature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLhashedWithRSA", OCF_RAW_Signature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.MD5hashedWithRSA/PKCS1", "MD5hashedWithRSA");
        this.put("Alg.Alias.Signature.SHA1hashedWithRSA/PKCS1", "SHA1hashedWithRSA");
        this.put("Alg.Alias.Signature.RIPEMD160hashedWithRSA/PKCS1", "RIPEMD160hashedWithRSA");
        this.put("Alg.Alias.Signature.SHA224hashedWithRSA/PKCS1", "SHA224hashedWithRSA");
        this.put("Alg.Alias.Signature.SHA256hashedWithRSA/PKCS1", "SHA256hashedWithRSA");
        this.put("Alg.Alias.Signature.SHA384hashedWithRSA/PKCS1", "SHA384hashedWithRSA");
        this.put("Alg.Alias.Signature.SHA512hashedWithRSA/PKCS1", "SHA512hashedWithRSA");
        this.put("Alg.Alias.Signature.WHIRLPOOLhashedWithRSA/PKCS1", "WHIRLPOOLhashedWithRSA");
        this.put("Signature.MD5hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.MD5DINSIG.class.getName());
        this.put("Signature.SHA1hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.SHA1DINSIG.class.getName());
        this.put("Signature.RIPEMD160hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.RIPEMD160DINSIG.class.getName());
        this.put("Signature.SHA224hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.SHA224DINSIG.class.getName());
        this.put("Signature.SHA256hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.SHA256DINSIG.class.getName());
        this.put("Signature.SHA384hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.SHA384DINSIG.class.getName());
        this.put("Signature.SHA512hashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.SHA512DINSIG.class.getName());
        this.put("Signature.WHIRLPOOLhashedWithRSA/ISO9796-2rnd", OCF_RAW_Signature.WHIRLPOOLDINSIG.class.getName());
        this.put("Alg.Alias.Signature.MD5hashedWithRSA/DINSIG", "MD5hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA1hashedWithRSA/DINSIG", "SHA1hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.RIPEMD160hashedWithRSA/DINSIG", "RIPEMD160hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA224hashedWithRSA/DINSIG", "SHA224hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA256hashedWithRSA/DINSIG", "SHA256hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA384hashedWithRSA/DINSIG", "SHA384hashedWithRSA/ISO9796-2rnd");
        this.put("Alg.Alias.Signature.SHA512hashedWithRSA/DINSIG", "SHA512hashedWithRSA/ISO9796-2rnd");
        this.put("Signature.MD5hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.MD5.class.getName());
        this.put("Signature.SHA1hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.SHA1.class.getName());
        this.put("Signature.RIPEMD160hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.RIPEMD160.class.getName());
        this.put("Signature.SHA224hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.SHA224.class.getName());
        this.put("Signature.SHA256hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.SHA256.class.getName());
        this.put("Signature.SHA384hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.SHA384.class.getName());
        this.put("Signature.SHA512hashedWithRSAandMGF1", OCF_RAW_PSS_Signature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLhashedWithRSAandMGF1", OCF_RAW_PSS_Signature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.MD5hashedWithRSA/PSS", "MD5hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA1hashedWithRSA/PSS", "SHA1hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.RIPEMD160hashedWithRSA/PSS", "RIPEMD160hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA224hashedWithRSA/PSS", "SHA224hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA256hashedWithRSA/PSS", "SHA256hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA384hashedWithRSA/PSS", "SHA384hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.SHA512hashedWithRSA/PSS", "SHA512hashedWithRSAandMGF1");
        this.put("Alg.Alias.Signature.WHIRLPOOLhashedWithRSA/PSS", "WHIRLPOOLhashedWithRSAandMGF1");
        this.addSignatureSupportedKeyAttributes(cryptoAlgorithm, hashAlgorithms, hashAlgCryptoSeparators, cryptoAlgorithmSuffixes, OCFPrivateKey.class.getName(), Arrays.asList(1, 3, 5));
    }

    private void addSignatureSupportedKeyAttributes(String cryptoAlgorithm, String[] hashAlgorithms, String[] hashAlgCryptoSeparators, String[] cryptoAlgorithmSuffixes, String value, List<Integer> aliasIndices) {
        List<String> cryptoAlgorithmSuffixesList = Arrays.asList(cryptoAlgorithmSuffixes);
        for (String hashAlgorithm : hashAlgorithms) {
            for (String hashAlgCryptoSeparator : hashAlgCryptoSeparators) {
                for (String cryptoAlgorithmSuffix : cryptoAlgorithmSuffixes) {
                    Integer idx = cryptoAlgorithmSuffixesList.indexOf(cryptoAlgorithmSuffix);
                    String jceName = (aliasIndices.contains(idx) ? "Alg.Alias.Signature." : "Signature.") + hashAlgorithm + hashAlgCryptoSeparator + cryptoAlgorithm + cryptoAlgorithmSuffix;
                    this.addSupportedKeyAttribute(jceName, value);
                }
            }
        }
    }

    private void addSupportedKeyAttribute(String jceName, String value) {
        this.put(jceName + ATTRIBUTE_SUPPORTED_KEY_CLASSES, value);
    }

    private void addECDSASignature() {
        String cryptoAlgorithm = EC_SIGNATURE_ALGORITHM_ECDSA_X962_FORMAT;
        String[] hashAlgorithms = new String[]{"MD5", "SHA1", "RIPEMD160", "SHA224", "SHA256", "SHA384", "SHA512", "WHIRLPOOL"};
        String[] hashAlgCryptoSeparators = new String[]{HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_MESSAGES, HASH_ALG_CRYPTO_ALG_SEPARATOR_FOR_SIGNING_HASHES, "withCVC-", "hashedWithCVC-"};
        String[] cryptoAlgorithmSuffixes = new String[]{""};
        this.addParameter(cryptoAlgorithm, hashAlgorithms, hashAlgCryptoSeparators, cryptoAlgorithmSuffixes, PARAMETERS_OCF_SIGN, true);
        this.addParameter("1.2.840.10045.4.1", PARAMETERS_OCF_SIGN, true);
        this.addParameter("1.2.840.10045.4.3.1", PARAMETERS_OCF_SIGN, true);
        this.addParameter("1.2.840.10045.4.3.2", PARAMETERS_OCF_SIGN, true);
        this.addParameter("1.2.840.10045.4.3.3", PARAMETERS_OCF_SIGN, true);
        this.addParameter("1.2.840.10045.4.3.4", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.1", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.6", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.2", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.3", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.4", PARAMETERS_OCF_SIGN, true);
        this.addParameter("0.4.0.127.0.7.1.1.4.1.5", PARAMETERS_OCF_SIGN, true);
        this.put("Signature.MD5withECDSA", OCFSignature.X962ECDSASignature.MD5.class.getName());
        this.put("Signature.SHA1withECDSA", OCFSignature.X962ECDSASignature.SHA1.class.getName());
        this.put("Signature.RIPEMD160withECDSA", OCFSignature.X962ECDSASignature.RIPEMD160.class.getName());
        this.put("Signature.SHA224withECDSA", OCFSignature.X962ECDSASignature.SHA224.class.getName());
        this.put("Signature.SHA256withECDSA", OCFSignature.X962ECDSASignature.SHA256.class.getName());
        this.put("Signature.SHA384withECDSA", OCFSignature.X962ECDSASignature.SHA384.class.getName());
        this.put("Signature.SHA512withECDSA", OCFSignature.X962ECDSASignature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLwithECDSA", OCFSignature.X962ECDSASignature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.1.2.840.10045.4.1", "SHA1withECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.1", "SHA224withECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.2", "SHA256withECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.3", "SHA384withECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.4", "SHA512withECDSA");
        this.put("Signature.MD5withCVC-ECDSA", OCFSignature.CVCECDSASignature.MD5.class.getName());
        this.put("Signature.SHA1withCVC-ECDSA", OCFSignature.CVCECDSASignature.SHA1.class.getName());
        this.put("Signature.RIPEMD160withCVC-ECDSA", OCFSignature.CVCECDSASignature.RIPEMD160.class.getName());
        this.put("Signature.SHA224withCVC-ECDSA", OCFSignature.CVCECDSASignature.SHA224.class.getName());
        this.put("Signature.SHA256withCVC-ECDSA", OCFSignature.CVCECDSASignature.SHA256.class.getName());
        this.put("Signature.SHA384withCVC-ECDSA", OCFSignature.CVCECDSASignature.SHA384.class.getName());
        this.put("Signature.SHA512withCVC-ECDSA", OCFSignature.CVCECDSASignature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLwithCVC-ECDSA", OCFSignature.CVCECDSASignature.WHIRLPOOL.class.getName());
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.1", "SHA1withCVC-ECDSA");
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.6", "RIPEMD160withCVC-ECDSA");
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.2", "SHA224withCVC-ECDSA");
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.3", "SHA256withCVC-ECDSA");
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.4", "SHA384withCVC-ECDSA");
        this.put("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.5", "SHA512withCVC-ECDSA");
        this.put("Signature.MD5hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.MD5.class.getName());
        this.put("Signature.SHA1hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.SHA1.class.getName());
        this.put("Signature.RIPEMD160hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.RIPEMD160.class.getName());
        this.put("Signature.SHA224hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.SHA224.class.getName());
        this.put("Signature.SHA256hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.SHA256.class.getName());
        this.put("Signature.SHA384hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.SHA384.class.getName());
        this.put("Signature.SHA512hashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLhashedWithECDSA", OCF_RAW_Signature.X962ECDSASignature.WHIRLPOOL.class.getName());
        this.put("Signature.MD5hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.MD5.class.getName());
        this.put("Signature.SHA1hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.SHA1.class.getName());
        this.put("Signature.RIPEMD160hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.RIPEMD160.class.getName());
        this.put("Signature.SHA224hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.SHA224.class.getName());
        this.put("Signature.SHA256hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.SHA256.class.getName());
        this.put("Signature.SHA384hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.SHA384.class.getName());
        this.put("Signature.SHA512hashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.SHA512.class.getName());
        this.put("Signature.WHIRLPOOLhashedWithCVC-ECDSA", OCF_RAW_Signature.CVCECDSASignature.WHIRLPOOL.class.getName());
        this.addSignatureSupportedKeyAttributes(cryptoAlgorithm, hashAlgorithms, hashAlgCryptoSeparators, cryptoAlgorithmSuffixes, OCFPrivateKey.class.getName(), Arrays.asList(new Integer[0]));
        this.addSupportedKeyAttribute("Alg.Alias.Signature.1.2.840.10045.4.1", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.1.2.840.10045.4.3.1", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.1.2.840.10045.4.3.2", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.1.2.840.10045.4.3.3", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.1.2.840.10045.4.3.4", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.1", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.6", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.2", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.3", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.4", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Alg.Alias.Signature.0.4.0.127.0.7.1.1.4.1.5", OCFPrivateKey.class.getName());
    }

    private void addKeyStore() {
        this.put("KeyStore.OCF", OCFKeyStore.class.getName());
    }

    private void addBaseParameters() {
        this.put("AlgorithmParameters.OCFSIGN", OCFAlgorithmParametersSpi.OCFSignAuthenticateAlgorithmParametersSpi.class.getName());
        this.put("AlgorithmParameters.OCFDECRYPTRSA", OCFAlgorithmParametersSpi.OCFDecryptRSAParametersSpi.class.getName());
        this.put("AlgorithmParameters.OCFDECRYPTEC", OCFAlgorithmParametersSpi.OCFDecryptECParametersSpi.class.getName());
    }

    private void addCipher() {
        this.put("Alg.Alias.AlgorithmParameters.RSA", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/PKCS1", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/ECB/PKCS1Padding", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/ECB/OAEP", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/NONE/OAEPWithSHA224AndMGF1Padding", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/NONE/OAEPWithSHA256AndMGF1Padding", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/NONE/OAEPWithSHA384AndMGF1Padding", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.RSA/NONE/OAEPWithSHA512AndMGF1Padding", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Cipher.RSA", OCFCipher.class.getName());
        this.put("Alg.Alias.Cipher.RSA/PKCS1", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/ECB/PKCS1Padding", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/ECB/OAEP", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/NONE/OAEPWithSHA224AndMGF1Padding", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/NONE/OAEPWithSHA256AndMGF1Padding", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/NONE/OAEPWithSHA384AndMGF1Padding", "Cipher.RSA");
        this.put("Alg.Alias.Cipher.RSA/NONE/OAEPWithSHA512AndMGF1Padding", "Cipher.RSA");
        this.put("Cipher.RSA SupportedKeyClasses", OCFPrivateKey.class.getName());
        this.addSupportedKeyAttribute("Cipher.RSA", OCFPrivateKey.class.getName());
        this.put("Alg.Alias.Cipher.RSA/PKCS1 SupportedKeyClasses", OCFPrivateKey.class.getName());
        this.put("Alg.Alias.Cipher.RSA/ECB/PKCS1Padding SupportedKeyClasses", OCFPrivateKey.class.getName());
        this.put("Alg.Alias.Cipher.RSA/ECB/OAEP SupportedKeyClasses", OCFPrivateKey.class.getName());
        this.put("Alg.Alias.AlgorithmParameters.EC", PARAMETERS_OCF_DECRYPT_EC);
        this.put("Cipher.EC", ECCipher.class.getName());
        this.put("Alg.Alias.Cipher.ECIES", ECCipher.class.getName());
        this.addSupportedKeyAttribute("Cipher.EC", OCFPrivateKey.class.getName());
        this.put("Alg.Alias.Cipher.ECIES SupportedKeyClasses", OCFPrivateKey.class.getName());
        String oidRsaOaep = "1.2.840.113549.1.1.7";
        this.put("Cipher." + oidRsaOaep, OCFCipher.class.getName());
        this.addSupportedKeyAttribute("Cipher." + oidRsaOaep, OCFPrivateKey.class.getName());
    }

    private void addKeyAggreement() {
        this.put("Alg.Alias.AlgorithmParameters.RSA", PARAMETERS_OCF_DECRYPT_RSA);
        this.put("Alg.Alias.AlgorithmParameters.ECDH", PARAMETERS_OCF_DECRYPT_EC);
        this.put("KeyAgreement.ECDH", OCFKeyAgreement.class.getName());
        this.addSupportedKeyAttribute("KeyAgreement.ECDH", OCFPrivateKey.class.getName());
    }

    private void addParameter(String cryptoAlgorithm, String[] hashAlgorithms, String[] hashAlgCryptoSeparators, String[] cryptoAlgorithmSuffixes, String value, boolean alias) {
        for (String hashAlgorithm : hashAlgorithms) {
            for (String hashAlgCryptoSeparator : hashAlgCryptoSeparators) {
                for (String cryptoAlgorithmSuffix : cryptoAlgorithmSuffixes) {
                    String jceName = hashAlgorithm + hashAlgCryptoSeparator + cryptoAlgorithm + cryptoAlgorithmSuffix;
                    this.addParameter(jceName, value, alias);
                }
            }
        }
    }

    private void addParameter(String jceName, String value, boolean alias) {
        this.put((alias ? PROVIDER_ALG_ALIAS_ALGORITHM_PARAMETERS_KEY : PROVIDER_ALGORITHM_PARAMETERS_KEY) + jceName, value);
    }

    public static String getVersionString() {
        DecimalFormat df = new DecimalFormat("##0");
        return df.format(OCFProvider.getReleaseVersion()) + "." + df.format(OCFProvider.getMajorVersion()) + "." + df.format(OCFProvider.getMinorVersion());
    }

    @Override
    public String getVersionStr() {
        return OCFProvider.getVersionString();
    }

    public static int getReleaseVersion() {
        return (int)(PROVIDER_VERSION / 1.0E9);
    }

    public static int getMajorVersion() {
        return (int)((PROVIDER_VERSION - (double)(OCFProvider.getReleaseVersion() * 1000000000)) / 1000000.0);
    }

    public static int getMinorVersion() {
        return (int)((PROVIDER_VERSION - (double)(OCFProvider.getReleaseVersion() * 1000000000) - (double)(OCFProvider.getMajorVersion() * 1000000)) / 1000.0);
    }

    public static int getBuildVersion() {
        return (int)(PROVIDER_VERSION - (double)(OCFProvider.getReleaseVersion() * 1000000000) - (double)(OCFProvider.getMajorVersion() * 1000000) - (double)(OCFProvider.getMinorVersion() * 1000));
    }

    public String getComponentVersion() {
        return new ComponentInfo(COMPONENTINFO_MCARD_VERSION).getComponentVersion();
    }

    public String getRevision() {
        return String.valueOf(PROVIDER_VERSION);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public static class Settings {
        private static Settings SINGLETON = null;
        private static final String BASE_JAR_URL_PREFIX = "jar:";
        private static final String JAR_URL_PREFIX = "jar:file:";
        private static final String JAR_URL_JAVA_WEB_START_PREFIX = "jar:http:";
        private static final String JAR_URL_SEPARATOR_ENTRY = "!";
        private static final String EXTENSION_JAVA_CLASS = ".class";
        private static final String JAVA_PACKAGE_SEPARATOR = ".";
        private static final String JAVA_RESOURCE_SEPARATOR = "/";
        private static final String MANIFEST_DIGEST_ATTRIBUTE_SUFFIX = "-Digest";
        private static final String EXTENSION_PROPERTIES_DEFAULT = ".properties";
        private static final String EXTENSION_PROPERTIES_XML = ".xml";
        private static final String RESOURCE_ROOT = "/";
        private static final String PROVIDER_SETTINGS_PROPERTIES_XML = "providerSettings.xml";
        private static final String SHA256_ALGORITHM_NAME = "SHA-256";
        private static final String DEFAULT_HASH_ALGORITHM_NAME = "SHA-256";
        private static final String PROPERTY_KEY_SERVER_ENVIRONMENT_ACTIVE = "serverEnvironmentActive";
        private static final String PROPERTY_KEY_STAPLE_SIGNATURE_ENABLED = "stapleSignatureEnabled";
        private static final String PROPERTY_KEY_CARD_SERVICE_FACTORY = "cardServiceFactory";
        private boolean serverEnvironmentActive = false;
        private boolean stapleSignatureEnabled = true;
        private String cardServiceFactory = GovCSClientFactory.class.getName();
        private Properties properties = null;

        private Settings() {
            this.init();
        }

        public static synchronized Settings getInstance() {
            if (SINGLETON == null) {
                SINGLETON = new Settings();
            }
            return SINGLETON;
        }

        public boolean isClientEnvironmentActive() {
            return !this.isServerEnvironmentActive();
        }

        public boolean isServerEnvironmentActive() {
            return this.serverEnvironmentActive;
        }

        public boolean isStapleSignatureEnabled() {
            return this.stapleSignatureEnabled;
        }

        public String getCardServiceFactory() {
            return this.cardServiceFactory;
        }

        private synchronized void init() {
            block3: {
                try {
                    LOGGER.debug((Object)"OCFProvider.initSettings()-loading");
                    this.properties = Settings.secureLoadProperties(OCFProvider.class, PROVIDER_SETTINGS_PROPERTIES_XML, "SHA-256");
                    LOGGER.debug((Object)"OCFProvider.initSettings()-loaded");
                    String serverEnvironmentPropertyValue = this.properties.getProperty(PROPERTY_KEY_SERVER_ENVIRONMENT_ACTIVE);
                    this.serverEnvironmentActive = serverEnvironmentPropertyValue != null ? Boolean.TRUE.toString().equals(serverEnvironmentPropertyValue) : false;
                    String stapleSignatureEnabledPropertyValue = this.properties.getProperty(PROPERTY_KEY_STAPLE_SIGNATURE_ENABLED);
                    this.stapleSignatureEnabled = stapleSignatureEnabledPropertyValue != null ? Boolean.TRUE.toString().equals(stapleSignatureEnabledPropertyValue) : true;
                    String cardServiceFactoryPropertyValue = this.properties.getProperty(PROPERTY_KEY_CARD_SERVICE_FACTORY);
                    this.cardServiceFactory = StringUtil.isNullOrEmpty(cardServiceFactoryPropertyValue) ? GovCSClientFactory.class.getName() : cardServiceFactoryPropertyValue;
                    cardServiceFactoryPropertyValue = System.getProperties().getProperty(PROPERTY_KEY_CARD_SERVICE_FACTORY, "");
                    if (!StringUtil.isNullOrEmpty(cardServiceFactoryPropertyValue)) {
                        LOGGER.debug((Object)("using GovCSClientFactory set by property: " + this.cardServiceFactory));
                        this.cardServiceFactory = cardServiceFactoryPropertyValue;
                    }
                }
                catch (Throwable e) {
                    LOGGER.debug((Object)"failed loading 'providerSettings.xml'", e);
                    this.properties = new Properties();
                    this.serverEnvironmentActive = false;
                    this.stapleSignatureEnabled = true;
                    this.cardServiceFactory = GovCSClientFactory.class.getName();
                    String cardServiceFactoryPropertyValue = System.getProperties().getProperty(PROPERTY_KEY_CARD_SERVICE_FACTORY, "");
                    if (StringUtil.isNullOrEmpty(cardServiceFactoryPropertyValue)) break block3;
                    LOGGER.debug((Object)("using GovCSClientFactory set by property: " + cardServiceFactoryPropertyValue));
                    this.cardServiceFactory = cardServiceFactoryPropertyValue;
                }
            }
        }

        public static String getJarFilename(URL jarEntryURL) {
            String tmp = jarEntryURL.toString();
            int idx1 = tmp.indexOf(JAR_URL_PREFIX) + JAR_URL_PREFIX.length();
            if (idx1 != JAR_URL_PREFIX.length() && (idx1 = tmp.indexOf(JAR_URL_JAVA_WEB_START_PREFIX) + JAR_URL_JAVA_WEB_START_PREFIX.length()) != JAR_URL_JAVA_WEB_START_PREFIX.length()) {
                return null;
            }
            int idx2 = tmp.indexOf(JAR_URL_SEPARATOR_ENTRY);
            if (idx2 == -1) {
                return null;
            }
            if (idx1 >= idx2) {
                return null;
            }
            if ((tmp = tmp.substring(idx1, idx2)).indexOf("//") >= 0) {
                idx1 = tmp.indexOf("/", 2);
                if (idx1 == -1) {
                    return null;
                }
                tmp = tmp.substring(idx1);
            }
            return tmp;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static Properties secureLoadProperties(Class<?> loaderClass, String propertyFilename, String digestAlgorithmName) throws IOException, SecurityException, NoSuchAlgorithmException, NoSuchProviderException {
            String jarFilenameClassResourceFile;
            String loaderClassResourcename;
            URL loaderClassURL;
            if (loaderClass == null) {
                throw new SecurityException("Class for loading properties expected");
            }
            URL propertyURL = loaderClass.getResource(propertyFilename);
            if (propertyURL == null) {
                propertyURL = loaderClass.getResource("/" + propertyFilename);
            }
            if ((loaderClassURL = loaderClass.getResource(loaderClassResourcename = loaderClass.getName().replaceAll(Pattern.quote(JAVA_PACKAGE_SEPARATOR), "/") + EXTENSION_JAVA_CLASS)) == null) {
                loaderClassURL = loaderClass.getResource("/" + loaderClassResourcename);
            }
            String jarFilenamePropertyFile = propertyURL != null ? Settings.getJarFilename(propertyURL) : null;
            String string = jarFilenameClassResourceFile = loaderClassURL != null ? Settings.getJarFilename(loaderClassURL) : null;
            if (jarFilenamePropertyFile == null) {
                throw new SecurityException("property file '" + propertyFilename + "' not found in jar");
            }
            if (jarFilenameClassResourceFile == null) {
                throw new SecurityException("class file '" + loaderClass.getName() + "' (Resource: '" + loaderClassResourcename + "') not found in jar");
            }
            if (!jarFilenamePropertyFile.equals(jarFilenameClassResourceFile)) {
                throw new SecurityException("property file '" + propertyFilename + "' and class file '" + loaderClass.getName() + "' (Resource: '" + loaderClassResourcename + "') expected to be found at same jar");
            }
            String base64HashPropertyFile = null;
            try {
                LOGGER.debug((Object)"OCFProvider.secureLoadProperties hash search (default)");
                try (JarFile jarFile = new JarFile(jarFilenamePropertyFile, true);){
                    Properties properties;
                    block45: {
                        JarEntry jarEntry;
                        JarEntry zipEntry = jarEntry = jarFile.getJarEntry(propertyFilename);
                        base64HashPropertyFile = jarEntry.getAttributes().getValue(digestAlgorithmName + MANIFEST_DIGEST_ATTRIBUTE_SUFFIX);
                        InputStream jis = jarFile.getInputStream(zipEntry);
                        try {
                            Properties result = Settings.readSettingsXml(propertyFilename, digestAlgorithmName, jis, base64HashPropertyFile);
                            LOGGER.debug((Object)("OCFProvider.secureLoadProperties hash found (default): " + (base64HashPropertyFile != null)));
                            properties = result;
                            if (jis == null) break block45;
                        }
                        catch (Throwable throwable) {
                            if (jis != null) {
                                try {
                                    jis.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        jis.close();
                    }
                    return properties;
                }
            }
            catch (Throwable e1) {
                LOGGER.debug((Object)"OCFProvider.secureLoadProperties alternative hash search", e1);
                if (loaderClassURL.toString().contains("http")) {
                    try {
                        LOGGER.debug((Object)("OCFProvider.secureLoadProperties manifest search (JWS) - " + OCFProvider.class.getProtectionDomain().getCodeSource().getLocation()));
                        LOGGER.debug((Object)"OCFProvider.secureLoadProperties hash search (JWS)");
                        Manifest m = null;
                        try (JarInputStream jis = new JarInputStream(OCFProvider.class.getProtectionDomain().getCodeSource().getLocation().openStream());){
                            m = jis.getManifest();
                        }
                        LOGGER.debug((Object)("OCFProvider.secureLoadProperties manifest found (JWS): " + (m != null)));
                        Attributes as = m.getEntries().get(propertyFilename);
                        base64HashPropertyFile = as.get(new Attributes.Name(digestAlgorithmName + MANIFEST_DIGEST_ATTRIBUTE_SUFFIX)).toString();
                        LOGGER.debug((Object)("OCFProvider.secureLoadProperties (JWS) hash found: " + (base64HashPropertyFile != null)));
                        try (InputStream urlis = propertyURL.openStream();){
                            Properties properties = Settings.readSettingsXml(propertyFilename, digestAlgorithmName, urlis, base64HashPropertyFile);
                            return properties;
                        }
                    }
                    catch (Throwable e2) {
                        LOGGER.debug((Object)("OCFProvider.secureLoadProperties alternative hash search failed: " + loaderClassURL.toString()), e2);
                        try (InputStream urlis = propertyURL.openStream();){
                            Properties properties = Settings.readSettingsXml(propertyFilename, digestAlgorithmName, urlis, base64HashPropertyFile);
                            return properties;
                        }
                    }
                }
                LOGGER.debug((Object)("OCFProvider.secureLoadProperties alternative hash search failed (no JWS): " + loaderClassURL.toString()));
                try (InputStream urlis = propertyURL.openStream();){
                    Properties properties = Settings.readSettingsXml(propertyFilename, digestAlgorithmName, urlis, base64HashPropertyFile);
                    return properties;
                }
            }
        }

        private static Properties readSettingsXml(String propertyFilename, String digestAlgorithmName, InputStream is, String base64HashPropertyFile) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, InvalidPropertiesFormatException {
            if (StringUtil.isNullOrEmpty(base64HashPropertyFile)) {
                throw new SecurityException("invalid signature of properties, no hash value found at manifest with " + digestAlgorithmName + " for " + propertyFilename);
            }
            Properties result = new Properties();
            MessageDigest md = MessageDigest.getInstance(digestAlgorithmName, OCFProvider.EXTERNAL_PROVIDER_NAME);
            try (InputStream iis = is;){
                Properties properties;
                try (DigestInputStream dis = new DigestInputStream(iis, md);){
                    if (propertyFilename.endsWith(EXTENSION_PROPERTIES_DEFAULT)) {
                        result.load(dis);
                    } else if (propertyFilename.endsWith(EXTENSION_PROPERTIES_XML)) {
                        result.loadFromXML(dis);
                    }
                    if (base64HashPropertyFile != null && !Arrays.equals(Base64.decode((String)base64HashPropertyFile), md.digest())) {
                        throw new SecurityException("invalid signature of properties");
                    }
                    properties = result;
                }
                return properties;
            }
        }

        public synchronized Properties getProperties() {
            return this.properties;
        }
    }
}

