/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.basecard.common.crypto.Algorithm;
import de.bos_bremen.basecard.common.crypto.AlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.DelegatingAlgorithmProvider;
import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.PinDeactivatedException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OCFPrivateKey
implements RSAPrivateKey,
DelegatingAlgorithmProvider<OCFPrivateKey> {
    private static final Log log = LogFactory.getLog(OCFPrivateKey.class);
    static final long serialVersionUID = -4298100515446427749L;
    private final transient GovCS cs;
    private final String algorithm;
    private char[] pin = null;
    private final transient OCFCertificateInfo info;
    private final BigInteger modulus;

    public OCFPrivateKey(GovCS _cs, OCFCertificateInfo _info, BigInteger _modulus) {
        this.cs = _cs;
        this.info = _info;
        this.algorithm = _info.getX509Certificate() != null && _info.getX509Certificate().getPublicKey() != null ? _info.getX509Certificate().getPublicKey().getAlgorithm() : "RSA";
        this.modulus = _modulus;
        log.debug((Object)("MODULUS : " + this.getModulus()));
    }

    public OCFPrivateKey(GovCS _cs, OCFCertificateInfo _info) {
        this(_cs, _info, null);
    }

    void setPIN(char[] _pin) {
        if (_pin == null) {
            return;
        }
        this.pin = new char[_pin.length];
        System.arraycopy(_pin, 0, this.pin, 0, this.pin.length);
    }

    char[] getPIN() {
        if (this.pin == null) {
            return null;
        }
        char[] result = new char[this.pin.length];
        System.arraycopy(this.pin, 0, result, 0, result.length);
        return result;
    }

    public void resetPIN() {
        if (this.pin != null) {
            for (int i = 0; i < this.pin.length; ++i) {
                this.pin[i] = '\u0000';
            }
            this.pin = null;
        }
        log.debug((Object)("cs : " + this.cs));
        if (this.cs != null) {
            this.cs.reset();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    public int getRetryCount() throws NotYetInitializedException, RetryCounterExpiredException, PinDeactivatedException {
        return this.cs.getRetryCount(this.info);
    }

    public OCFCertificateInfo getOCFCertificatInfo() {
        return this.info;
    }

    @Override
    public BigInteger getPrivateExponent() {
        throw new UnsupportedOperationException("private key not available at the moment!");
    }

    @Override
    public BigInteger getModulus() {
        if (this.modulus != null) {
            return BigInteger.valueOf(this.modulus.bitLength() / 8);
        }
        return null;
    }

    public GovCS getCardService() {
        return this.cs;
    }

    public String getIndentifier() {
        return this.cs.getIndentifier();
    }

    @Deprecated
    public int getKeyUsage() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getCardUsage();
    }

    public String toString() {
        return "OCFPrivateKey[cs= " + this.cs + ", alg=" + this.algorithm + "]";
    }

    @Override
    public List<Algorithm<OCFPrivateKey, ?>> getAlgorithms() {
        return this.getOCFCertificatInfo().getKey().getAlgorithms();
    }

    @Override
    public List<Algorithm<OCFPrivateKey, ?>> getAlgorithms(UsageRelated.Usage usage) throws IllegalArgumentException {
        return this.getOCFCertificatInfo().getKey().getAlgorithms(usage);
    }

    @Override
    public Algorithm<OCFPrivateKey, ?> getRecommendedAlgorithm(UsageRelated.Usage usage) throws IllegalArgumentException {
        return this.getOCFCertificatInfo().getKey().getRecommendedAlgorithm(usage);
    }

    @Override
    public <S extends CardExecutionParameterSpec> Algorithm<OCFPrivateKey, S> getRecommendedAlgorithm(UsageRelated.Usage usage, Class<S> specClass) throws IllegalArgumentException {
        return this.getOCFCertificatInfo().getKey().getRecommendedAlgorithm(usage, specClass);
    }

    @Override
    public String getRelatedProviderName() {
        return this.getOCFCertificatInfo().getKey().getRelatedProviderName();
    }

    @Override
    public boolean isSignatureRelated() {
        return this.getOCFCertificatInfo().getKey().isSignatureRelated();
    }

    @Override
    public boolean isAuthenticationRelated() {
        return this.getOCFCertificatInfo().getKey().isAuthenticationRelated();
    }

    @Override
    public boolean isDecryptionRelated() {
        return this.getOCFCertificatInfo().getKey().isDecryptionRelated();
    }

    @Override
    public List<UsageRelated.Usage> getUsageList() {
        return this.getOCFCertificatInfo().getKey().getUsageList();
    }

    @Override
    public AlgorithmProvider<OCFPrivateKey> getAlgorithmProvider() {
        return this.getOCFCertificatInfo().getKey();
    }

    @Override
    public void setAlgorithmProvider(AlgorithmProvider<OCFPrivateKey> algorithmProvider) throws IllegalStateException, IllegalArgumentException {
        throw new IllegalStateException("set impossible, provided internally by initializated CardKey");
    }

    @Override
    public Algorithm<OCFPrivateKey, ?> getAlgorithm(UsageRelated.Usage usage, String algorithmName) throws IllegalArgumentException {
        return this.getOCFCertificatInfo().getKey().getAlgorithm(usage, algorithmName);
    }

    @Override
    public boolean isKeyAgreementRelated() {
        return this.getOCFCertificatInfo().getKey().isKeyAgreementRelated();
    }

    @Override
    public boolean isAlgorithmProviderSet() {
        return this.getOCFCertificatInfo().getKey().isAlgorithmProviderSet();
    }
}

