/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.ExtReloadListener;
import de.bos_bremen.gov2.jca_provider.OCFCertificateBag;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import de.bos_bremen.gov2.jca_provider.ReloadListenerAdapter;
import de.bos_bremen.gov2.jca_provider.Reloader;
import de.bos_bremen.gov2.jca_provider.ReloaderCallback;
import de.bos_bremen.gov2.jca_provider.VerifyNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.VerifyPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.VerifyResponseCodeException;
import de.bos_bremen.gov2.jca_provider.VerifyRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.VerifyWrongPINException;
import de.bos_bremen.gov2.jca_provider.ocf.CardTerminalManager;
import de.bos_bremen.gov2.jca_provider.ocf.JPCSCUpdatePollable;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUCommands;
import de.bos_bremen.gov2.jca_provider.ocf.cards.APDUErrorConstants;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCSListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.TerminalListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.Pollable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OCFKeyStore
extends KeyStoreSpi
implements APDUErrorConstants,
Reloader {
    private static final Log log = LogFactory.getLog(OCFKeyStore.class);
    private static CardTerminalManager ctm = null;
    private static final Hashtable<String, OCFCertificateBag> certificateBags = new Hashtable();
    private static final GovCSHandler govCSHandler = new GovCSHandler();
    private static final ProgressSessionHandler progressSessionHandler = new ProgressSessionHandler();
    private static final Vector callbacks = new Vector();
    private static ReloadListener defaultReloadListener;

    public OCFKeyStore() {
        JPCSCUpdatePollable.setCurrentKeyStore(this);
    }

    private OCFCertificateBag getCertificateBag(String _alias) {
        return certificateBags.get(_alias);
    }

    @Override
    public Key engineGetKey(String alias, char[] _pin) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        if (alias == null) {
            return null;
        }
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag == null || !bag.isKeyEntry()) {
            return null;
        }
        OCFPrivateKey privateKey = bag.getPrivateKey();
        if (_pin != null) {
            GovCS cs = privateKey.getCardService();
            try {
                int returnCode = cs.verifyPassword(privateKey.getOCFCertificatInfo(), _pin);
                if (returnCode != 36864) {
                    throw new UnrecoverableKeyException(APDUCommands.getVerifyErrorMsg(returnCode));
                }
                privateKey.setPIN(_pin);
            }
            catch (InvalidCardChannelException ex) {
                throw new UnrecoverableKeyException("can't execute get key operation: card communication failed");
            }
            catch (PinInputTooShortException ex) {
                VerifyPINInputCancelledException e = new VerifyPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (PinInputTooLongException ex) {
                VerifyPINInputCancelledException e = new VerifyPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (PinInputTimeoutException ex) {
                VerifyPINInputCancelledException e = new VerifyPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (RetryCounterExpiredException ex) {
                VerifyRetryCounterExpiredException e = new VerifyRetryCounterExpiredException(ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (WrongPinException ex) {
                VerifyWrongPINException e = new VerifyWrongPINException(ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (NotYetInitializedException ex) {
                VerifyNotYetInitializedException e = new VerifyNotYetInitializedException(ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (PinInputCancelledException ex) {
                VerifyPINInputCancelledException e = new VerifyPINInputCancelledException(ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (OperationCancelledException ex) {
                VerifyPINInputCancelledException e = new VerifyPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (ResponseCodeException ex) {
                VerifyResponseCodeException e = new VerifyResponseCodeException(ex);
                e.setStackTrace(ex.getStackTrace());
                throw e;
            }
            catch (CardTerminalException ex) {
                throw new UnrecoverableKeyException("can't execute get key operation, terminal failed");
            }
        }
        return privateKey;
    }

    @Override
    public int engineSize() {
        return certificateBags.size();
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert == null) {
            return null;
        }
        Enumeration<OCFCertificateBag> e = certificateBags.elements();
        while (e.hasMoreElements()) {
            OCFCertificateBag bag = e.nextElement();
            if (!cert.equals(bag.getCertificate())) continue;
            return bag.getAlias();
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String parm1, byte[] _pin, Certificate[] parm3) throws KeyStoreException {
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag != null) {
            return bag.isCertificateEntry();
        }
        return false;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
    }

    private String getIssuer(Certificate certificate) {
        return X509Certificate.class.isInstance(certificate) ? ((X509Certificate)certificate).getIssuerDN().toString() : "";
    }

    private String getSubject(Certificate certificate) {
        return X509Certificate.class.isInstance(certificate) ? ((X509Certificate)certificate).getSubjectDN().toString() : "";
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        OCFCertificateInfo info;
        int i;
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag == null) {
            return null;
        }
        ArrayList<X509Certificate> resultList = new ArrayList<X509Certificate>();
        if (bag.getPrivateKey() == null) {
            return null;
        }
        GovCS cs = bag.getPrivateKey().getCardService();
        OCFCertificateInfo[] infos = cs.getAllCertificates();
        Certificate tmpCert = bag.getCertificate();
        String issuer = this.getIssuer(tmpCert);
        resultList.add((X509Certificate)tmpCert);
        if (issuer.equals(this.getSubject(tmpCert))) {
            issuer = null;
        }
        for (i = 0; issuer != null && issuer.length() > 0 && i < infos.length; ++i) {
            info = infos[i];
            if (info.getAlias() == null || info.getChainEntry() != OCFCertificateInfo.ChainEntry.CA || (tmpCert = this.engineGetCertificate(info.getAlias())) == null || !issuer.equals(this.getSubject(tmpCert))) continue;
            issuer = this.getIssuer(tmpCert);
            resultList.add((X509Certificate)tmpCert);
            i = -1;
            if (!issuer.equals(this.getSubject(tmpCert))) continue;
            issuer = null;
            break;
        }
        for (i = 0; issuer != null && issuer.length() > 0 && i < infos.length; ++i) {
            info = infos[i];
            if (info.getAlias() == null || info.getChainEntry() != OCFCertificateInfo.ChainEntry.ROOT || (tmpCert = this.engineGetCertificate(info.getAlias())) == null || !issuer.equals(this.getIssuer(tmpCert))) continue;
            log.debug((Object)("found root : " + info.getAlias()));
            issuer = this.getIssuer(tmpCert);
            resultList.add((X509Certificate)tmpCert);
            break;
        }
        return resultList.toArray(new Certificate[resultList.size()]);
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag != null) {
            return bag.getCertificate();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream parm1, char[] _pin) throws NoSuchAlgorithmException, CertificateException {
        Class<OCFKeyStore> clazz = OCFKeyStore.class;
        synchronized (OCFKeyStore.class) {
            OCFKeyStoreListener l;
            Properties p;
            ReloadListener reloadListener;
            ReloaderCallback reloadCallback;
            if (parm1 != null && !(parm1 instanceof OCFKeyStoreParameterInputStream)) {
                throw new IllegalArgumentException("stream must be of type OCFKeyStoreParameterInputStream");
            }
            OCFKeyStoreParameterInputStream is = null;
            if (parm1 != null && parm1 instanceof OCFKeyStoreParameterInputStream) {
                is = (OCFKeyStoreParameterInputStream)parm1;
            }
            CardListener cl = is != null ? is.getCardListener() : null;
            log.debug((Object)("add cardListener : " + cl));
            if (cl != null) {
                CardObjectRegistryImpl.getInstance().addCardListener(cl);
            }
            TerminalListener tl = is != null ? is.getTerminalListener() : null;
            log.debug((Object)("add terminalListener : " + tl));
            if (tl != null) {
                CardObjectRegistryImpl.getInstance().addTerminalListener(tl);
            }
            ProgressSessionListener sl = is != null ? is.getProgressSessionListener() : null;
            log.debug((Object)("add progressSessionListener : " + sl));
            if (sl != null) {
                progressSessionHandler.addProgressSessionListener(sl);
            }
            ReloaderCallback reloaderCallback = reloadCallback = is != null ? is.getReloaderCallback() : null;
            if (reloadCallback != null) {
                reloadCallback.setReloader(this);
            }
            ReloadListener reloadListener2 = reloadListener = is != null ? is.getDefaultReloadListener() : null;
            if (defaultReloadListener == null) {
                if (reloadListener == null) {
                    reloadListener = ExtReloadListener.DEFAULT;
                }
                defaultReloadListener = reloadListener;
            }
            Properties properties = p = is != null ? is.getOCFProperties() : null;
            if (ctm == null) {
                log.debug((Object)("progressSessionHandler : " + progressSessionHandler));
                ctm = CardTerminalManager.getInstance(p, progressSessionHandler, is != null ? is.getCertLoader() : null);
                if (ctm.isAvailable()) {
                    Vector<GovCS> services = ctm.getConnectedCardServices();
                    int threadCounter = 0;
                    Semaphore semaphore = new Semaphore(0);
                    Iterator it = services.iterator();
                    while (it.hasNext()) {
                        CertificateReader reader = new CertificateReader();
                        reader.govcs = (GovCS)it.next();
                        reader.semaphore = semaphore;
                        reader.start();
                        ++threadCounter;
                    }
                    try {
                        semaphore.acquire(threadCounter);
                    }
                    catch (InterruptedException ex) {
                        log.debug((Object)"", (Throwable)ex);
                    }
                    Object o = is != null ? is.getOwnerWindow() : null;
                    ctm.setParentWindow(o);
                    ctm.addGovCSListener(govCSHandler);
                }
            }
            OCFKeyStoreListener oCFKeyStoreListener = l = is != null ? is.getOCFKeyStoreListener() : null;
            if (l != null && !callbacks.contains(l)) {
                callbacks.add(l);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        throw new UnsupportedOperationException("Method engineGetCreationDate() not yet implemented.");
    }

    public Enumeration engineAliases() {
        return certificateBags.keys();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return certificateBags.containsKey(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag == null || !bag.isKeyEntry()) {
            return;
        }
        try {
            bag.getPrivateKey().resetPIN();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        OCFCertificateBag bag = this.getCertificateBag(alias);
        if (bag != null) {
            return bag.isKeyEntry();
        }
        return false;
    }

    @Override
    public void engineSetKeyEntry(String parm1, Key parm2, char[] _pin, Certificate[] parm4) throws KeyStoreException {
    }

    private static void removeCertificate(OCFCertificateBag cb) {
        if (!certificateBags.containsKey(cb.getAlias())) {
            return;
        }
        certificateBags.remove(cb.getAlias());
        Enumeration e = callbacks.elements();
        while (e.hasMoreElements()) {
            OCFKeyStoreListener item = (OCFKeyStoreListener)e.nextElement();
            try {
                item.aliasRemoved(cb.getAlias());
            }
            catch (Throwable ex) {
                log.debug((Object)"", ex);
            }
        }
    }

    private static void addAliasOfGovCS(GovCS _govcs) {
        OCFCertificateBag cb2;
        log.debug((Object)("reading certificates from " + _govcs.getDisplayName()));
        OCFCertificateInfo[] cardCertificates = _govcs.getAllCertificates();
        Vector<OCFCertificateBag> bags = new Vector<OCFCertificateBag>();
        try {
            OCFCertificateInfo cardInfo = new OCFCertificateInfo(_govcs.getCardObject(), OCFCertificateInfo.Usage.UNK, OCFCertificateInfo.ChainEntry.UNKNOWN);
            OCFCertificateBag cardBag = new OCFCertificateBag(_govcs, cardInfo);
            bags.add(cardBag);
        }
        catch (CertificateException cardInfo) {
            // empty catch block
        }
        for (int i = 0; i < cardCertificates.length; ++i) {
            try {
                cb2 = new OCFCertificateBag(_govcs, cardCertificates[i]);
                bags.add(cb2);
                continue;
            }
            catch (CertificateException cb2) {
                continue;
            }
            catch (Throwable ex) {
                log.debug((Object)"", ex);
            }
        }
        log.debug((Object)"post initializing card - start");
        _govcs.postInitializeCard();
        log.debug((Object)"post initializing card - end");
        log.debug((Object)("certificates read from " + _govcs.getDisplayName() + "(" + _govcs.getCardObject().getType() + ") - done"));
        Object iter = bags.iterator();
        while (iter.hasNext()) {
            cb2 = (OCFCertificateBag)iter.next();
            if (certificateBags.containsKey(cb2.getAlias())) {
                iter.remove();
                continue;
            }
            certificateBags.put(cb2.getAlias(), cb2);
        }
        iter = bags.elements();
        while (iter.hasMoreElements()) {
            cb2 = (OCFCertificateBag)iter.nextElement();
            Enumeration e = callbacks.elements();
            while (e.hasMoreElements()) {
                OCFKeyStoreListener l = (OCFKeyStoreListener)e.nextElement();
                try {
                    l.aliasAdded(cb2.getAlias());
                }
                catch (Throwable ex) {
                    log.debug((Object)"", ex);
                }
            }
        }
    }

    private static void removeAliasOfGovCS(GovCS _govcs) {
        try {
            CardTerminal terminal = _govcs.getCardTerminal();
            Enumeration<String> e = certificateBags.keys();
            while (e.hasMoreElements()) {
                Object cardTermcardTerminalReference;
                String alias = e.nextElement();
                OCFCertificateBag cb = certificateBags.get(alias);
                if (cb == null || (cardTermcardTerminalReference = cb.getCardTerminalReference()) == null || !cardTermcardTerminalReference.equals(terminal)) continue;
                OCFKeyStore.removeCertificate(cb);
            }
        }
        catch (Throwable ex) {
            log.fatal((Object)"", ex);
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (ctm == null) {
            return;
        }
        log.debug((Object)"finalizing card terminal manager");
        Enumeration e = this.engineAliases();
        while (e.hasMoreElements()) {
            try {
                this.engineDeleteEntry((String)e.nextElement());
            }
            catch (KeyStoreException keyStoreException) {}
        }
        OCFKeyStore.cleanUpTerminals();
        if (ctm.isAvailable()) {
            ctm.stopSmartCardServices();
            ctm.removeGovCSListener(govCSHandler);
        }
        ctm = null;
        certificateBags.clear();
    }

    private static void cleanUpTerminals() {
        CardTerminalRegistry registry = CardTerminalRegistry.getRegistry();
        for (CardTerminal cardTerminal : Collections.list(registry.getCardTerminals())) {
            try {
                ((CardObjectRegistryImpl)CardObjectRegistryImpl.getInstance()).removeTerminal(cardTerminal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (cardTerminal instanceof Pollable) {
                    registry.removePollable((Pollable)((Object)cardTerminal));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                registry.remove(cardTerminal);
            }
            catch (Throwable throwable) {}
        }
    }

    public void reload() {
        this.reload(defaultReloadListener);
    }

    @Override
    public void reload(ReloadListener listener) {
        try {
            this.reload(new ReloadListenerAdapter(listener));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reload(ReloadListenerAdapter adapter) throws GeneralSecurityException, IOException {
        log.debug((Object)"MCard/OCF - reload begin");
        try {
            adapter.reloadStarted();
            log.debug((Object)"keystore store (OCF shutdown) - begin");
            this.engineStore(null, null);
            log.debug((Object)"keystore store (OCF shutdown) - end");
            adapter.keyStoreCleanedUp();
            log.debug((Object)"keystore load (OCF start) - begin");
            this.engineLoad(null, null);
        }
        finally {
            log.info((Object)"keystore load (OCF start) - end");
            adapter.reloadFinished();
            log.info((Object)"MCard/OCF reload - end");
        }
    }

    private static final class CertificateReader
    extends Thread {
        private GovCS govcs = null;
        private Semaphore semaphore = null;

        private CertificateReader() {
        }

        @Override
        public void run() {
            log.debug((Object)("started for " + this.govcs.getCardTerminal().getName()));
            try {
                OCFKeyStore.addAliasOfGovCS(this.govcs);
            }
            catch (Throwable ex) {
                log.debug((Object)"", ex);
            }
            finally {
                log.debug((Object)("finished for " + this.govcs.getCardTerminal().getName()));
                this.semaphore.release();
            }
        }
    }

    private static class ProgressSessionHandler
    implements ProgressSessionListener {
        private final Vector progressSessionListeners = new Vector();

        private ProgressSessionHandler() {
        }

        public void addProgressSessionListener(ProgressSessionListener _l) {
            if (this.progressSessionListeners.contains(_l)) {
                return;
            }
            this.progressSessionListeners.add(_l);
        }

        public void removeProgressSessionListener(ProgressSessionListener _l) {
            if (!this.progressSessionListeners.contains(_l)) {
                return;
            }
            this.progressSessionListeners.remove(_l);
        }

        @Override
        public void progressSessionWillStart(ProgressSession _session) {
            for (ProgressSessionListener item : this.progressSessionListeners) {
                item.progressSessionWillStart(_session);
            }
        }

        @Override
        public void progressSessionStarted(ProgressSession _session) {
            for (ProgressSessionListener item : this.progressSessionListeners) {
                item.progressSessionStarted(_session);
            }
        }

        @Override
        public void progressSessionUpdate(ProgressSession _session) {
            for (ProgressSessionListener item : this.progressSessionListeners) {
                item.progressSessionUpdate(_session);
            }
        }

        @Override
        public void progressSessionWillStop(ProgressSession _session) {
            for (ProgressSessionListener item : this.progressSessionListeners) {
                item.progressSessionWillStop(_session);
            }
        }

        @Override
        public void progressSessionStopped(ProgressSession _session) {
            for (ProgressSessionListener item : this.progressSessionListeners) {
                item.progressSessionStopped(_session);
            }
        }
    }

    private static final class GovCSHandler
    implements GovCSListener {
        private GovCSHandler() {
        }

        @Override
        public void cardServiceAdded(GovCS _cs) {
            OCFKeyStore.addAliasOfGovCS(_cs);
        }

        @Override
        public void cardServiceRemoved(GovCS _cs) {
            OCFKeyStore.removeAliasOfGovCS(_cs);
        }
    }
}

