/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.KeyAgreementException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementResponseCodeException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.KeyAgreementWrongPINException;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import opencard.core.service.InvalidCardChannelException;
import org.bouncycastle.jce.provider.JCEECPublicKey;

public class OCFKeyAgreement
extends KeyAgreementSpi {
    private OCFPrivateKey privateKey = null;
    private byte[] foreignPublicKey = null;
    private final AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OCFSIGN", "OCF");

    @Override
    protected Key engineDoPhase(Key foreignPublic, boolean last) throws InvalidKeyException, IllegalStateException, IllegalArgumentException {
        AssertUtil.notNull(foreignPublic, "public key");
        if (this.foreignPublicKey != null) {
            throw new IllegalStateException("foreign key already given");
        }
        if (!last) {
            throw new IllegalArgumentException("only one foreign key accepted");
        }
        if (!(foreignPublic instanceof ECPublicKey)) {
            throw new InvalidKeyException("only ECPublicKey accepted");
        }
        this.foreignPublicKey = new JCEECPublicKey((ECPublicKey)foreignPublic).getQ().getEncoded(false);
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("not yet initialized");
        }
        if (this.foreignPublicKey == null) {
            throw new IllegalStateException("not yet initialized");
        }
        GovCS cs = this.privateKey.getCardService();
        GovCS.ResultObject ro = null;
        try {
            ro = cs.decrypt(this.privateKey.getOCFCertificatInfo(), this.foreignPublicKey, this.privateKey.getPIN(), this.algorithmParameters);
        }
        catch (InvalidCardChannelException ex) {
            throw new KeyAgreementException("can't execute decrypt operation: card communication failed");
        }
        catch (PinInputTooShortException ex) {
            KeyAgreementPINInputCancelledException e = new KeyAgreementPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTooLongException ex) {
            KeyAgreementPINInputCancelledException e = new KeyAgreementPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTimeoutException ex) {
            KeyAgreementPINInputCancelledException e = new KeyAgreementPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (RetryCounterExpiredException ex) {
            KeyAgreementRetryCounterExpiredException e = new KeyAgreementRetryCounterExpiredException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (WrongPinException ex) {
            KeyAgreementWrongPINException e = new KeyAgreementWrongPINException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (NotYetInitializedException ex) {
            KeyAgreementNotYetInitializedException e = new KeyAgreementNotYetInitializedException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputCancelledException ex) {
            KeyAgreementPINInputCancelledException e = new KeyAgreementPINInputCancelledException(ex);
            e.setStackTrace(e.getStackTrace());
            throw e;
        }
        catch (OperationCancelledException ex) {
            KeyAgreementPINInputCancelledException e = new KeyAgreementPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (ResponseCodeException ex) {
            KeyAgreementResponseCodeException e = new KeyAgreementResponseCodeException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (ro == null) {
            throw new KeyAgreementException("can't execute decrypt operation");
        }
        return (byte[])ro.getResultData();
    }

    @Override
    protected SecretKey engineGenerateSecret(String arg0) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGenerateSecret(byte[] arg0, int arg1) throws IllegalStateException, ShortBufferException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(Key privateKey, SecureRandom sr) throws InvalidKeyException {
        if (!(privateKey instanceof OCFPrivateKey)) {
            throw new InvalidKeyException("must be an OCF private key");
        }
        this.privateKey = (OCFPrivateKey)privateKey;
        X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
        if (c.getKeyUsage() == null) {
            throw new InvalidKeyException("no key usage available");
        }
        if (!(c.getKeyUsage()[2] || c.getKeyUsage()[3] || c.getKeyUsage()[4])) {
            throw new InvalidKeyException("wrong key usage");
        }
        this.foreignPublicKey = null;
    }

    @Override
    protected void engineInit(Key privateKey, AlgorithmParameterSpec spec, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(privateKey, sr);
        try {
            this.algorithmParameters.init(spec);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }
}

