/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.basecard.common.crypto.UsageRelated;
import de.bos_bremen.gov2.jca_provider.CipherNotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.CipherPINInputCancelledException;
import de.bos_bremen.gov2.jca_provider.CipherResponseCodeException;
import de.bos_bremen.gov2.jca_provider.CipherRetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.CipherWrongPINException;
import de.bos_bremen.gov2.jca_provider.OCFAlgorithmParameters;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.NotYetInitializedException;
import de.bos_bremen.gov2.jca_provider.ocf.OperationCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputCancelledException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTimeoutException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooLongException;
import de.bos_bremen.gov2.jca_provider.ocf.PinInputTooShortException;
import de.bos_bremen.gov2.jca_provider.ocf.ResponseCodeException;
import de.bos_bremen.gov2.jca_provider.ocf.RetryCounterExpiredException;
import de.bos_bremen.gov2.jca_provider.ocf.WrongPinException;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import opencard.core.service.InvalidCardChannelException;

public class OCFCipher
extends CipherSpi {
    private static final String DEFAULT_RSA_ALGORITHM_COMPLETION = "/ECB/PKCS1Padding";
    private OCFPrivateKey privateKey = null;
    private ByteArrayOutputStream baos = null;
    private String algorithm = "RSA";
    private AlgorithmParameters algorithmParameters;

    @Override
    protected void engineInit(int _mode, Key _privateKey, AlgorithmParameterSpec _params, SecureRandom _random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(_mode, _privateKey, _random);
    }

    @Override
    protected int engineDoFinal(byte[] parm1, int parm2, int parm3, byte[] parm4, int parm5) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new UnsupportedOperationException("Method engineDoFinal() not yet implemented.");
    }

    @Override
    protected void engineInit(int _mode, Key _privateKey, SecureRandom _secureRandom) throws InvalidKeyException {
        if (!(_privateKey instanceof OCFPrivateKey)) {
            throw new InvalidKeyException("must be an OCF private key");
        }
        this.privateKey = (OCFPrivateKey)_privateKey;
        X509Certificate c = this.privateKey.getOCFCertificatInfo().getX509Certificate();
        if (c.getKeyUsage() == null) {
            throw new InvalidKeyException("no key usage available");
        }
        if (!(c.getKeyUsage()[2] || c.getKeyUsage()[3] || c.getKeyUsage()[4])) {
            throw new InvalidKeyException("wrong key usage");
        }
        if ("RSA".equals(this.algorithm)) {
            this.algorithm = this.algorithm + DEFAULT_RSA_ALGORITHM_COMPLETION;
        }
        try {
            this.algorithmParameters = OCFAlgorithmParameters.getInstance(this.algorithm, this.privateKey.getAlgorithm(UsageRelated.Usage.CIPHER, this.algorithm).getAlgorithmParameterSpec());
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeyException("failed initializing parameter spec: " + e.getMessage(), e);
        }
        this.baos = new ByteArrayOutputStream();
    }

    @Override
    protected void engineSetMode(String blockMode) throws NoSuchAlgorithmException {
        this.algorithm = this.algorithm + "/" + blockMode;
    }

    @Override
    protected byte[] engineDoFinal(byte[] bytes, int offset, int length) throws IllegalBlockSizeException, BadPaddingException {
        if (bytes != null) {
            this.baos.write(bytes, offset, length);
        }
        GovCS cs = this.privateKey.getCardService();
        GovCS.ResultObject ro = null;
        try {
            ro = cs.decrypt(this.privateKey.getOCFCertificatInfo(), this.baos.toByteArray(), this.privateKey.getPIN(), this.algorithmParameters);
        }
        catch (InvalidCardChannelException ex) {
            throw new BadPaddingException("can't execute decrypt operation: card communication failed");
        }
        catch (PinInputTooShortException ex) {
            CipherPINInputCancelledException e = new CipherPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTooLongException ex) {
            CipherPINInputCancelledException e = new CipherPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputTimeoutException ex) {
            CipherPINInputCancelledException e = new CipherPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (RetryCounterExpiredException ex) {
            CipherRetryCounterExpiredException e = new CipherRetryCounterExpiredException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (WrongPinException ex) {
            CipherWrongPINException e = new CipherWrongPINException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (NotYetInitializedException ex) {
            CipherNotYetInitializedException e = new CipherNotYetInitializedException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (PinInputCancelledException ex) {
            CipherPINInputCancelledException e = new CipherPINInputCancelledException(ex);
            e.setStackTrace(e.getStackTrace());
            throw e;
        }
        catch (OperationCancelledException ex) {
            CipherPINInputCancelledException e = new CipherPINInputCancelledException(ex.getPasswordName(), ex.getErrorCode(), ex.getMessage(), ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        catch (ResponseCodeException ex) {
            CipherResponseCodeException e = new CipherResponseCodeException(ex);
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (ro == null) {
            throw new BadPaddingException("can't execute decrypt operation");
        }
        return (byte[])ro.getResultData();
    }

    @Override
    protected byte[] engineGetIV() {
        throw new UnsupportedOperationException("Method engineGetIV() not yet implemented.");
    }

    @Override
    protected void engineInit(int parm1, Key parm2, AlgorithmParameters parm3, SecureRandom parm4) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(parm1, parm2, parm4);
    }

    @Override
    protected byte[] engineUpdate(byte[] bytes, int offset, int length) {
        this.baos.write(bytes, offset, length);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] parm1, int parm2, int parm3, byte[] parm4, int parm5) throws ShortBufferException {
        throw new UnsupportedOperationException("Method engineUpdate() not yet implemented.");
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.algorithm = this.algorithm + "/" + padding;
    }

    @Override
    protected int engineGetOutputSize(int parm1) {
        throw new UnsupportedOperationException("Method engineGetOutputSize() not yet implemented.");
    }

    @Override
    protected int engineGetBlockSize() {
        throw new UnsupportedOperationException("Method engineGetBlockSize() not yet implemented.");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.algorithmParameters;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return ((OCFPrivateKey)key).getModulus().bitLength();
    }
}

