/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.common.crypto.ECDSASignatureConverter;
import de.bos_bremen.gov2.jca_provider.OCFPrivateKey;
import de.bos_bremen.gov2.jca_provider.ocf.OCFCertificateInfo;
import de.bos_bremen.gov2.jca_provider.ocf.cards.GovCS;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;

public class OCFCertificateBag {
    public static final String GLOBAL_CARD_KEY_PREFIX = "card_at_terminal_'";
    public static final int KEY_USAGE_DIGITAL_SIGNATURE = 0;
    public static final int KEY_USAGE_NONE_REPUDIATION = 1;
    public static final int KEY_USAGE_KEY_ENCIPHERMENT = 2;
    public static final int KEY_USAGE_DATA_ENCIPHERMENT = 3;
    public static final int KEY_USAGE_KEY_AGREEMENT = 4;
    public static final int KEY_USAGE_CRL_SIGN = 5;
    public static final int KEY_USAGE_ENCIPHER_ONLY = 6;
    public static final int KEY_USAGE_DECIPHER_ONLY = 7;
    private String alias = null;
    private X509Certificate certificate = null;
    private OCFPrivateKey privateKey = null;
    private boolean keyEntry = false;
    private Object cardTerminalReference = null;

    public OCFCertificateBag(GovCS _cs, OCFCertificateInfo ocfCert) throws CertificateException {
        BigInteger modulus;
        boolean[] ku;
        this.cardTerminalReference = _cs.getCardTerminal();
        this.certificate = ocfCert.getX509Certificate();
        boolean[] blArray = ku = this.certificate != null ? this.certificate.getKeyUsage() : null;
        if (ku == null) {
            ku = new boolean[9];
        }
        if (this.certificate != null) {
            this.alias = this.certificate.getSubjectDN().getName();
            if (ku[1]) {
                this.alias = this.alias + ", signature";
            }
            if (ku[2] || ku[3]) {
                this.alias = this.alias + ", encryption";
            }
            if (ku[0]) {
                this.alias = this.alias + ", authentification";
            }
            this.alias = this.alias + ", " + this.certificate.getSerialNumber();
            this.alias = this.alias + ", " + ocfCert.getNameString();
        } else {
            this.alias = GLOBAL_CARD_KEY_PREFIX + _cs.getCardTerminal().getName() + "'_at_slot_'" + _cs.getSlotID() + "'";
        }
        ocfCert.setAlias(this.alias);
        this.alias = ocfCert.getAlias();
        PublicKey pubKey = this.certificate != null ? this.certificate.getPublicKey() : null;
        RSAPublicKey rsapk = RSAPublicKey.class.isInstance(pubKey) ? (RSAPublicKey)pubKey : null;
        ECPublicKey ecpk = ECPublicKey.class.isInstance(pubKey) ? (ECPublicKey)pubKey : null;
        BigInteger bigInteger = modulus = rsapk != null ? rsapk.getModulus() : null;
        if (ecpk != null) {
            modulus = BigInteger.valueOf(ECDSASignatureConverter.getIntegerEncodingLength(ecpk));
        }
        this.privateKey = new OCFPrivateKey(_cs, ocfCert, modulus);
        ocfCert.setCertificateBag(this);
        ocfCert.init();
        this.keyEntry = ocfCert.getKeyID() != null || ocfCert.getPinID() != 0;
    }

    public String getAlias() {
        return this.alias;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public OCFPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isKeyEntry() {
        return this.keyEntry;
    }

    public boolean isCertificateEntry() {
        return this.certificate != null;
    }

    public Object getCardTerminalReference() {
        return this.cardTerminalReference;
    }
}

