/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptECParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardExecutionSignAuthenticateParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardUserDecryptECParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardUserDecryptRSAParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardUserParameterSpec;
import de.bos_bremen.basecard.common.crypto.CardUserSignAuthenticateParameterSpec;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.gov2.jca_provider.OCFInfoHolderParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;

public class OCFAlgorithmParametersSpi<E extends CardExecutionParameterSpec, U extends CardUserParameterSpec>
extends AlgorithmParametersSpi {
    private final CardUserParameterSpec cardUserParameterSpec;
    private E cardExecutionParameterSpec;
    private final Class<E> cardExecutionParameterSpecClass;
    private final Class<U> cardUserParameterSpecClass;
    private final OCFInfoHolderParameterSpec holderParameterSpec;

    OCFAlgorithmParametersSpi(Class<E> cardExecutionParameterSpecClass, Class<U> cardUserParameterSpecClass, U cardUserParameterSpec) throws IllegalArgumentException {
        this(cardExecutionParameterSpecClass, cardUserParameterSpecClass, cardUserParameterSpec, null);
    }

    OCFAlgorithmParametersSpi(Class<E> cardExecutionParameterSpecClass, Class<U> cardUserParameterSpecClass, U cardUserParameterSpec, List<Class<? extends AlgorithmParameterSpec>> listSpecClasses) throws IllegalArgumentException {
        AssertUtil.notNull(cardExecutionParameterSpecClass, "CardExcectionParameterSpec-Class");
        AssertUtil.notNull(cardUserParameterSpecClass, "CardUserParameterSpec-Class");
        AssertUtil.notNull(cardUserParameterSpec, "CardUserParameterSpec");
        this.cardExecutionParameterSpecClass = cardExecutionParameterSpecClass;
        this.cardUserParameterSpecClass = cardUserParameterSpecClass;
        this.cardUserParameterSpec = cardUserParameterSpec;
        ArrayList<Class<? extends AlgorithmParameterSpec>> tmp = new ArrayList<Class<? extends AlgorithmParameterSpec>>();
        if (listSpecClasses != null) {
            tmp.addAll(listSpecClasses);
        }
        if (!tmp.contains(this.cardUserParameterSpecClass)) {
            tmp.add(0, this.cardUserParameterSpecClass);
        }
        if (!tmp.contains(this.cardExecutionParameterSpecClass)) {
            tmp.add(1, this.cardExecutionParameterSpecClass);
        }
        this.holderParameterSpec = new OCFInfoHolderParameterSpec(tmp);
    }

    @Override
    protected synchronized void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (this.cardExecutionParameterSpec != null) {
            throw new InvalidParameterSpecException("Parameters Specs completely initialized");
        }
        if (CardUserParameterSpec.class.isInstance(paramSpec)) {
            throw new InvalidParameterSpecException("CardUserParameterSpec internally prepared, not settable from external");
        }
        if (this.cardExecutionParameterSpecClass.isInstance(paramSpec)) {
            if (this.cardExecutionParameterSpec != null) {
                throw new InvalidParameterSpecException("CardExecutionParameterSpec already initialized");
            }
            this.cardExecutionParameterSpec = (CardExecutionParameterSpec)this.cardExecutionParameterSpecClass.cast(paramSpec);
        }
    }

    @Override
    protected final void engineInit(byte[] params) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == null) {
            throw new InvalidParameterSpecException("not supported parameter spec: null, only supported: " + this.holderParameterSpec.getSupportedAlgorithmParameterSpecClasses().toString());
        }
        if (paramSpec.equals(OCFInfoHolderParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.holderParameterSpec));
        }
        if (paramSpec.isInstance(this.cardExecutionParameterSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.cardExecutionParameterSpec));
        }
        if (paramSpec.isInstance(this.cardUserParameterSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.cardUserParameterSpec));
        }
        throw new InvalidParameterSpecException("not supported parameter spec: " + paramSpec.getClass().getName() + ", only supported: " + this.holderParameterSpec.getSupportedAlgorithmParameterSpecClasses().toString());
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return ((CardExecutionParameterSpec)this.cardExecutionParameterSpec).getAlgorithmIdentifier().getEncoded();
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        return null;
    }

    @Override
    protected String engineToString() {
        return "OCF Parameters (AlgorithmParameterSpecs: " + this.holderParameterSpec.getSupportedAlgorithmParameterSpecClasses().toString() + ")";
    }

    public static class OCFDecryptECParametersSpi
    extends OCFAlgorithmParametersSpi<CardExecutionDecryptECParameterSpec, CardUserDecryptECParameterSpec> {
        public OCFDecryptECParametersSpi() throws IllegalArgumentException {
            super(CardExecutionDecryptECParameterSpec.class, CardUserDecryptECParameterSpec.class, new CardUserDecryptECParameterSpec());
        }
    }

    public static class OCFDecryptRSAParametersSpi
    extends OCFAlgorithmParametersSpi<CardExecutionDecryptRSAParameterSpec, CardUserDecryptRSAParameterSpec> {
        public OCFDecryptRSAParametersSpi() throws IllegalArgumentException {
            super(CardExecutionDecryptRSAParameterSpec.class, CardUserDecryptRSAParameterSpec.class, new CardUserDecryptRSAParameterSpec());
        }
    }

    public static class OCFSignAuthenticateAlgorithmParametersSpi
    extends OCFAlgorithmParametersSpi<CardExecutionSignAuthenticateParameterSpec, CardUserSignAuthenticateParameterSpec> {
        public OCFSignAuthenticateAlgorithmParametersSpi() throws IllegalArgumentException {
            super(CardExecutionSignAuthenticateParameterSpec.class, CardUserSignAuthenticateParameterSpec.class, new CardUserSignAuthenticateParameterSpec());
        }
    }
}

