/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.gov2.jca_provider;

import de.bos_bremen.gov2.jca_provider.OCFKeyStoreListener;
import de.bos_bremen.gov2.jca_provider.OCFKeyStoreParameterInputStream;
import de.bos_bremen.gov2.jca_provider.ReloadListener;
import de.bos_bremen.gov2.jca_provider.SingleDebugListener;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSession;
import de.bos_bremen.gov2.jca_provider.ocf.ProgressSessionListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardEvent;
import de.bos_bremen.gov2.jca_provider.ocf.model.CardListener;
import de.bos_bremen.gov2.jca_provider.ocf.model.impl.CardObjectRegistryImpl;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.terminal.CardTerminalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FullDebugListener
implements CardListener,
CTListener,
OCFKeyStoreListener,
ProgressSessionListener,
ReloadListener {
    private static final Log LOG = LogFactory.getLog(FullDebugListener.class);
    private final SingleDebugListener afterListener;
    private final SingleDebugListener beforeListener;
    private final CardListener delegateCardListener;
    private final OCFKeyStoreListener delegateOCFKeyStoreListener;
    private final ProgressSessionListener delegateProgressSessionListener;
    private final CTListener delegateCTListener;
    private final ReloadListener delegateReloadListener;

    @Override
    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.beforeListener.cardInserted(ctEvent);
        if (this.delegateCTListener != null) {
            try {
                this.delegateCTListener.cardInserted(ctEvent);
            }
            catch (Exception e) {
                this.handleError(CardListener.class, "cardInserted", e);
            }
        }
        this.afterListener.cardInserted(ctEvent);
    }

    @Override
    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        this.beforeListener.cardRemoved(ctEvent);
        if (this.delegateCTListener != null) {
            try {
                this.delegateCTListener.cardRemoved(ctEvent);
            }
            catch (Exception e) {
                this.handleError(CardListener.class, "cardRemoved", e);
            }
        }
        this.afterListener.cardRemoved(ctEvent);
    }

    public FullDebugListener(OCFKeyStoreParameterInputStream stream, CardListener delegateCardListener, CTListener delegateCTListener, ReloadListener delegateReloadListener) {
        this(stream.getOCFKeyStoreListener(), stream.getProgressSessionListener(), delegateCardListener, delegateCTListener, delegateReloadListener);
        stream.setOCFKeyStoreListener(this);
        stream.setProgressSessionListener(this);
    }

    public FullDebugListener(OCFKeyStoreListener delegateOCFKeyStoreListener, ProgressSessionListener delegateProgressSessionListener, CardListener delegateCardListener, CTListener delegateCTListener, ReloadListener delegateReloadListener) {
        this.delegateOCFKeyStoreListener = delegateOCFKeyStoreListener;
        this.delegateProgressSessionListener = delegateProgressSessionListener;
        this.delegateCardListener = delegateCardListener;
        this.delegateCTListener = delegateCTListener;
        this.delegateReloadListener = delegateReloadListener;
        this.beforeListener = new SingleDebugListener("before");
        this.afterListener = new SingleDebugListener("after");
        EventGenerator.getGenerator().addCTListener(this.beforeListener);
        CardObjectRegistryImpl.getInstance().addCardListener(this.beforeListener);
    }

    public void finishRegistrationAfterMCardStart() {
        EventGenerator.getGenerator().addCTListener(this.afterListener);
        CardObjectRegistryImpl.getInstance().addCardListener(this.afterListener);
    }

    @Override
    public void aliasAdded(String alias) {
        this.beforeListener.aliasAdded(alias);
        if (this.delegateOCFKeyStoreListener != null) {
            try {
                this.delegateOCFKeyStoreListener.aliasAdded(alias);
            }
            catch (Exception e) {
                this.handleError(OCFKeyStoreListener.class, "aliasAdded", e);
            }
        }
        this.afterListener.aliasAdded(alias);
    }

    @Override
    public void aliasRemoved(String alias) {
        this.beforeListener.aliasRemoved(alias);
        if (this.delegateOCFKeyStoreListener != null) {
            try {
                this.delegateOCFKeyStoreListener.aliasRemoved(alias);
            }
            catch (Exception e) {
                this.handleError(OCFKeyStoreListener.class, "aliasRemoved", e);
            }
        }
        this.afterListener.aliasRemoved(alias);
    }

    private void handleError(Class<?> listenerClass, String methodName, Exception e) {
        LOG.error((Object)(listenerClass.getSimpleName() + "." + methodName + " failed: " + e.getMessage()), (Throwable)e);
    }

    @Override
    public void processEvent(CardEvent event) {
        this.beforeListener.processEvent(event);
        if (this.delegateCardListener != null) {
            try {
                this.delegateCardListener.processEvent(event);
            }
            catch (Exception e) {
                this.handleError(CardListener.class, "processEvent", e);
            }
        }
        this.afterListener.processEvent(event);
    }

    @Override
    public void progressSessionStarted(ProgressSession session) {
        this.beforeListener.progressSessionStarted(session);
        if (this.delegateProgressSessionListener != null) {
            try {
                this.delegateProgressSessionListener.progressSessionStarted(session);
            }
            catch (Exception e) {
                this.handleError(ProgressSessionListener.class, "progressSessionStarted", e);
            }
        }
        this.afterListener.progressSessionStarted(session);
    }

    @Override
    public void progressSessionStopped(ProgressSession session) {
        this.beforeListener.progressSessionStopped(session);
        if (this.delegateProgressSessionListener != null) {
            try {
                this.delegateProgressSessionListener.progressSessionStopped(session);
            }
            catch (Exception e) {
                this.handleError(ProgressSessionListener.class, "progressSessionStopped", e);
            }
        }
        this.afterListener.progressSessionStopped(session);
    }

    @Override
    public void progressSessionUpdate(ProgressSession session) {
        this.beforeListener.progressSessionUpdate(session);
        if (this.delegateProgressSessionListener != null) {
            try {
                this.delegateProgressSessionListener.progressSessionUpdate(session);
            }
            catch (Exception e) {
                this.handleError(ProgressSessionListener.class, "progressSessionUpdate", e);
            }
        }
        this.afterListener.progressSessionUpdate(session);
    }

    @Override
    public void progressSessionWillStart(ProgressSession session) {
        this.beforeListener.progressSessionWillStart(session);
        if (this.delegateProgressSessionListener != null) {
            try {
                this.delegateProgressSessionListener.progressSessionWillStart(session);
            }
            catch (Exception e) {
                this.handleError(ProgressSessionListener.class, "progressSessionWillStart", e);
            }
        }
        this.afterListener.progressSessionWillStart(session);
    }

    @Override
    public void progressSessionWillStop(ProgressSession session) {
        this.beforeListener.progressSessionWillStop(session);
        if (this.delegateProgressSessionListener != null) {
            try {
                this.delegateProgressSessionListener.progressSessionWillStop(session);
            }
            catch (Exception e) {
                this.handleError(ProgressSessionListener.class, "progressSessionWillStop", e);
            }
        }
        this.afterListener.progressSessionWillStop(session);
    }

    @Override
    public void keyStoreCleanedUp() {
        this.beforeListener.keyStoreCleanedUp();
        if (this.delegateReloadListener != null) {
            try {
                this.delegateReloadListener.keyStoreCleanedUp();
            }
            catch (Exception e) {
                this.handleError(ReloadListener.class, "keyStoreCleanedUp", e);
            }
        }
        this.afterListener.keyStoreCleanedUp();
    }
}

