/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.system.SystemEnum;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SystemUtil {
    private static final Log LOG = LogFactory.getLog(SystemUtil.class);

    private SystemUtil() {
    }

    public static void loadLibrary(String libname) {
        block4: {
            AssertUtil.notNullOrEmpty(libname, "library name");
            try {
                System.loadLibrary(libname);
            }
            catch (SecurityException e) {
                if (!SystemUtil.tryLoadLib(libname, e)) {
                    throw e;
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (SystemUtil.tryLoadLib(libname, e)) break block4;
                throw e;
            }
        }
    }

    private static boolean tryLoadLib(String libName, Throwable ex) {
        LOG.debug((Object)("error loading library try alternative way, normal loading library failed: " + ex.getMessage()));
        String systemLibName = System.mapLibraryName(libName);
        String path = System.getProperty("java.library.path");
        String delimiter = SystemEnum.getCurrentSystem().getGroup() == SystemEnum.SystemGroup.WINDOWS ? ";" : ":";
        StringTokenizer tokenizer = new StringTokenizer(path, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String fullPath = tokenizer.nextToken() + "/" + systemLibName;
            try {
                System.load(fullPath);
                LOG.debug((Object)("library loaded from successful: " + fullPath));
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                LOG.debug((Object)"failed loading library", (Throwable)e);
            }
            catch (SecurityException e) {
                LOG.debug((Object)"failed loading library", (Throwable)e);
            }
        }
        LOG.debug((Object)"loading library alternative way failed");
        return false;
    }
}

