/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import java.util.Locale;

public final class SystemPropertyUtil {
    public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";
    public static final String SYSTEM_PROPERTY_JAVA_HOME = "java.home";
    public static final String SYSTEM_PROPERTY_JAVA_VERSION = "java.version";
    public static final String SYSTEM_PROPERTY_USER_HOME = "user.home";
    public static final String SYSTEM_PROPERTY_JAVA_LIBRARY_PATH = "java.library.path";
    public static final String SYSTEM_PROPERTY_JAVA_ARCHITECTURE = "sun.arch.data.model";
    public static final String SYSTEM_PROPERTY_JAVA_ARCHITECTURE_VALUE_32BIT = "32";
    public static final String SYSTEM_PROPERTY_JAVA_ARCHITECTURE_VALUE_64BIT = "64";
    public static final String SYSTEM_PROPERTY_USER_LANGUAGE = "user.language";
    public static final String SYSTEM_PROPERTY_USER_LANGUAGE_VALUE_ENGLISH = Locale.ENGLISH.getLanguage();

    private SystemPropertyUtil() {
    }

    public static String getJavaArchitecture() {
        return System.getProperty(SYSTEM_PROPERTY_JAVA_ARCHITECTURE, "");
    }

    public static String getUserHome() {
        return System.getProperty(SYSTEM_PROPERTY_USER_HOME, "");
    }

    public static String getUserLanguage() {
        return System.getProperty(SYSTEM_PROPERTY_USER_LANGUAGE, "");
    }

    public static String getJavaHome() {
        return System.getProperty(SYSTEM_PROPERTY_JAVA_HOME, "");
    }

    public static String getJavaVersion() {
        return System.getProperty(SYSTEM_PROPERTY_JAVA_VERSION, "");
    }

    public static String getJavaLibraryPath() {
        return System.getProperty(SYSTEM_PROPERTY_JAVA_LIBRARY_PATH, "");
    }

    public static String getOSName() {
        return System.getProperty(SYSTEM_PROPERTY_OS_NAME, "");
    }
}

