/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum SystemEnum {
    ALL("all", SystemGroup.ALL),
    WINDOWS_11("Windows 11", SystemGroup.WINDOWS),
    WINDOWS_10("Windows 10", SystemGroup.WINDOWS),
    WINDOWS_8_1("Windows 8.1", SystemGroup.WINDOWS),
    WINDOWS_8("Windows 8", SystemGroup.WINDOWS),
    WINDOWS_7("Windows 7", SystemGroup.WINDOWS),
    WINDOWS_VISTA("Windows Vista", SystemGroup.WINDOWS),
    WINDOWS_XP("Windows XP", SystemGroup.WINDOWS),
    WINDOWS_2000("Windows 2000", SystemGroup.WINDOWS),
    WINDOWS_NT("Windows NT", SystemGroup.WINDOWS),
    WINDOWS_ME("Windows ME", SystemGroup.WINDOWS),
    WINDOWS_98("Windows 98", SystemGroup.WINDOWS),
    WINDOWS_95("Windows 95", SystemGroup.WINDOWS),
    WINDOWS_SERVER_2008("Windows Server 2008", SystemGroup.WINDOWS),
    WINDOWS_SERVER_2003("Windows Server 2003", SystemGroup.WINDOWS),
    WINDOWS_2003_SERVER("Windows 2003 Server", SystemGroup.WINDOWS),
    WINDOWS_SERVER_2012_R2("Windows Server 2012 R2", SystemGroup.WINDOWS),
    WINDOWS_SERVER_2012("Windows Server 2012", SystemGroup.WINDOWS),
    WINDOWS_SERVER_2016("Windows Server 2016", SystemGroup.WINDOWS),
    WINDOWS_UNKNOWN("Windows", SystemGroup.WINDOWS),
    LINUX("Linux", SystemGroup.LINUX),
    MACOS("Mac OS", SystemGroup.MACOS);

    public static final List<Integer> WINDOWS_ALL;
    public static final String SYSTEM_PROPERTY_KEY_OS_NAME = "os.name";
    private String name = null;
    private SystemGroup group = null;

    private SystemEnum(String name, SystemGroup group) {
        this.name = name;
        this.group = group;
    }

    public final String getName() {
        if (this.ordinal() == 0) {
            return SystemEnum.getCurrentSystem().getName();
        }
        return this.name;
    }

    public static SystemEnum getCurrentSystem() {
        String osName = System.getProperty(SYSTEM_PROPERTY_KEY_OS_NAME);
        for (SystemEnum value : SystemEnum.values()) {
            if (!osName.contains(value.name)) continue;
            return value;
        }
        return null;
    }

    public final SystemGroup getGroup() {
        return this.group;
    }

    public static SystemEnum[] getSystemsByGroup(SystemGroup group) {
        if (SystemGroup.ALL == group) {
            return SystemEnum.values();
        }
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        for (SystemEnum se : SystemEnum.values()) {
            if (se.getGroup() != group) continue;
            result.add(se);
        }
        return result.toArray(new SystemEnum[0]);
    }

    static {
        WINDOWS_ALL = Collections.unmodifiableList(ListUtil.toList(new int[]{WINDOWS_SERVER_2016.ordinal(), WINDOWS_SERVER_2012_R2.ordinal(), WINDOWS_SERVER_2012.ordinal(), WINDOWS_11.ordinal(), WINDOWS_10.ordinal(), WINDOWS_8_1.ordinal(), WINDOWS_8.ordinal(), WINDOWS_7.ordinal(), WINDOWS_VISTA.ordinal(), WINDOWS_XP.ordinal(), WINDOWS_2000.ordinal(), WINDOWS_NT.ordinal(), WINDOWS_ME.ordinal(), WINDOWS_98.ordinal(), WINDOWS_95.ordinal(), WINDOWS_SERVER_2008.ordinal(), WINDOWS_SERVER_2003.ordinal(), WINDOWS_2003_SERVER.ordinal(), WINDOWS_UNKNOWN.ordinal()}));
    }

    public static enum SystemGroup {
        ALL,
        WINDOWS,
        LINUX,
        MACOS;

    }
}

