/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.StringUtil;
import de.bos_bremen.common.system.ProcessResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class ProcessUtil {
    private ProcessUtil() {
    }

    public static String getOutput(InputStream is) {
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int r = 0;
            while ((r = is.read(buffer)) >= 0) {
                baos.write(buffer, 0, r);
            }
            baos.flush();
            baos.close();
            result = new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static ProcessResult getResult(Process p) throws InterruptedException {
        ProcessResult result = null;
        int exitValue = p.waitFor();
        String output = null;
        if (exitValue == 0) {
            output = ProcessUtil.getOutput(p.getInputStream());
            if (StringUtil.isNullOrEmpty(output)) {
                output = ProcessUtil.getOutput(p.getErrorStream());
            }
        } else {
            output = ProcessUtil.getOutput(p.getErrorStream());
            if (StringUtil.isNullOrEmpty(output)) {
                output = ProcessUtil.getOutput(p.getInputStream());
            }
        }
        result = new ProcessResult(p, exitValue, output);
        return result;
    }

    public static ProcessResult syncExec(String command) throws IOException, InterruptedException {
        return ProcessUtil.syncExec(command, null, null);
    }

    public static ProcessResult syncExec(String command, String[] envp) throws IOException, NullPointerException, IllegalArgumentException, InterruptedException {
        return ProcessUtil.syncExec(command, envp, null);
    }

    public static ProcessResult syncExec(String command, String[] envp, File dir) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(command, envp, dir);
        return ProcessUtil.getResult(p);
    }

    public static ProcessResult syncExec(String[] cmdarray, String[] envp) throws IOException, InterruptedException {
        return ProcessUtil.syncExec(cmdarray, envp, null);
    }

    public static ProcessResult syncExec(String[] cmdarray, String[] envp, File dir) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(cmdarray, envp, dir);
        return ProcessUtil.getResult(p);
    }

    public static ProcessResult syncExec(String[] cmdarray) throws IOException, InterruptedException {
        return ProcessUtil.syncExec(cmdarray, null, null);
    }
}

