/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.system.CTAPILibUtil;
import de.bos_bremen.common.system.DirectoryChooserPanel;
import de.bos_bremen.common.system.LibUtil;
import de.bos_bremen.common.system.SystemPropertyUtil;
import de.bos_bremen.jni.JavaSystemBridge;
import de.bos_bremen.jni.OSInfo;
import de.bos_bremen.jni.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LibUtilGUI
extends JDialog
implements ActionListener {
    private static final Log LOG = LogFactory.getLog(LibUtilGUI.class);
    public static final String CMD_LINE_OPTION_CONSOLE = "-c";
    public static final String CMD_LINE_OPTION_SEARCH_CTAPI = "-cc";
    public static final String USAGE_LINE = "Usage: java -jar mcard.jar de.bos_bremen.common.system.LibUtilGUI [options]\n\nOptions: --help -? -d -r -p\n\n --help:                          for this help\n -?:                              for this help\n -d [<directory>(;<directory>)*]: optional additional directories for search,\n                                  at least one directory\n -r:                              for recursive search at additional directories\n -p <pattern>:                    optional library search pattern,\n                                  regular expression for finding libraries,\n                                    example: \".*(JSB|jsb).*\" \n                                    IMPORTANT:\n                                      please always quot the expression with '\"'\n\n Note: all other options as help options are used at console mode only!!!";
    public static final String NEW_MCARD_JSB_PATTERN = ".*(JSB|jsb).*";
    public static final String CTAPI_PATTERN = ".*(CT|ct).*";
    public static final String OLD_MCARD_OCFPCSC_PATTERN = ".*(OCF|ocf|BRIDGE|bridge|PCSC|pcsc).*";
    public static final String ALL_PATTERN = ".*";
    private static final long serialVersionUID = 1L;
    private JPanel panelTop = new JPanel();
    private JPanel panelInfo = new JPanel();
    private JPanel panelInfoLabel = new JPanel();
    private JPanel panelInfoContent = new JPanel();
    private JPanel panelBottom = new JPanel();
    private JLabel labelPattern = new JLabel("Search filter (regular Expression):");
    private JCheckBox checkBoxAdditionalDirectories = new JCheckBox("search additional directories", false);
    private DirectoryChooserPanel panelDirectoryChooser = new DirectoryChooserPanel();
    private JCheckBox checkboxRecursive = new JCheckBox("recursive", false);
    private JCheckBox checkboxCheckCtapi = new JCheckBox("check for CT-API library");
    private JComboBox patternSelection = new JComboBox<PatternSet>(PatternSet.values());
    private JTextArea txtAreaResult = new JTextArea();
    private JScrollPane scrPaneResult = new JScrollPane(this.txtAreaResult, 20, 30);
    private JScrollPane scrPaneInfo = new JScrollPane(this.panelInfo, 20, 30);
    private JButton btnSearch = new JButton("Search");
    private boolean nativeFound = true;
    private static String CLASSNAME_COMMONS_LOGGING_FACTORY = "org.apache.commons.logging.LogFactory";

    private LibUtilGUI() throws ClassNotFoundException {
        LibUtilGUI.checkCommonsLoggingAvailable(true);
        this.init();
    }

    private void init() {
        try {
            JavaSystemBridge.loadLibrary();
        }
        catch (UnsatisfiedLinkError e) {
            this.nativeFound = false;
        }
        Dimension d = new Dimension(800, 600);
        this.panelDirectoryChooser.setEnabled(false);
        this.checkBoxAdditionalDirectories.setToolTipText("select to use additional directories for search");
        this.checkboxRecursive.setEnabled(false);
        this.checkboxRecursive.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, Color.black));
        this.checkboxRecursive.setToolTipText("select to search recursivly through additional directories");
        this.patternSelection.setEditable(true);
        this.patternSelection.setToolTipText("enter or select search pattern");
        this.txtAreaResult.setToolTipText("result of search displayed here");
        this.btnSearch.setToolTipText("press button to start search");
        this.checkboxCheckCtapi.setToolTipText((String)(this.nativeFound ? "select for checking if found libraries are CT-API" : "disabled failed loading required native library: " + System.mapLibraryName("jsb")));
        this.checkboxCheckCtapi.setEnabled(this.nativeFound);
        this.patternSelection.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (JLabel.class.isInstance(c) && PatternSet.class.isInstance(value)) {
                    PatternSet ps = (PatternSet)((Object)PatternSet.class.cast(value));
                    ((JLabel)JLabel.class.cast(c)).setText(ps.getName());
                }
                return c;
            }
        });
        this.patternSelection.getModel().addListDataListener(new PatternSelectListDataListener());
        this.patternSelection.setSelectedItem(PatternSet.values()[0].getPattern());
        this.checkBoxAdditionalDirectories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = ((JCheckBox)e.getSource()).isSelected();
                LibUtilGUI.this.checkboxRecursive.setEnabled(enabled);
                LibUtilGUI.this.panelDirectoryChooser.setEnabled(enabled);
            }
        });
        super.setSize(d);
        super.setPreferredSize(d);
        super.setMinimumSize(d);
        super.setMaximumSize(d);
        this.panelTop.setLayout(new GridLayout(6, 1));
        this.panelTop.add(this.labelPattern);
        this.panelTop.add(this.patternSelection);
        this.panelTop.add(this.checkBoxAdditionalDirectories);
        this.panelTop.add(this.checkboxRecursive);
        this.panelTop.add(this.panelDirectoryChooser);
        this.panelTop.add(this.checkboxCheckCtapi);
        this.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)this.panelTop, "North");
        super.getContentPane().add((Component)this.scrPaneResult, "Center");
        super.setTitle("Library Utility 2.0");
        this.createInfoPanel();
        this.panelBottom.setLayout(new BorderLayout());
        this.panelBottom.add((Component)this.btnSearch, "North");
        this.panelBottom.add((Component)this.scrPaneInfo, "Center");
        super.getContentPane().add((Component)this.panelBottom, "South");
        this.btnSearch.addActionListener(this);
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        super.setLocation(Math.max(0, (sd.width - d.width) / 2), Math.max(0, (sd.height - d.height) / 2));
        super.setDefaultCloseOperation(2);
        super.setVisible(true);
    }

    private void createInfoPanel() {
        ArrayList<JLabel> infoList = new ArrayList<JLabel>();
        ArrayList<JLabel> contentList = new ArrayList<JLabel>();
        if (this.nativeFound) {
            infoList.add(this.createBoldLabel("OS: "));
            contentList.add(this.createPlainLabel(SystemPropertyUtil.getOSName()));
            try {
                contentList.add(this.createPlainLabel(OSInfo.getDetails()));
                infoList.add(this.createBoldLabel("OSDetails: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'Details' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(OSInfo.getVersion()));
                infoList.add(this.createBoldLabel("Version: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'Version' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorName"), true));
                infoList.add(this.createBoldLabel("Processor: ", true));
            }
            catch (Exception e) {
                contentList.add(this.createPlainLabel("no information", true));
                infoList.add(this.createBoldLabel("Processor: ", true));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorRevision")));
                infoList.add(this.createBoldLabel("Revision: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'ProcessorRevision' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorType")));
                infoList.add(this.createBoldLabel("Type: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'ProcessorType' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorArchitecture")));
                infoList.add(this.createBoldLabel("Architecture: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'ProcessorArchitecture' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorLevel")));
                infoList.add(this.createBoldLabel("Level: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'Details' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorL1CacheSize")));
                infoList.add(this.createBoldLabel("L1 Cache: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'ProcessorL1CacheSize' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorL2CacheSize")));
                infoList.add(this.createBoldLabel("L2 Cache: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'ProcessorL2CacheSize' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorCPUCount")));
                infoList.add(this.createBoldLabel("Cores: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'Cores' failed: " + e.getMessage()));
            }
            try {
                contentList.add(this.createPlainLabel(SystemInfo.getInfo("ProcessorFeatures")));
                infoList.add(this.createBoldLabel("Features: "));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel 'Features' failed: " + e.getMessage()));
            }
        } else {
            try {
                contentList.add(this.createPlainLabel("failed loading required native library: '" + System.mapLibraryName("jsb") + "'", true));
                infoList.add(this.createBoldLabel("System informations not available: ", true));
            }
            catch (Exception e) {
                LOG.debug((Object)("createInfoPanel name of JSB library failed: " + e.getMessage()));
            }
        }
        infoList.add(this.createBoldLabel("Java-Version: ", true));
        contentList.add(this.createPlainLabel(SystemPropertyUtil.getJavaVersion(), true));
        infoList.add(this.createBoldLabel("Java-Architecture: "));
        contentList.add(this.createPlainLabel(SystemPropertyUtil.getJavaArchitecture()));
        infoList.add(this.createBoldLabel("Java-Home: "));
        contentList.add(this.createPlainLabel(SystemPropertyUtil.getJavaHome()));
        this.panelInfo.setLayout(new BorderLayout());
        this.panelInfoLabel.setLayout(new GridLayout(infoList.size(), 1));
        this.panelInfoContent.setLayout(new GridLayout(contentList.size(), 1));
        for (JLabel info : infoList) {
            this.panelInfoLabel.add(info);
        }
        for (JLabel content : contentList) {
            this.panelInfoContent.add(content);
        }
        this.panelInfo.add((Component)this.panelInfoLabel, "West");
        this.panelInfo.add((Component)this.panelInfoContent, "Center");
    }

    private JLabel createBoldLabel(String label) {
        return this.createBoldLabel(label, false);
    }

    private JLabel createBoldLabel(String label, boolean line) {
        return this.createLabel(label, 1, line);
    }

    private JLabel createPlainLabel(String label) {
        return this.createPlainLabel(label, false);
    }

    private JLabel createPlainLabel(String label, boolean line) {
        return this.createLabel(label, 0, line);
    }

    private JLabel createLabel(String label, int style, boolean line) {
        JLabel l = new JLabel(label);
        l.setFont(l.getFont().deriveFont(style));
        if (line) {
            l.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black));
        }
        return l;
    }

    public LibUtilGUI(Dialog owner, boolean modal) {
        super(owner, modal);
        this.init();
    }

    @Override
    public void dispose() {
        this.btnSearch.removeActionListener(this);
        super.dispose();
    }

    public static void main(String[] args) throws ClassNotFoundException {
        if (args == null) {
            System.out.println(USAGE_LINE);
            return;
        }
        ArrayList<String> listArgs = new ArrayList<String>();
        listArgs.addAll(Arrays.asList(args));
        if (listArgs.contains("--help") || listArgs.contains("-?")) {
            System.out.println(USAGE_LINE);
            return;
        }
        if (listArgs.contains(CMD_LINE_OPTION_CONSOLE)) {
            listArgs.remove(CMD_LINE_OPTION_CONSOLE);
            if (listArgs.contains(CMD_LINE_OPTION_SEARCH_CTAPI)) {
                listArgs.remove(CMD_LINE_OPTION_SEARCH_CTAPI);
                CTAPILibUtil.main(listArgs.toArray(new String[0]));
            } else {
                LibUtil.main(listArgs.toArray(new String[0]));
            }
        } else {
            new LibUtilGUI();
        }
    }

    public static void checkCommonsLoggingAvailable(boolean gui) throws ClassNotFoundException {
        try {
            Class.forName(CLASSNAME_COMMONS_LOGGING_FACTORY);
        }
        catch (ClassNotFoundException e) {
            String s = "Apache Commons Logging not available.\n'commons-logging.jar' and optionally 'log4j.jar' must in directory of 'mcard.jar'.\nStarting LibUtilGUI aborted.";
            if (gui) {
                JOptionPane.showMessageDialog(null, s, "Error", 0);
            } else {
                System.err.println(s);
            }
            throw e;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<String> listArgs = new ArrayList<String>();
        listArgs.add("-p");
        listArgs.add((String)this.patternSelection.getSelectedItem());
        if (this.checkBoxAdditionalDirectories.isSelected()) {
            listArgs.add("-d");
            listArgs.add(this.panelDirectoryChooser.getDirectoriesString());
            if (this.checkboxRecursive.isEnabled() && this.checkboxRecursive.isSelected()) {
                listArgs.add("-r");
            }
        }
        if (!this.checkboxCheckCtapi.isSelected()) {
            this.txtAreaResult.setText(LibUtil.search(listArgs.toArray(new String[0])).toString());
        } else {
            this.txtAreaResult.setText(CTAPILibUtil.search(listArgs.toArray(new String[0])).toString());
        }
    }

    static enum PatternSet {
        JSB("new MCard/JSB", ".*(JSB|jsb).*"),
        CT_API("CT-API", ".*(CT|ct).*"),
        OCFPCSC("old MCard/OCFPCSC", ".*(OCF|ocf|BRIDGE|bridge|PCSC|pcsc).*"),
        ALL("all", ".*");

        private String name = null;
        private String pattern = null;

        public String getName() {
            return this.name;
        }

        public String getPattern() {
            return this.pattern;
        }

        private PatternSet(String name, String pattern) {
            this.name = name;
            this.pattern = pattern;
        }
    }

    private final class PatternSelectListDataListener
    implements ListDataListener {
        private boolean ignore = false;

        PatternSelectListDataListener() {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (this.ignore || String.class.isInstance(LibUtilGUI.this.patternSelection.getSelectedItem())) {
                return;
            }
            this.ignore = true;
            PatternSet ps = (PatternSet)((Object)LibUtilGUI.this.patternSelection.getSelectedItem());
            LibUtilGUI.this.patternSelection.setSelectedItem(ps.getPattern());
            this.ignore = false;
        }
    }
}

