/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.system.LibUtilGUI;
import de.bos_bremen.common.system.SystemPropertyUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class LibUtil {
    public static final String USAGE_ERROR_DIRECTORIES_OPTION_INVALID_DIRECTORY_LIST = "Usage Error: directories option used without valid directory list\n";
    public static final String USAGE_ERROR_PATTERN_OPTION_INVALID_PATTERN = "Usage Error: pattern option used without valid regular expression\n";
    public static final String USAGE_ERROR_PATTERN_OPTION_NO_PATTERN = "Usage Error: pattern option used without pattern\n";
    public static final String USAGE_ERROR_DIRECTORIES_OPTION_NO_DIRECTORIES = "Usage Error: directories option used without directories\n";
    public static final String USAGE_ERROR_RECURSIVE_OPTION_NO_DIRECTORIES = "Usage Error: recursive option used without specifying additional directories\n";
    public static final String SEPARATOR_DIRECTORIES = ";";
    public static final String PREFIX_CMD_LINE_OPTION = "-";
    public static final String CMD_LINE_OPTION_HELP_SIMPLE = "-?";
    public static final String CMD_LINE_OPTION_HELP = "--help";
    public static final String CMD_LINE_OPTION_DIRECTORIES = "-d";
    public static final String CMD_LINE_OPTION_RECURSIVE = "-r";
    public static final String CMD_LINE_OPTION_PATTERN = "-p";
    public static final String USAGE_LINE = "Usage: java -jar mcard.jar de.bos_bremen.common.system.LibUtil [options]\n\nOptions: --help -? -d -r -p\n\n --help:                          for this help\n -?:                              for this help\n -d [<directory>(;<directory>)*]: optional additional directories for search,\n                                  at least one directory\n -r:                              for recursive search at additional directories\n -p <pattern>:                    optional library search pattern,\n                                  regular expression for finding libraries,\n                                    example: \".*(JSB|jsb).*\" \n                                    IMPORTANT:\n                                      please always quot the expression with '\"'";
    public static final String OS_NAME_WINDOWS = "windows";
    public static final String EXTENSION_SEPARATOR = ".";
    private static final String TEST_LIB_NAME = "$$$";
    public static final String PATH_SEPARATOR_WINDOWS = ";";
    public static final String PATH_SEPARATOR_LINUX = ":";

    private LibUtil() {
    }

    public static List<String> getLibraryPathList() {
        String libraryPath = SystemPropertyUtil.getJavaLibraryPath();
        return Arrays.asList(libraryPath.split(LibUtil.getPathSeparator()));
    }

    public static String getLibraryPrefix() {
        String tmp = System.mapLibraryName(TEST_LIB_NAME);
        int index = tmp.indexOf(TEST_LIB_NAME);
        return tmp.substring(0, index);
    }

    public static String getLibrarySuffix() {
        String tmp = System.mapLibraryName(TEST_LIB_NAME);
        int index = tmp.indexOf(TEST_LIB_NAME) + TEST_LIB_NAME.length();
        return tmp.substring(index, tmp.length() - LibUtil.getLibraryExtension().length());
    }

    public static String getLibraryExtension() {
        String tmp = System.mapLibraryName(TEST_LIB_NAME);
        int index = tmp.lastIndexOf(EXTENSION_SEPARATOR);
        return tmp.substring(index);
    }

    public static List<String> getCompactLibraryPathList() {
        List<String> libraryPathList = LibUtil.getLibraryPathList();
        ArrayList<String> pathList = new ArrayList<String>();
        for (String tmp : libraryPathList) {
            if (pathList.contains(tmp)) continue;
            pathList.add(tmp);
        }
        return pathList;
    }

    public static String getPathSeparator() {
        return SystemPropertyUtil.getOSName().toLowerCase().contains(OS_NAME_WINDOWS) ? ";" : PATH_SEPARATOR_LINUX;
    }

    public static int countLibrary(String libraryRegex, List<String> listDirectories) {
        Map<String, List<String>> search;
        int result = 0;
        if (CollectionUtil.notNullOrEmpty(listDirectories) && !(search = LibUtil.findLibrary(libraryRegex, listDirectories)).isEmpty()) {
            for (List<String> tmp : search.values()) {
                result += tmp != null ? tmp.size() : 0;
            }
        }
        return result;
    }

    public static Map<String, List<String>> findLibrary(String libraryRegex, List<String> listDirectories) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (CollectionUtil.isNullOrEmpty(listDirectories)) {
            return result;
        }
        final String regex = LibUtil.getLibraryPrefix() + libraryRegex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1);
        for (String directory : listDirectories) {
            File f;
            File[] libraries;
            String path = directory;
            if (path != null && path.length() == 0) {
                path = EXTENSION_SEPARATOR;
            }
            if ((libraries = (f = new File(path)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return Pattern.matches(regex, name);
                }
            })) != null && libraries.length >= 1) {
                List<String> tmpList = new ArrayList<String>();
                for (File tmp : libraries) {
                    tmpList.add(tmp.getName());
                }
                Collections.sort(tmpList);
                tmpList = Collections.unmodifiableList(tmpList);
                result.put(path, tmpList);
                continue;
            }
            result.put(path, null);
        }
        return Collections.unmodifiableMap(result);
    }

    public static boolean exists(String libraryRegex, List<String> listDirectories) {
        return LibUtil.countLibrary(libraryRegex, listDirectories) > 0;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        LibUtilGUI.checkCommonsLoggingAvailable(false);
        System.out.println(LibUtil.search(args));
    }

    public static void findSubDirectories(File dirFile, List<String> listDirectories) {
        if (ObjectUtil.isNull(dirFile) || CollectionUtil.isNull(listDirectories)) {
            return;
        }
        File[] subDirectories = dirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirectories != null && subDirectories.length > 0) {
            for (File subDirectory : subDirectories) {
                if (listDirectories.contains(subDirectory.getAbsolutePath())) continue;
                listDirectories.add(subDirectory.getAbsolutePath());
                LibUtil.findSubDirectories(subDirectory, listDirectories);
            }
        }
    }

    public static List<String> argsToListString(StringBuffer result, String[] args, String usageLine, String ... helpOptions) {
        if (ArrayUtil.isNull(args)) {
            LibUtil.println(result, usageLine);
            return null;
        }
        ArrayList<String> listArgs = new ArrayList<String>();
        listArgs.addAll(Arrays.asList(args));
        if (helpOptions != null) {
            for (String helpOption : helpOptions) {
                if (!listArgs.contains(helpOption)) continue;
                LibUtil.println(result, usageLine);
                return null;
            }
        }
        return listArgs;
    }

    public static StringBuffer search(String[] args) {
        String regex;
        String directories;
        StringBuffer result = new StringBuffer();
        List<String> listArgs = LibUtil.argsToListString(result, args, USAGE_LINE, CMD_LINE_OPTION_HELP, CMD_LINE_OPTION_HELP_SIMPLE);
        if (listArgs == null) {
            return result;
        }
        int idxOptionDirectories = listArgs.indexOf(CMD_LINE_OPTION_DIRECTORIES);
        int idxOptionRecursive = listArgs.indexOf(CMD_LINE_OPTION_RECURSIVE);
        int idxOptionPattern = listArgs.indexOf(CMD_LINE_OPTION_PATTERN);
        String string = directories = idxOptionDirectories >= 0 && idxOptionDirectories + 1 < listArgs.size() ? listArgs.get(idxOptionDirectories + 1) : null;
        if (idxOptionDirectories < 0 && idxOptionRecursive >= 0) {
            LibUtil.println(result, USAGE_ERROR_RECURSIVE_OPTION_NO_DIRECTORIES);
            LibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 && directories == null) {
            LibUtil.println(result, USAGE_ERROR_DIRECTORIES_OPTION_NO_DIRECTORIES);
            LibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 && directories.startsWith(PREFIX_CMD_LINE_OPTION)) {
            LibUtil.println(result, USAGE_ERROR_DIRECTORIES_OPTION_INVALID_DIRECTORY_LIST);
            LibUtil.println(result, USAGE_LINE);
            return result;
        }
        String string2 = regex = idxOptionPattern >= 0 && idxOptionPattern + 1 < listArgs.size() ? listArgs.get(idxOptionPattern + 1) : null;
        if (idxOptionPattern >= 0 && regex == null) {
            LibUtil.println(result, USAGE_ERROR_PATTERN_OPTION_NO_PATTERN);
            LibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionPattern >= 0 && regex.startsWith(PREFIX_CMD_LINE_OPTION)) {
            LibUtil.println(result, USAGE_ERROR_PATTERN_OPTION_INVALID_PATTERN);
            LibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 || idxOptionPattern >= 0) {
            LibUtil.println(result, "Search Options:\n");
            if (idxOptionDirectories >= 0) {
                LibUtil.println(result, "  Directories: " + directories);
                LibUtil.println(result, "  Recursive: " + (idxOptionRecursive >= 0));
            }
            if (idxOptionPattern >= 0) {
                LibUtil.println(result, "  Regular expression: " + LibUtil.getLibraryPrefix() + regex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1));
            }
            LibUtil.println(result, "");
        } else {
            LibUtil.println(result, "Search Options:\n  default (all libraries at Java Library Path)\n");
        }
        if (regex == null) {
            regex = ".*";
        }
        ArrayList<String> listDirectories = new ArrayList<String>();
        if (directories != null) {
            ArrayList<String> tmpList = new ArrayList<String>();
            String[] directoriesTmp = directories.split(";");
            listDirectories.addAll(Arrays.asList(directoriesTmp));
            File tmpFile = null;
            for (String string3 : listDirectories) {
                tmpFile = new File(string3);
                if (!tmpFile.exists()) {
                    LibUtil.println(result, "Usage Error: directory entry '" + string3 + "' does not exist");
                    LibUtil.println(result, USAGE_LINE);
                    return result;
                }
                if (!tmpFile.isDirectory()) {
                    LibUtil.println(result, "Usage Error: directory entry '" + string3 + "' specifies not a directory");
                    LibUtil.println(result, USAGE_LINE);
                    return result;
                }
                if (idxOptionRecursive < 0) continue;
                LibUtil.findSubDirectories(tmpFile, tmpList);
            }
            tmpList.removeAll(listDirectories);
            listDirectories.addAll(tmpList);
        }
        LibUtil.println(result, "Java: " + SystemPropertyUtil.getJavaVersion());
        LibUtil.println(result, "Java-Architecture: " + SystemPropertyUtil.getJavaArchitecture());
        LibUtil.println(result, "Java Library Path: ");
        LibUtil.println(result, "  Library-Prefix: " + LibUtil.getLibraryPrefix());
        LibUtil.println(result, "  Library-Suffix: " + LibUtil.getLibrarySuffix());
        LibUtil.println(result, "  Library-Extension: " + LibUtil.getLibraryExtension());
        LibUtil.println(result, "  Raw Path: " + SystemPropertyUtil.getJavaLibraryPath());
        LibUtil.println(result, "  Compact Path: ");
        List<String> librarySearchPathList = LibUtil.getCompactLibraryPathList();
        listDirectories.removeAll(librarySearchPathList);
        librarySearchPathList.addAll(listDirectories);
        for (String librarySearchPath : librarySearchPathList) {
            Object libraryPath = librarySearchPath;
            File file = new File((String)libraryPath);
            if (!file.getAbsolutePath().equals(libraryPath)) {
                libraryPath = "'" + (String)libraryPath + "' (" + file.getAbsolutePath() + ")";
            }
            LibUtil.println(result, "    " + (String)libraryPath);
        }
        LibUtil.println(result, "\nLibraries:");
        String regexTmp = LibUtil.getLibraryPrefix() + regex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1);
        LibUtil.println(result, "  Searching for: " + regexTmp.replaceAll(Pattern.quote("\\."), EXTENSION_SEPARATOR) + " (Regular expression:" + regexTmp + ")");
        LibUtil.println(result, "  Count of matching libraries: " + LibUtil.countLibrary(regex, librarySearchPathList));
        Map<String, List<String>> search = LibUtil.findLibrary(regex, librarySearchPathList);
        for (Map.Entry entry : search.entrySet()) {
            String path = (String)entry.getKey();
            File f = new File(path);
            Object additional = "";
            if (!f.getAbsolutePath().equals(path)) {
                additional = " (" + f.getAbsolutePath() + ")";
            }
            LibUtil.println(result, "    " + path + (String)additional);
            if (entry.getValue() == null || ((List)entry.getValue()).size() == 0) {
                LibUtil.println(result, "      - no libraries found -");
                continue;
            }
            for (String libname : (List)entry.getValue()) {
                File lf = new File(path + "/" + libname);
                LibUtil.println(result, "      " + libname + "\t -  " + lf.length() + "\t -  " + new Date(lf.lastModified()));
            }
        }
        return result;
    }

    private static void println(StringBuffer buffer, String message) {
        buffer.append(message + "\n");
    }
}

