/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.HexUtil;
import de.bos_bremen.common.StringRepresentableEnum;
import de.bos_bremen.common.system.LanguageConstants;
import de.bos_bremen.common.system.LanguageIDs;
import java.util.Locale;

public enum LanguageEnum implements LanguageIDs,
LanguageConstants,
StringRepresentableEnum
{
    UNKNOWN("UNKNOWN", LOCALE_UNKNOWN, 65535),
    GERMAN("GERMAN", Locale.GERMAN, 1031),
    ENGLISH("ENGLISH", Locale.ENGLISH, 1033),
    FRENCH("FRENCH", Locale.FRENCH, 1036),
    SPANISH("SPANISH", LOCALE_ES, 1034),
    ITALIAN("ITALIAN", Locale.ITALIAN, 1040);

    private String name = null;
    private int id = 0;
    private Locale locale = null;

    private LanguageEnum(String name, Locale locale, int id) {
        if (name == null) {
            throw new IllegalArgumentException("name expected, but null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name expected, but empty");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale expected, but null");
        }
        this.name = name;
        this.locale = locale;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String toString() {
        return super.toString() + "(name: " + this.name + ", locale: " + this.locale + ", ID: " + HexUtil.hexify(this.id) + ")";
    }

    public static LanguageEnum getByID(int id) {
        LanguageEnum result = null;
        LanguageEnum[] languages = LanguageEnum.values();
        for (int i = 0; i < languages.length; ++i) {
            if (languages[i].getID() != id) continue;
            result = languages[i];
            break;
        }
        if (result == null) {
            result = UNKNOWN;
        }
        return result;
    }

    public static LanguageEnum getByLanguageCode(String languageCode) {
        LanguageEnum result = null;
        LanguageEnum[] languages = LanguageEnum.values();
        for (int i = 0; i < languages.length; ++i) {
            if (!languages[i].getLocale().getLanguage().equals(languageCode)) continue;
            result = languages[i];
            break;
        }
        if (result == null) {
            result = UNKNOWN;
        }
        return result;
    }
}

