/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DirectoryChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField txtDirectory = null;
    private JButton btnSelectDirectory = null;
    private JFileChooser fileChooser = null;

    @Override
    public void setEnabled(boolean enabled) {
        this.txtDirectory.setEnabled(enabled);
        this.btnSelectDirectory.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public DirectoryChooserPanel() {
        this.init();
    }

    public DirectoryChooserPanel(LayoutManager layout) {
        super(layout);
        this.init();
    }

    public DirectoryChooserPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    public DirectoryChooserPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.fileChooser = new JFileChooser();
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle("Select directories...");
        this.txtDirectory = new JTextField();
        this.txtDirectory.setToolTipText("enter directories, multiple directories to be separated by using ';' as separator");
        this.btnSelectDirectory = new JButton("...");
        this.btnSelectDirectory.setToolTipText("select directories");
        this.btnSelectDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryChooserPanel.this.fileChooser.showOpenDialog(DirectoryChooserPanel.this.getParent()) == 0) {
                    ArrayList<File> listDirectories = new ArrayList<File>();
                    DirectoryChooserPanel.this.txtDirectory.setText("");
                    File[] files = DirectoryChooserPanel.this.fileChooser.getSelectedFiles();
                    if (files != null && files.length >= 1) {
                        listDirectories.addAll(Arrays.asList(files));
                        DirectoryChooserPanel.this.txtDirectory.setText(((Object)listDirectories).toString().replaceAll(Pattern.quote("["), "").replaceAll(Pattern.quote("]"), "").replaceAll(", ", ";"));
                    }
                }
            }
        });
        this.add((Component)this.txtDirectory, "Center");
        this.add((Component)this.btnSelectDirectory, "East");
    }

    public String getDirectoriesString() {
        if (!super.isEnabled()) {
            return "";
        }
        return this.txtDirectory.getText();
    }
}

