/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.system;

import de.bos_bremen.common.CollectionUtil;
import de.bos_bremen.common.system.LibUtil;
import de.bos_bremen.common.system.LibUtilGUI;
import de.bos_bremen.common.system.SystemPropertyUtil;
import de.bos_bremen.java.ctapi.JCTAPILibraryManager;
import de.bos_bremen.jni.JavaSystemBridge;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CTAPILibUtil {
    private static final Log LOG = LogFactory.getLog(CTAPILibUtil.class);
    public static final String USAGE_ERROR_DIRECTORIES_OPTION_INVALID_DIRECTORY_LIST = "Usage Error: directories option used without valid directory list\n";
    public static final String USAGE_ERROR_PATTERN_OPTION_INVALID_PATTERN = "Usage Error: pattern option used without valid regular expression\n";
    public static final String USAGE_ERROR_PATTERN_OPTION_NO_PATTERN = "Usage Error: pattern option used without pattern\n";
    public static final String USAGE_ERROR_DIRECTORIES_OPTION_NO_DIRECTORIES = "Usage Error: directories option used without directories\n";
    public static final String USAGE_ERROR_RECURSIVE_OPTION_NO_DIRECTORIES = "Usage Error: recursive option used without specifying additional directories\n";
    private static final List<String> EXCLUDE_LIB_LIST;
    public static final int MAX_LIBRARY_SIZE = 1024000;
    public static final String SEPARATOR_DIRECTORIES = ";";
    public static final String PREFIX_CMD_LINE_OPTION = "-";
    public static final String CMD_LINE_OPTION_HELP_SIMPLE = "-?";
    public static final String CMD_LINE_OPTION_HELP = "--help";
    public static final String CMD_LINE_OPTION_DIRECTORIES = "-d";
    public static final String CMD_LINE_OPTION_RECURSIVE = "-r";
    public static final String CMD_LINE_OPTION_PATTERN = "-p";
    public static final String USAGE_LINE = "Usage: java -jar mcard.jar de.bos_bremen.common.system.CTAPILibUtil [options]\n\nOptions: --help -? -d -r -p\n\n --help:                          for this help\n -?:                              for this help\n -d [<directory>(;<directory>)*]: optional additional directories for search,\n                                  at least one directory\n -r:                              for recursive search at additional directories\n -p <pattern>:                    optional library search pattern,\n                                  regular expression for finding libraries,\n                                    example: \".*(CT|ct).*\" \n                                    IMPORTANT:\n                                      please always quot the expression with '\"'";
    private static JCTAPILibraryManager jclm;

    private CTAPILibUtil() {
    }

    public static int countLibrary(String libraryRegex, List<String> listDirectories) {
        int result = 0;
        Map<String, List<String>> search = CTAPILibUtil.findLibrary(libraryRegex, listDirectories);
        if (!search.isEmpty()) {
            for (List<String> tmp : search.values()) {
                result += tmp != null ? tmp.size() : 0;
            }
        }
        return result;
    }

    public static Map<String, List<String>> findLibrary(String libraryRegex, List<String> listDirectories) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        List<String> compactPathList = CollectionUtil.notNullOrEmpty(listDirectories) ? listDirectories : LibUtil.getCompactLibraryPathList();
        final String regex = LibUtil.getLibraryPrefix() + libraryRegex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1);
        for (String compactPath : compactPathList) {
            File f;
            File[] libraries;
            String path = compactPath;
            if (path != null && path.length() == 0) {
                path = ".";
            }
            if ((libraries = (f = new File(path)).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return Pattern.matches(regex, name);
                }
            })) != null && libraries.length >= 1) {
                ArrayList<File> listLibraries = new ArrayList<File>();
                for (File tmp : libraries) {
                    listLibraries.add(tmp);
                }
                Collections.sort(listLibraries, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f1.getAbsolutePath().compareTo(f2.getAbsolutePath());
                    }
                });
                libraries = listLibraries.toArray(new File[0]);
                ArrayList<String> tmpList = new ArrayList<String>();
                for (File tmp : libraries) {
                    if (!CTAPILibUtil.checkCTAPI(tmp)) continue;
                    tmpList.add(tmp.getName());
                }
                Collections.sort(tmpList);
                result.put(path, tmpList);
                continue;
            }
            result.put(path, new ArrayList());
        }
        return result;
    }

    public static boolean exists(String libraryRegex, List<String> listDirectories) {
        return CTAPILibUtil.countLibrary(libraryRegex, listDirectories) > 0;
    }

    public static void main(String[] args) throws ClassNotFoundException {
        LibUtilGUI.checkCommonsLoggingAvailable(false);
        JavaSystemBridge.loadLibrary();
        System.out.println(CTAPILibUtil.search(args));
    }

    public static synchronized StringBuffer search(String[] args) {
        String regex;
        String directories;
        StringBuffer result = new StringBuffer();
        List<String> listArgs = LibUtil.argsToListString(result, args, USAGE_LINE, CMD_LINE_OPTION_HELP, CMD_LINE_OPTION_HELP_SIMPLE);
        if (listArgs == null) {
            return result;
        }
        int idxOptionDirectories = listArgs.indexOf(CMD_LINE_OPTION_DIRECTORIES);
        int idxOptionRecursive = listArgs.indexOf(CMD_LINE_OPTION_RECURSIVE);
        int idxOptionPattern = listArgs.indexOf(CMD_LINE_OPTION_PATTERN);
        String string = directories = idxOptionDirectories >= 0 && idxOptionDirectories + 1 < listArgs.size() ? listArgs.get(idxOptionDirectories + 1) : null;
        if (idxOptionDirectories < 0 && idxOptionRecursive >= 0) {
            CTAPILibUtil.println(result, USAGE_ERROR_RECURSIVE_OPTION_NO_DIRECTORIES);
            CTAPILibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 && directories == null) {
            CTAPILibUtil.println(result, USAGE_ERROR_DIRECTORIES_OPTION_NO_DIRECTORIES);
            CTAPILibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 && directories.startsWith(PREFIX_CMD_LINE_OPTION)) {
            CTAPILibUtil.println(result, USAGE_ERROR_DIRECTORIES_OPTION_INVALID_DIRECTORY_LIST);
            CTAPILibUtil.println(result, USAGE_LINE);
            return result;
        }
        String string2 = regex = idxOptionPattern >= 0 && idxOptionPattern + 1 < listArgs.size() ? listArgs.get(idxOptionPattern + 1) : null;
        if (idxOptionPattern >= 0 && regex == null) {
            CTAPILibUtil.println(result, USAGE_ERROR_PATTERN_OPTION_NO_PATTERN);
            CTAPILibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionPattern >= 0 && regex.startsWith(PREFIX_CMD_LINE_OPTION)) {
            CTAPILibUtil.println(result, USAGE_ERROR_PATTERN_OPTION_INVALID_PATTERN);
            CTAPILibUtil.println(result, USAGE_LINE);
            return result;
        }
        if (idxOptionDirectories >= 0 || idxOptionPattern >= 0) {
            CTAPILibUtil.println(result, "Search Options:\n");
            if (idxOptionDirectories >= 0) {
                CTAPILibUtil.println(result, "  Directories: " + directories);
                CTAPILibUtil.println(result, "  Recursive: " + (idxOptionRecursive >= 0));
            }
            if (idxOptionPattern >= 0) {
                CTAPILibUtil.println(result, "  Regular expression: " + LibUtil.getLibraryPrefix() + regex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1));
            }
            CTAPILibUtil.println(result, "");
        } else {
            CTAPILibUtil.println(result, "Search Options:\n  default (all libraries at Java Library Path)\n");
        }
        if (regex == null) {
            regex = ".*";
        }
        ArrayList<String> listDirectories = new ArrayList<String>();
        if (directories != null) {
            ArrayList<String> tmpList = new ArrayList<String>();
            String[] directoriesTmp = directories.split(SEPARATOR_DIRECTORIES);
            listDirectories.addAll(Arrays.asList(directoriesTmp));
            File tmpFile = null;
            for (String string3 : listDirectories) {
                tmpFile = new File(string3);
                if (!tmpFile.exists()) {
                    CTAPILibUtil.println(result, "Usage Error: directory entry '" + string3 + "' does not exist");
                    CTAPILibUtil.println(result, USAGE_LINE);
                    return result;
                }
                if (!tmpFile.isDirectory()) {
                    CTAPILibUtil.println(result, "Usage Error: directory entry '" + string3 + "' specifies not a directory");
                    CTAPILibUtil.println(result, USAGE_LINE);
                    return result;
                }
                if (idxOptionRecursive < 0) continue;
                LibUtil.findSubDirectories(tmpFile, tmpList);
            }
            tmpList.removeAll(listDirectories);
            listDirectories.addAll(tmpList);
        }
        CTAPILibUtil.println(result, "Java: " + SystemPropertyUtil.getJavaVersion());
        CTAPILibUtil.println(result, "Java-Architecture: " + SystemPropertyUtil.getJavaArchitecture());
        CTAPILibUtil.println(result, "Java Library Path: ");
        CTAPILibUtil.println(result, "  Library-Prefix: " + LibUtil.getLibraryPrefix());
        CTAPILibUtil.println(result, "  Library-Suffix: " + LibUtil.getLibrarySuffix());
        CTAPILibUtil.println(result, "  Library-Extension: " + LibUtil.getLibraryExtension());
        CTAPILibUtil.println(result, "  Raw Path: " + SystemPropertyUtil.getJavaLibraryPath());
        CTAPILibUtil.println(result, "  Compact Path: ");
        List<String> librarySearchPathList = LibUtil.getCompactLibraryPathList();
        listDirectories.removeAll(librarySearchPathList);
        librarySearchPathList.addAll(listDirectories);
        for (String librarySearchPath : librarySearchPathList) {
            Object libraryPath = librarySearchPath;
            File file = new File((String)libraryPath);
            if (!file.getAbsolutePath().equals(libraryPath)) {
                libraryPath = "'" + (String)libraryPath + "' (" + file.getAbsolutePath() + ")";
            }
            CTAPILibUtil.println(result, "    " + (String)libraryPath);
        }
        CTAPILibUtil.println(result, "\nLibraries:");
        String regexTmp = LibUtil.getLibraryPrefix() + regex + LibUtil.getLibrarySuffix() + "\\." + LibUtil.getLibraryExtension().substring(1);
        CTAPILibUtil.println(result, "  Searching for: " + regexTmp.replaceAll(Pattern.quote("\\."), ".") + " (Regular expression:" + regexTmp + ")");
        CTAPILibUtil.println(result, "  Count of matching libraries: " + CTAPILibUtil.countLibrary(regex, librarySearchPathList));
        Map<String, List<String>> search = CTAPILibUtil.findLibrary(regex, librarySearchPathList);
        for (Map.Entry entry : search.entrySet()) {
            String path = (String)entry.getKey();
            File f = new File(path);
            Object additional = "";
            if (!f.getAbsolutePath().equals(path)) {
                additional = " (" + f.getAbsolutePath() + ")";
            }
            CTAPILibUtil.println(result, "    " + path + (String)additional);
            if (entry.getValue() == null || ((List)entry.getValue()).size() == 0) {
                CTAPILibUtil.println(result, "      - no libraries found -");
                continue;
            }
            for (String libname : (List)entry.getValue()) {
                File lf = new File(path + "/" + libname);
                CTAPILibUtil.println(result, "      " + libname + "\t -  " + lf.length() + "\t -  " + new Date(lf.lastModified()));
            }
        }
        listArgs.clear();
        listDirectories.clear();
        librarySearchPathList.clear();
        search.clear();
        return result;
    }

    public static boolean checkCTAPI(File file) {
        if (jclm == null) {
            jclm = JCTAPILibraryManager.getLibraryManager();
        }
        boolean check = false;
        if (file == null || !file.exists() || !file.isFile()) {
            return check;
        }
        if (EXCLUDE_LIB_LIST.contains(file.getName()) || file.isDirectory()) {
            return check;
        }
        if (file.length() > 1024000L) {
            return check;
        }
        try {
            long handle = jclm.loadLibrary(file.getAbsolutePath());
            if (handle != -1L) {
                jclm.unloadLibrary(handle);
                check = true;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("loading CTAPi-library failed: " + e.getMessage()));
        }
        return check;
    }

    private static void println(StringBuffer buffer, String message) {
        buffer.append(message + "\n");
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("libmemusage.so");
        tmp.add("libSegFault.so");
        EXCLUDE_LIB_LIST = Collections.unmodifiableList(tmp);
        jclm = null;
    }
}

