/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.swing;

import de.bos_bremen.common.JSBRuntimeException;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SwingUtil {
    private static final Log LOG = LogFactory.getLog(SwingUtil.class);
    public static final String DEFAULT_AWT_EVENT_QUEUE_THREAD_CLASS_FILENAME = "EventDispatchThread.java";
    public static final String DEFAULT_AWT_EVENT_QUEUE_THREAD_CLASS_CLASSNAME = "java.awt.EventDispatchThread";

    private SwingUtil() {
    }

    public static void update(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.update(c.getGraphics());
            }
        });
    }

    public static void validate(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.validate();
            }
        });
    }

    public static void invalidate(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.invalidate();
            }
        });
    }

    public static void paint(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.paint(c.getGraphics());
            }
        });
    }

    public static void paintAll(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                c.paintAll(c.getGraphics());
            }
        });
    }

    public static void updateComponentTreeUI(final Component c) throws JSBRuntimeException {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.updateComponentTreeUI(c);
                }
                catch (Throwable t) {
                    LOG.debug((Object)"ignored error updating component tree ui", t);
                }
            }
        });
    }

    public static void invokeLater(Runnable runnable) throws JSBRuntimeException {
        SwingUtil.invokeLater(runnable, true);
    }

    public static boolean isAWTEventQueueCalling() {
        StackTraceElement firstElement = Thread.currentThread().getStackTrace()[Thread.currentThread().getStackTrace().length - 1];
        boolean awtEventQueueActive = EventQueue.isDispatchThread() || DEFAULT_AWT_EVENT_QUEUE_THREAD_CLASS_CLASSNAME.equals(firstElement.getClassName()) || DEFAULT_AWT_EVENT_QUEUE_THREAD_CLASS_FILENAME.equals(firstElement.getFileName());
        return awtEventQueueActive;
    }

    public static void invokeLater(Runnable runnable, boolean executeDirectWhenAWTEventQueue) throws JSBRuntimeException {
        boolean awtEventQueueActive = SwingUtil.isAWTEventQueueCalling();
        if (awtEventQueueActive && executeDirectWhenAWTEventQueue) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

