/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.swing;

import de.bos_bremen.common.swing.PlafMacros;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public final class MultiLineToolTipUI
extends ToolTipUI {
    private static final String KEY_UIMANAGER_TOOLTIPUI_VALUE = "ToolTipUI";
    private static final MultiLineToolTipUI SINGLETON = new MultiLineToolTipUI();
    private static String BACKUP_TOOLTIPUI_CLASSNAME = null;
    private static boolean displayAccelerator = true;
    private static boolean installed = false;
    private static Object sync = new Object();
    private int accelerator_offset = 15;
    private int inset = 3;

    private MultiLineToolTipUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Object object = sync;
        synchronized (object) {
            if (installed || BACKUP_TOOLTIPUI_CLASSNAME != null) {
                return;
            }
            BACKUP_TOOLTIPUI_CLASSNAME = UIManager.getString(KEY_UIMANAGER_TOOLTIPUI_VALUE);
            UIManager.put(KEY_UIMANAGER_TOOLTIPUI_VALUE, SINGLETON.getClass().getName());
            installed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall() {
        Object object = sync;
        synchronized (object) {
            if (!installed || BACKUP_TOOLTIPUI_CLASSNAME == null) {
                return;
            }
            UIManager.put(KEY_UIMANAGER_TOOLTIPUI_VALUE, BACKUP_TOOLTIPUI_CLASSNAME);
            BACKUP_TOOLTIPUI_CLASSNAME = null;
            installed = false;
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return SINGLETON;
    }

    @Override
    public void installUI(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    @Override
    public void uninstallUI(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    public static void setDisplayAcceleratorKey(boolean val) {
        displayAccelerator = val;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = c.getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        int width = 0;
        for (int i = 0; i < num_lines; ++i) {
            String keyText;
            int onewidth = fontMetrics.stringWidth(lines[i]);
            if (displayAccelerator && i == num_lines - 1 && !"".equals(keyText = this.getAcceleratorString((JToolTip)c))) {
                onewidth += fontMetrics.stringWidth(keyText) + this.accelerator_offset;
            }
            width = Math.max(width, onewidth);
        }
        return new Dimension(width + this.inset * 2, height + this.inset * 2);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = c.getFontMetrics(font);
        Dimension dimension = c.getSize();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String tipText = ((JToolTip)c).getTipText();
        String[] lines = PlafMacros.breakupLines(tipText);
        int num_lines = lines.length;
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        int i = 0;
        int height = 2 + fontAscent;
        while (i < num_lines) {
            String keyText;
            g.drawString(lines[i], this.inset, height);
            if (displayAccelerator && i == num_lines - 1 && !"".equals(keyText = this.getAcceleratorString((JToolTip)c))) {
                Font smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                g.setFont(smallFont);
                g.drawString(keyText, fontMetrics.stringWidth(lines[i]) + this.accelerator_offset, height);
            }
            ++i;
            height += fontHeight;
        }
    }

    public String getAcceleratorString(JToolTip tip) {
        JComponent comp = tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        Object controlKeyStr = "";
        KeyStroke postTip = KeyStroke.getKeyStroke(112, 2);
        for (int i = 0; i < keys.length; ++i) {
            if (postTip.equals(keys[i])) continue;
            char c = (char)keys[i].getKeyCode();
            int mod = keys[i].getModifiers();
            if (mod == 2) {
                controlKeyStr = "Ctrl+" + c;
                break;
            }
            if (mod != 8) continue;
            controlKeyStr = "Alt+" + c;
            break;
        }
        return controlKeyStr;
    }
}

