/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.io;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ClassUtil;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.constants.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ZipJarUtil {
    private static final Log LOG = LogFactory.getLog(ZipJarUtil.class);
    public static final String PROTOCOL_ZIP = "zip";
    public static final String PROTOCOL_JAR = "jar";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_SEPARATOR = ":";
    public static final String URL_JAR_ENTRY_PREFIX = "jar:file:";
    public static final String URL_ZIP_ENTRY_PREFIX = "zip:file:";
    public static final String JARZIP_ENTRY_SEPARATOR = "!/";
    private static final int IDX_JAR_ZIP_SPEC = 0;
    private static final int IDX_ENTRY_SPEC = 1;
    private static CustomizableURLStreamHandlerFactory factory = null;

    private ZipJarUtil() {
    }

    public static synchronized void initCustomizableProtocols() {
        if (factory == null) {
            factory = new CustomizableURLStreamHandlerFactory();
            URL.setURLStreamHandlerFactory(factory);
        }
    }

    public static synchronized void removeProtocol(String protocol) {
        if (factory == null) {
            ZipJarUtil.initCustomizableProtocols();
        }
        factory.removeProtocol(protocol);
        try {
            Field f = URL.class.getDeclaredField("handlers");
            f.setAccessible(true);
            Map m = (Map)f.get(null);
            m.remove(protocol);
        }
        catch (Exception e) {
            LOG.debug((Object)"protocol not removed successfully", (Throwable)e);
        }
    }

    public static synchronized void setProtocol(String protocol, Class<? extends URLStreamHandler> handlerClass) {
        if (factory == null) {
            ZipJarUtil.initCustomizableProtocols();
        }
        factory.setProtocol(protocol, handlerClass);
    }

    private static class CustomizableURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private Map<String, Class<? extends URLStreamHandler>> protocolHandlerMap = Collections.synchronizedMap(new HashMap());
        public static final String DEFAULT_SUN_PROTOCOLS_HANDLER_PACKAGE = "sun.net.www.protocol.";
        public static final String DEFAULT_SUN_PROTOCOLS_HANDLER_CLASS_NAME = "Handler";

        CustomizableURLStreamHandlerFactory() {
            this.setProtocol(ZipJarUtil.PROTOCOL_ZIP, ZipHandler.class);
        }

        public void setProtocol(String protocol, Class<? extends URLStreamHandler> handlerClass) {
            if (ObjectUtil.isNull(handlerClass)) {
                this.removeProtocol(protocol);
            } else {
                this.protocolHandlerMap.put(protocol, handlerClass);
            }
        }

        public void removeProtocol(String protocol) {
            this.protocolHandlerMap.remove(protocol);
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            Class<Object> handlerClass = ClassUtil.forNameWithoutException(DEFAULT_SUN_PROTOCOLS_HANDLER_PACKAGE + protocol + ".Handler");
            if (handlerClass == null && this.protocolHandlerMap.containsKey(protocol)) {
                handlerClass = this.protocolHandlerMap.get(protocol);
            }
            Object handlerInstance = ClassUtil.newInstanceWithoutException(handlerClass, Constants.EMPTY_CLASS_ARRAY, Constants.EMPTY_OBJECT_ARRAY);
            AssertUtil.notNull(handlerInstance, "instance of handler");
            AssertUtil.isTrue(URLStreamHandler.class.isInstance(handlerInstance), "handler instance as URLStreamHandler");
            return (URLStreamHandler)handlerInstance;
        }
    }

    public static class ZipURLConnection
    extends URLConnection {
        public ZipURLConnection(URL url) throws MalformedURLException {
            super(url);
            if (!url.toString().startsWith(ZipJarUtil.URL_ZIP_ENTRY_PREFIX)) {
                throw new MalformedURLException("URL " + url + " does not start with expected prefix: zip:file:");
            }
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ZipInputStream result = null;
            URL url = this.url;
            Object[] spec = url.getFile().split(ZipJarUtil.JARZIP_ENTRY_SEPARATOR);
            AssertUtil.notNullOrEmpty(spec, "specification parts of URL");
            AssertUtil.equals(2, spec.length, "specification parts");
            AssertUtil.notNullOrEmpty((String)spec[0], "specification of zip");
            AssertUtil.notNullOrEmpty((String)spec[1], "specification of entry");
            URL zipFileURL = new URL((String)spec[0]);
            Object entryName = spec[1];
            ZipInputStream zis = new ZipInputStream(zipFileURL.openStream());
            ZipEntry entry = zis.getNextEntry();
            if (ObjectUtil.isNull(entry)) {
                throw new IOException("Given URL does is not referring an existing ZIP file");
            }
            do {
                if (!((String)entryName).equals(entry.getName())) continue;
                result = zis;
                break;
            } while ((entry = zis.getNextEntry()) != null);
            if (result == null) {
                zis.close();
            }
            return result;
        }
    }

    public static class ZipHandler
    extends URLStreamHandler {
        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new ZipURLConnection(url);
        }
    }
}

