/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.io;

import de.bos_bremen.common.constants.Constants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StreamUtil {
    private static final Log LOG = LogFactory.getLog(StreamUtil.class);
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final boolean READ_DEFAULT_CLOSE_INPUTSTREAM = true;

    private StreamUtil() {
    }

    public static byte[] read(InputStream stream) throws IOException {
        return StreamUtil.read(stream, true);
    }

    public static byte[] read(InputStream stream, Boolean closeInputStream) throws IOException {
        byte[] result = Constants.EMPTY_PRIMITIVE_BYTE_ARRAY;
        Boolean lCloseInputStream = closeInputStream;
        if (stream != null) {
            if (lCloseInputStream == null) {
                lCloseInputStream = true;
            }
            ByteArrayOutputStream baos = null;
            byte[] buffer = new byte[4096];
            try {
                baos = new ByteArrayOutputStream();
                int r = 0;
                while ((r = stream.read(buffer)) > 0) {
                    baos.write(buffer, 0, r);
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    if (baos != null) {
                        baos.flush();
                    }
                }
                catch (IOException e) {
                    LOG.debug((Object)"flush ByteArrayOuputStream failed, ignored", (Throwable)e);
                }
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug((Object)"close ByteArrayOuputStream failed, ignored", (Throwable)e);
                }
                try {
                    if (stream != null && lCloseInputStream.booleanValue()) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.debug((Object)"close failed, ignored", (Throwable)e);
                }
            }
            result = baos.toByteArray();
        }
        return result;
    }
}

