/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.io;

import de.bos_bremen.common.ArrayUtil;
import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.JSBRuntimeException;
import de.bos_bremen.common.ObjectUtil;
import de.bos_bremen.common.io.StreamUtil;
import de.bos_bremen.common.system.SystemPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileUtil {
    private static final Log LOG = LogFactory.getLog(FileUtil.class);
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_SEPARATOR = "://";
    public static final String URL_PROTOCOL_FILE_PREFIX = "file://";
    public static final boolean DELETE_EXCEPTION = true;
    public static final boolean DELETE_NO_EXCEPTION = false;
    public static final boolean DELETE_DEFAULT_FAIL_WITH_EXCEPTION = false;
    public static final boolean DELETE_DIRECTORY_RECURSIVE = true;
    public static final boolean DELETE_DIRECTORY_NOT_RECURSIVE = false;
    public static final boolean DELETE_DEFAULT_RECURSIVE = false;
    public static final int DELETE_DEFAULT_RETRIES = 5;

    private FileUtil() {
    }

    public static boolean delete(File file) throws JSBRuntimeException {
        return FileUtil.delete(file, false, false, 5);
    }

    public static boolean delete(File file, Boolean failWithException) throws JSBRuntimeException {
        return FileUtil.delete(file, failWithException, false, 5);
    }

    public static boolean delete(File file, Boolean failWithException, Boolean recursive, Integer retries) throws IllegalArgumentException, JSBRuntimeException {
        if (ObjectUtil.notNull(retries)) {
            AssertUtil.positive(retries, "retries");
        }
        Boolean lFailWithException = failWithException;
        Boolean lRecursive = recursive;
        Integer lRetries = retries;
        boolean result = true;
        if (file != null && file.exists()) {
            result = false;
            if (lFailWithException == null) {
                lFailWithException = false;
            }
            if (lRecursive == null) {
                lRecursive = false;
            }
            if (lRetries == null) {
                lRetries = 5;
            }
            boolean empty = FileUtil.isEmpty(file);
            if (file.isFile() || empty) {
                result = FileUtil.delete(file, lRetries);
            } else if (lRecursive.booleanValue()) {
                Object[] files = file.listFiles();
                if (!ArrayUtil.isNullOrEmpty(files)) {
                    File f;
                    ArrayList<Object> listFiles = new ArrayList<Object>();
                    listFiles.addAll(Arrays.asList(files));
                    Collections.sort(listFiles, new Comparator<File>(){

                        @Override
                        public int compare(File o1, File o2) {
                            return o1.isDirectory() && o2.isDirectory() ? 0 : (o1.isFile() ? 1 : -1);
                        }
                    });
                    Iterator iterator = listFiles.iterator();
                    while (iterator.hasNext() && (result = FileUtil.delete(f = (File)iterator.next(), lFailWithException, lRecursive, lRetries))) {
                    }
                }
                if (result) {
                    result = FileUtil.delete(file, lRetries);
                }
            } else {
                result = false;
            }
            if (lFailWithException.booleanValue() && !result) {
                throw new JSBRuntimeException("deleting " + file + " failed");
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean delete(File file, Integer retries) throws IllegalArgumentException {
        if (ObjectUtil.notNull(retries)) {
            AssertUtil.positive(retries, "retries");
        }
        Integer lRetries = retries;
        boolean result = true;
        if (file == null || !file.exists()) return result;
        if (ObjectUtil.isNull(lRetries)) {
            lRetries = 5;
        }
        result = false;
        if (!file.isFile() && (!file.isDirectory() || !FileUtil.isEmpty(file))) return result;
        while (file.exists() && !result && lRetries >= 0) {
            try {
                result = file.delete();
            }
            catch (Throwable t) {
                LOG.debug((Object)"ignored delete failed", t);
            }
            Integer n = lRetries;
            Integer n2 = lRetries = Integer.valueOf(lRetries - 1);
        }
        return result;
    }

    public static boolean isEmpty(File file) {
        boolean result = true;
        if (file != null && file.exists()) {
            File[] files;
            result = file.isDirectory() ? (files = file.listFiles()) == null || files.length == 0 : file.length() == 0L;
        }
        return result;
    }

    public static byte[] readBytesOfFile(File file) throws IllegalArgumentException, FileNotFoundException, IOException {
        AssertUtil.notNull(file, URL_PROTOCOL_FILE);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("directory not permitted");
        }
        return StreamUtil.read(new FileInputStream(file));
    }

    public static byte[] readBytesOfFile(String filename) throws IllegalArgumentException, FileNotFoundException, IOException {
        AssertUtil.notNullOrEmpty(filename, "filename");
        File file = new File(filename);
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("directory not permitted");
        }
        return StreamUtil.read(new FileInputStream(file));
    }

    public static File to(URL fileURL) throws IllegalArgumentException {
        AssertUtil.notNull(fileURL, "URL");
        AssertUtil.equals(fileURL.getProtocol(), URL_PROTOCOL_FILE, "protocol");
        String filename = fileURL.getFile();
        return new File(filename);
    }

    public static URL to(File file) {
        AssertUtil.notNull(file, URL_PROTOCOL_FILE);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.debug((Object)"URL for file malformed", (Throwable)e);
            return null;
        }
    }

    public static File getUserDirectory() {
        return new File(SystemPropertyUtil.getUserHome());
    }
}

