/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.common.crypto;

import de.bos_bremen.common.AssertUtil;
import de.bos_bremen.common.ByteUtil;
import de.bos_bremen.common.asn1.ASN1;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class ECDSASignatureConverter {
    private static final Log LOG = LogFactory.getLog(ECDSASignatureConverter.class);

    private ECDSASignatureConverter() {
    }

    public static int getIntegerEncodingLength(ECPublicKey publicKey) throws IllegalArgumentException {
        AssertUtil.notNull(publicKey, "public key");
        if (BCECPublicKey.class.isInstance(publicKey)) {
            BCECPublicKey ecPublicKey = (BCECPublicKey)BCECPublicKey.class.cast(publicKey);
            return ((ECFieldFp)ecPublicKey.getParams().getCurve().getField()).getP().bitLength() / 8;
        }
        if (ECPublicKey.class.isInstance(publicKey)) {
            ECPublicKey ecPublicKey = (ECPublicKey)ECPublicKey.class.cast(publicKey);
            return ((ECFieldFp)ecPublicKey.getParams().getCurve().getField()).getP().bitLength() / 8;
        }
        if (!JCEECPublicKey.class.isInstance(publicKey)) {
            throw new IllegalArgumentException("not supported ECPublicKey: " + JCEECPublicKey.class.getName() + " only supported");
        }
        JCEECPublicKey ecPublicKey = (JCEECPublicKey)JCEECPublicKey.class.cast(publicKey);
        return ((ECFieldFp)ecPublicKey.getParams().getCurve().getField()).getP().bitLength() / 8;
    }

    public static byte[] toX9_62(byte[] signature) throws IllegalArgumentException, IOException {
        AssertUtil.notNullOrEmpty(signature, "signature");
        AssertUtil.isTrue(signature.length % 2 == 0, "signature length not even");
        int order = signature.length / 2;
        byte[] integer1 = null;
        byte[] integer2 = null;
        int offset = 0;
        if ((signature[offset] & 0xFFFFFF80) == -128) {
            integer1 = new byte[order + 1];
            integer1[0] = 0;
            System.arraycopy(signature, offset, integer1, 1, order);
        } else {
            integer1 = new byte[order];
            System.arraycopy(signature, offset, integer1, 0, order);
            while (integer1.length > 1 && integer1[0] == 0 && (integer1[1] & 0x80) == 0) {
                integer1 = ByteUtil.removeLeadingZero(integer1);
            }
        }
        offset = order;
        if ((signature[offset] & 0xFFFFFF80) == -128) {
            integer2 = new byte[order + 1];
            integer2[0] = 0;
            System.arraycopy(signature, offset, integer2, 1, order);
        } else {
            integer2 = new byte[order];
            System.arraycopy(signature, offset, integer2, 0, order);
            while (integer2.length > 1 && integer2[0] == 0 && (integer2[1] & 0x80) == 0) {
                integer2 = ByteUtil.removeLeadingZero(integer2);
            }
        }
        ASN1 asn1integer1 = new ASN1(2, integer1);
        ASN1 asn1integer2 = new ASN1(2, integer2);
        ASN1 asn1sequence = new ASN1(48, new byte[0]);
        asn1sequence.addChildElement(asn1integer1, asn1sequence);
        asn1sequence.addChildElement(asn1integer2, asn1sequence);
        return asn1sequence.getEncoded();
    }

    public static byte[] toPlain(byte[] signature, ECPublicKey pk) throws IllegalArgumentException, IOException {
        return ECDSASignatureConverter.toPlain(signature, ECDSASignatureConverter.getIntegerEncodingLength(pk));
    }

    public static byte[] toPlain(byte[] signature, int length) throws IllegalArgumentException, IOException {
        int i;
        AssertUtil.notNullOrEmpty(signature, "signature");
        AssertUtil.positive(length, "key length");
        ASN1 asn1 = new ASN1(signature);
        if (!asn1.isSequence()) {
            throw new IllegalArgumentException("ASN.1 structure is no sequence -> no signature");
        }
        if (asn1.getChildElementCount() != 2) {
            throw new IllegalArgumentException("ASN.1 sequence contains unexpected number of children -> no signature");
        }
        ASN1 child1 = asn1.getChildElementList().get(0);
        ASN1 child2 = asn1.getChildElementList().get(1);
        BigInteger intTag = new BigInteger(new byte[]{2});
        if (!intTag.equals(child1.getTag()) || !intTag.equals(child2.getTag())) {
            throw new IllegalArgumentException("children of sequence are non-integer -> no signature");
        }
        byte[] integer1 = child1.getValue();
        byte[] integer2 = child2.getValue();
        if (integer1.length - length > 0) {
            for (i = 0; i < integer1.length - length; ++i) {
                if (integer1[i] == 0) continue;
                throw new IllegalArgumentException("signature will be corrupted when converting to given length");
            }
        }
        if (integer2.length - length > 0) {
            for (i = 0; i < integer2.length - length; ++i) {
                if (integer2[i] == 0) continue;
                throw new IllegalArgumentException("signature will be corrupted when converting to given length");
            }
        }
        byte[] convertedSignature = new byte[length * 2];
        System.arraycopy(integer1, Math.max(0, integer1.length - length), convertedSignature, Math.max(0, length - integer1.length), length - Math.max(0, length - integer1.length));
        System.arraycopy(integer2, Math.max(0, integer2.length - length), convertedSignature, length + Math.max(0, length - integer2.length), length - Math.max(0, length - integer2.length));
        return convertedSignature;
    }

    public static byte[] cmsPlainToX9_62(byte[] cmsMessage) throws CMSException, CertificateException, IOException {
        CMSSignedData cmsSignedDataParser = new CMSSignedData((InputStream)new ByteArrayInputStream(cmsMessage));
        SignerInformationStore signerInfos = cmsSignedDataParser.getSignerInfos();
        Store certificateStore = cmsSignedDataParser.getCertificates();
        Collection signers = signerInfos.getSigners();
        for (SignerInformation signer : signers) {
            Collection collectionCertificateHolders = certificateStore.getMatches((Selector)signer.getSID());
            Iterator iterator = collectionCertificateHolders.iterator();
            if (!iterator.hasNext()) continue;
            X509CertificateHolder certificateHolder = (X509CertificateHolder)iterator.next();
            LOG.debug((Object)certificateHolder);
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateHolder.getEncoded()));
            LOG.debug((Object)certificate);
            LOG.debug((Object)certificate.getPublicKey());
            LOG.debug((Object)new BigInteger(1, signer.getSignature()).toString(16));
            byte[] convertedSignature = ECDSASignatureConverter.toX9_62(signer.getSignature());
            LOG.debug((Object)("converted: " + new BigInteger(1, convertedSignature).toString(16)));
            ASN1 asn1CMS = new ASN1(cmsMessage);
            LOG.debug((Object)("CMS child count: " + asn1CMS.getChildElementCount()));
            ASN1 asn1Set = asn1CMS.getChildElementList().get(1);
            LOG.debug((Object)("CMS first child children count: " + asn1Set.getChildElementCount()));
            ASN1 asn1Sequence = asn1Set.getChildElementList().get(0);
            LOG.debug((Object)("CMS first child first child children count:" + asn1Sequence.getChildElementCount()));
            ASN1 asn1Sequence2 = asn1Sequence.getChildElementList().get(asn1Sequence.getChildElementCount() - 1);
            LOG.debug((Object)("CMS first child first child last child children count: " + asn1Sequence2.getChildElementCount()));
            ASN1 asn1Sequence3 = asn1Sequence2.getChildElementList().get(asn1Sequence2.getChildElementCount() - 1);
            LOG.debug((Object)("CMS first child first child last child last child children count: " + asn1Sequence3.getChildElementCount()));
            ASN1 asn1SignatureValue = asn1Sequence3.getChildElementList().get(asn1Sequence3.getChildElementCount() - 1);
            asn1SignatureValue.setValueBytes(convertedSignature, asn1CMS);
            LOG.debug((Object)("signature value: " + asn1SignatureValue));
            return asn1CMS.getEncoded();
        }
        return null;
    }
}

